{*************************************************************
*   Ejemplo de uso del metodo Assign implementado en TList.  *
*   Realizado el 11 de Julio del 2001 para la artculo sobre *
*  Objetos Auxiliares Parte II.                              *
*   Autor: Salvador Jover   mailto: dejover@eresmas.com      *
*                                                            *
*                                                            *
*   Revista Sintesis N 4   http://www.GrupoAlbor.com/           *
**************************************************************}


{*************************************************************
Nota Importante:
Si os fijais detenidamente, en este ejemplo, hay un detalle muy
importante que debe tenerse en cuenta. Podramos pensar que
Lista A pudiera reservar memoria para los elementos que pudiera
contener, y as mismo, llevar ese razonamiento a Lista B
simultaneamente, reservando memoria tambin. En esas condiciones
intentar operar con ambas listas, no cumplira el objetivo para
el que se implementado la funcin y el resultado sera erroneo.

Me explico:
Supongamos que Lista A contendr los siguientes enteros: 1, 2, 3,
4, y 5. Hemos hecho reserva de memoria para los mismos antes de
insertarlos en la lista.
Luego hacemos lo propio con lista B, para los enteros 3, 4 y 6.
(reservando memoria tambien para cada uno de los elementos).

Cuando sea invocado el metodo Assign, en todas las operaciones
menos en 'laCopy' evaluar
        if LSource.IndexOf(Items[I]) = -1 then
A su vez IndexOf, mantendr un blucle mientras se cumplan dos
condiciones:
     While (Result < FCount) and (FList^[Result] <> Item)

Pues bien, en las condiciones dichas, el resultado de evaluar
(F^List[Result] <> Item) siempre ser True, pues aunque el
contenido al que apunta la direccin de memoria sea el mismo,
las direcciones sern distintas, y en este cas lo que se
evalua son las direcciones y no el contenido. As que siempre,
acabar la funcin devolviendo como resultado -1, que es el
valor ltimo al finalizar el recorrido de todos los elementos.

Resumiendo: la pregunta que debemos hacernos al operar con dos
listas no es si ambas tienen elementos con mismo contenido,
sino si ambas estan operando con los mismos elementos, o dicho
de otra forma, si existen elementos en ambas listas que apuntan
a las mismas direcciones de memoria.
Eso es lo que nos ha de devolver dicha operatoria.
**************************************************************}

unit Assign;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  //tipos de operacion
  TListAssignOp = (laCopy, laAnd, laOr, laXor, laSrcUnique, laDestUnique);

{Nota:
  Para poder comprobar el funcionamiento del procedimiento Assign
  sobre Delphi 5, lo que haremos es crear una nueva clase, descendiente
  de TList, en la que declaramos el nuevo procedimiento.}

  TListaModificada = class(TList)
  public
  procedure Assign(ListA: TList; AOperator: TListAssignOp = laCopy; ListB: TList = nil);
  end;

  Tfrm_Assign = class(TForm)
    Edit2: TEdit;
    Edit3: TEdit;
    Edit4: TEdit;
    Edit5: TEdit;
    Edit6: TEdit;
    btn_Assign: TButton;
    edi_Resultado1: TEdit;
    edi_Resultado2: TEdit;
    edi_Resultado3: TEdit;
    edi_Resultado4: TEdit;
    edi_Resultado5: TEdit;
    edi_Resultado6: TEdit;
    cbx_operacion: TComboBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    chx_ListaB: TCheckBox;
    Edit1: TEdit;
    Bevel1: TBevel;
    lab_Informacion: TLabel;
    Bevel2: TBevel;
    procedure btn_AssignClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frm_Assign: Tfrm_Assign;

  implementation

{$R *.DFM}

// implementacin que hace Borland del metodo Assign de TList

procedure TListaModificada.Assign(ListA: TList; AOperator: TListAssignOp; ListB: TList);
var
  I: Integer;
  LTemp, LSource: TList;
begin
  // ListB given?
  if ListB <> nil then
    begin
    LSource := ListB;
    Assign(ListA);
    end
  else
    LSource := ListA;

  // on with the show
  case AOperator of

    // 12345, 346 = 346 : only those in the new list
    laCopy:
      begin
        Clear;
        Capacity := LSource.Capacity;
        for I := 0 to LSource.Count - 1 do
          Add(LSource[I]);
      end;

    // 12345, 346 = 34 : intersection of the two lists
    laAnd:
      for I := Count - 1 downto 0 do
        if LSource.IndexOf(Items[I]) = -1 then
          Delete(I);

    // 12345, 346 = 123456 : union of the two lists
    laOr:
      for I := 0 to LSource.Count - 1 do
       if IndexOf(LSource[I]) = -1 then
          Add(LSource[I]);

    // 12345, 346 = 1256 : only those not in both lists
    laXor:
      begin
        LTemp := TListaModificada.Create;  // Temp holder of 4 byte values
        try
          LTemp.Capacity := LSource.Count;
          for I := 0 to LSource.Count - 1 do
            if IndexOf(LSource[I]) = -1 then
              LTemp.Add(LSource[I]);
          for I := Count - 1 downto 0 do
            if LSource.IndexOf(Items[I]) <> -1 then
              Delete(I);
          I := Count + LTemp.Count;
          if Capacity < I then
            Capacity := I;
          for I := 0 to LTemp.Count - 1 do
            Add(LTemp[I]);
        finally
          LTemp.Free;
        end;
      end;

    // 12345, 346 = 125 : only those unique to source
    laSrcUnique:
      for I := Count - 1 downto 0 do
        if LSource.IndexOf(Items[I]) <> -1 then
          Delete(I);

    // 12345, 346 = 6 : only those unique to dest
    laDestUnique:
      begin
        LTemp := TListaModificada.Create;
        try
          LTemp.Capacity := LSource.Count;
          for I := LSource.Count - 1 downto 0 do
            if IndexOf(LSource[I]) = -1 then
              LTemp.Add(LSource[I]);
          Assign(LTemp);
        finally
          LTemp.Free;
        end;
      end;
  end;
end;

//*************** frm_Assign ****************************


procedure Tfrm_Assign.btn_AssignClick(Sender: TObject);
var
Lista_A,Lista_B: TList; // las dos listas sobre las que operaremos
Lista_Destino: TListaModificada; // lista que nos recoger el resultado
eleccion: TlistAssignOp; // nos recoge la eleccin hecha
begin
// Limpiamos cualquier resultado anterior de los Tedit para resultados
edi_Resultado1.Clear;
edi_Resultado2.Clear;
edi_Resultado3.Clear;
edi_Resultado4.Clear;
edi_Resultado5.Clear;
edi_Resultado6.Clear;

//creamos las dos listas sobre las que operaremos
Lista_A:= TList.Create;
Lista_B:= TList.Create;
Lista_Destino:= TListaModificada.Create;

try
{aadimos nuevos elementos a las listas apuntando a los 6
objetos TEdit que contienen texto -en la parte superior- }

        Lista_A.Add(Edit1);
        Lista_A.Add(Edit2);
        Lista_A.Add(Edit3);
        Lista_A.Add(Edit4);
        Lista_A.Add(Edit5);

        Lista_B.Add(Edit3);
        Lista_B.Add(Edit4);
        Lista_B.Add(Edit6);

{Una vez que tenemos la lista A y B con los elementos que van
a contener, podemos pasar a operar con ellas}

 //**********************************
        eleccion:= laCopy; // eleccion por defecto
        case cbx_operacion.itemindex of
          0: eleccion:= laCopy;
          1: eleccion:= laAnd;
          2: eleccion:= laOr;
          3: eleccion:= laXor;
          4: eleccion:= laSrcUnique;
          5: eleccion:= laDestUnique;
        end;


        if chx_ListaB.Checked then //si esta marcada
          Lista_Destino.Assign(Lista_A, eleccion, Lista_B) //tenemos en cuenta ListaB
        else               //en caso contrario
          Lista_Destino.Assign(Lista_A, eleccion); //solo tenemos en cuenta lista A

{Traspasamos a las 6 casillas de edicin de la parte inferior,
el resultado obtenido de la operacin, que sern en definitiva
los elementos que forman parte de la lista destino}

        if Lista_Destino.Count > 0 then
          edi_Resultado1.Text:= TEdit(Lista_Destino.Items[0]).text;
        if Lista_Destino.Count > 1 then
          edi_Resultado2.Text:= TEdit(Lista_Destino.Items[1]).text;
        if Lista_Destino.Count > 2 then
          edi_Resultado3.Text:= TEdit(Lista_Destino.Items[2]).text;
        if Lista_Destino.Count > 3 then
          edi_Resultado4.Text:= TEdit(Lista_Destino.Items[3]).text;
        if Lista_Destino.Count > 4 then
          edi_Resultado5.Text:= TEdit(Lista_Destino.Items[4]).text;
        if Lista_Destino.Count > 5 then
          edi_Resultado6.Text:= TEdit(Lista_Destino.Items[5]).text;


finally
  Lista_A.Free; // destruimos finalmente las listas
  Lista_B.Free;
  Lista_Destino.free;
end;
end;

procedure Tfrm_Assign.FormCreate(Sender: TObject);
begin
cbx_operacion.ItemIndex:= 0;  //seleccionamos el primer elemento
with lab_informacion do
  begin
  Top:= 176;
  Left:= 16;
  Caption:= 'Lista A se compone de Edit1, Edit2, Edit3, Edit4, Edit 5 y' + #13 +
            'Lista B se compone de Edit3, Edit4 y Edit6.';
  end;
end;

end.
