{*************************************************************
**************************************************************
*    Ejemplo de uso de varios mtodos de TStrings            *
*   Realizado el 09 de Enero del 2002 para la artculo sobre *
*   Objetos Auxiliares Parte V.                              *
*   Autor: Salvador Jover   mailto: dejover@eresmas.com      *
*                                                            *
*                                                            *
*   Revista Sintesis N 7   http://www.GrupoAlbor.com/       *
**************************************************************
**************************************************************}

unit Datos;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Db, Grids, DBGrids, Buttons, ExtCtrls;

type
   //Definimos los posibles estados que permitimos
   TEstado = (esInactivo, esNavegar, esEditar, esInsertar, esBorrar);

  TfrmDatos = class(TForm)
    panCabecera: TPanel;
    edi_Texto: TEdit;
    edi_Valor: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Panel1: TPanel;
    spb_Primero: TSpeedButton;
    spb_Anterior: TSpeedButton;
    spb_Posterior: TSpeedButton;
    spb_Ultimo: TSpeedButton;
    bib_Nuevo: TBitBtn;
    bib_Validar: TBitBtn;
    bib_Borrar: TBitBtn;
    lab_Contador: TLabel;
    lab_Estado: TLabel;
    Bevel1: TBevel;
    stg_Tabla: TStringGrid;
    Timer1: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure spb_PrimeroClick(Sender: TObject);
    procedure spb_AnteriorClick(Sender: TObject);
    procedure spb_PosteriorClick(Sender: TObject);
    procedure spb_UltimoClick(Sender: TObject);
    procedure bib_ValidarClick(Sender: TObject);
    procedure bib_BorrarClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure bib_NuevoClick(Sender: TObject);
    procedure edi_TextoKeyPress(Sender: TObject; var Key: Char);
    procedure edi_TextoKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure stg_TablaDrawCell(Sender: TObject; ACol, ARow: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure edi_TextoExit(Sender: TObject);
    procedure edi_ValorKeyPress(Sender: TObject; var Key: Char);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Timer1Timer(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure stg_TablaClick(Sender: TObject);
    procedure stg_TablaDblClick(Sender: TObject);
    procedure edi_TextoEnter(Sender: TObject);
  private
    { Private declarations }
     Listatemp: TStringList;  // Un "hijo" de nuestra protagonista
     Itemindex: Integer;      // nos inventamos un indice para movernos
                              // a traves de la matriz
                              // OJO: es importante (POR DECISIN PROPIA)
                              // ESTE INDICE representa la fila a la que
                              // hacemos referencia. Hay que tener mucho cuidado
                              // con esto, pues es uno de los problemas que
                              // primero aparecen al intentar leer fuera del
                              // rango de la matriz (el primer elemento toma
                              // como indice 0 y puede dar lugar a confusin.
                              // ASI PUES HEMOS ESTABLECIDO ESE CONVENIO
     Estado: TEstado;   // necesitamos una variable que almacene el estado actual
     //Esta funcin nos muestra como podemos sacar provecho a las propiedades
     // Names y Values
     function Situarse(Index1,Index2: Integer):String;
     {Los siguientes procedimientos nos ayudan a mantener consistente el estado
     de nuestro "Introductor de Datos"}
     procedure ActualizarEstado(index: Integer);
     procedure EstadoInicial;
     procedure HazEdicion;
     procedure HazInsercion;
     procedure HazNavegacion;
     procedure HazCancelacion;
     // al borrar un elemento de la matriz necesitamos eliminarlo tambin
     // de nuestro componente StringGrid para lo que, dado que no podemos
     // acceder a la mayora de mtodos protegidos que mantiene, salvo que
     // los redefinieramos, optamos por rehacer la tabla a partir del indice
     // que nos encontremos
     procedure CopiaTabla(index: integer);//copia la tabla a partir de un indice
  public
    { Public declarations }
  end;

var
  frmDatos: TfrmDatos;

implementation


{$R *.DFM}

//--------------------------------------------------------------
// EVENTO: FormCreate
//
// ACCION: Al crearse la ventana de nuestra aplicacin necesitamos
//         inicializar todos los valores de propiedades que mantienen
//         la consistencia. Debemos de partir de un estado consistente
//
procedure TfrmDatos.FormCreate(Sender: TObject);
begin
   //Creamos la lista de cadenas sobre la que vamos a trabajar
   listatemp:= TStringList.Create;
   stg_Tabla.Cells[0,0]:= '                                       CONCEPTO';
   stg_Tabla.Cells[1,0]:= '    VALOR';
   EstadoInicial;
   Timer1Timer(Timer1);
end;


//--------------------------------------------------------------
// EVENTO: FormDestroy
//
// ACCION: Se destruyen aquellos objetos creados dinmicamente
//         Debemos asegurarnos si se reserva memoria dinmica que es
//         liberada. Esto es obligado si no queremos sorpresas
//
procedure TfrmDatos.FormDestroy(Sender: TObject);
begin
   listatemp.Free;
end;


//--------------------------------------------------------------
// PROCEDIMIENTO: Estado Inicial
//
// ACCION: Este procedimiento es utilizado por cualquier otro procedimiento
//         de nuestra aplicacin para restaurar los valores iniciales que
//         siempre son constantes.
//         Se dejan fuenra de el aquellos que pueden modificarse por razn
//         de la posicin del indice Itemindex, como por ejemplo los botones
//         de navegacin
//
procedure TfrmDatos.EstadoInicial;
begin
   //Definimos el estado valido inicial
   estado:= esInactivo;
   itemindex:= 0; //todava no existe ningn registro en nuestro editor
   //inicializamos las etiquetas informativas del estado actual
   lab_Contador.Caption:= '0/0';
   lab_Estado.caption:= 'SIN REGISTROS';
   //inicializamos los cuadro de edicin de entrada de registros
   edi_Texto.text:= '';
   edi_Texto.Enabled:= false;
   edi_Valor.text:= '';
   edi_Valor.Enabled:= false;
   //inicializamos los controles de navegacin
   spb_Primero.enabled:= false;
   spb_Anterior.enabled:= false;
   spb_Posterior.enabled:= false;
   spb_Ultimo.enabled:= false;
   //inicializamos los controles de manipulacin de datos
   bib_Nuevo.enabled:= true;
   bib_Validar.enabled:= false;
   bib_Borrar.enabled:= false;
end;


//--------------------------------------------------------------
// PROCEDIMIENTO: HazEdicion
//
// ACCION: Este procedimiento es utilizado por cualquier otro procedimiento
//         de nuestra aplicacin para restaurar los valores iniciales en
//         el estado de EDICION.
//         Se dejan fuera de el aquellos que pueden modificarse por razn
//         de la posicin del indice Itemindex, como por ejemplo los botones
//         de navegacin
//
procedure TfrmDatos.HazEdicion;
begin
   estado:= esEditar;
   lab_Estado.caption:= 'EDICION';
   //actualizamos el estado de los controles de navegacin
   spb_Primero.enabled:= false;
   spb_Anterior.enabled:= false;
   spb_Posterior.enabled:= false;
   spb_Ultimo.enabled:= false;
   //actualizamos el estado de los controles de manipulacin de datos
   bib_Nuevo.enabled:= false;
   bib_Validar.enabled:= true;
   bib_Borrar.enabled:= false;
   stg_tabla.Enabled:= false;
end;


//--------------------------------------------------------------
// PROCEDIMIENTO: HazInsercion
//
// ACCION: Este procedimiento es utilizado por cualquier otro procedimiento
//         de nuestra aplicacin para restaurar los valores iniciales en
//         el estado de INSERCION.
//         Se dejan fuera de el aquellos que pueden modificarse por razn
//         de la posicin del indice Itemindex, como por ejemplo los botones
//         de navegacin
//
procedure TfrmDatos.HazInsercion;
begin
   estado:= esInsertar;
   lab_Estado.caption:= 'INSERCION';
   //actualizamos el estado de los controles de navegacin
   spb_Primero.enabled:= false;
   spb_Anterior.enabled:= false;
   spb_Posterior.enabled:= false;
   spb_Ultimo.enabled:= false;
   //actualizamos el estado de los controles de manipulacin de datos
   bib_Nuevo.enabled:= false;
   bib_Validar.enabled:= true;
   bib_Borrar.enabled:= false;
end;


//--------------------------------------------------------------
// PROCEDIMIENTO: HazNavegacion
//
// ACCION: Este procedimiento es utilizado por cualquier otro procedimiento
//         de nuestra aplicacin para restaurar los valores iniciales en
//         el estado de NAVEGACION. Es equivalente al <dsBrowse>
//         Se dejan fuera de el aquellos que pueden modificarse por razn
//         de la posicin del indice Itemindex, como por ejemplo los botones
//         de navegacin
//
procedure TfrmDatos.HazNavegacion;
begin
   estado:= esNavegar;
   lab_Estado.caption:= 'NAVEGACION';
   //actualizamos el estado de los controles de navegacin
   spb_Primero.enabled:= true;
   spb_Anterior.enabled:= true;
   spb_Posterior.enabled:= true;
   spb_Ultimo.enabled:= true;
   //actualizamos el estado de los controles de manipulacin de datos
   bib_Nuevo.enabled:= true;
   bib_Validar.enabled:= false;
   bib_Borrar.enabled:= true;
   stg_tabla.Enabled:= true;
end;


//--------------------------------------------------------------
// PROCEDIMIENTO: HazCancelacion
//
// ACCION: Este procedimiento es utilizado por cualquier otro procedimiento
//         de nuestra aplicacin para restaurar los valores iniciales tras
//         cancelar la ejecucin de una accin.
//         Se dejan fuera de el aquellos que pueden modificarse por razn
//         de la posicin del indice Itemindex, como por ejemplo los botones
//         de navegacin
//
procedure TfrmDatos.HazCancelacion;
begin
   {SOLO PARA EL CASO DE QUE NOS ENCONTREMOS EDITANDO UN REGISTRO}
   if (estado = esEditar) then
      begin //reponemos los valores originales
      edi_texto.text:= Situarse(0, itemindex);
      edi_valor.text:= Situarse(1, itemindex);
      HazNavegacion; //Volvemos al estado original
      ActualizarEstado(itemindex);
      end;
   {SOLO PARA EL CASO DE QUE NOS ENCONTREMOS INSERTANDO UN REGISTRO}
   if (estado = esInsertar) then
      begin //reponemos los valores originales
      listatemp.Delete(itemindex-1);
      // si se produce la cancelacin se procede a decrecer el indice
      if (itemindex > 1) and (listatemp.Count >= 1) and (listatemp.count < itemindex) then Dec(itemindex);
      // ojo.. en este caso estamos al principio y no podemos decrecer pero
      // si debemos fijar a 0
      if (itemindex = 1) and (listatemp.Count = 0) then itemindex:= 0;

      if itemindex = 0 then    //si no hay filas
         begin //reponemos el estado inicial o inactivo
         edi_texto.Text:= '';
         edi_valor.text:= '';
         EstadoInicial;
         stg_tabla.rowcount:= 2;  // modificamos la tabla
         stg_tabla.row:= 1;
         end
      else
         begin //reponemos el estado de navegacion
         edi_texto.text:= Situarse(0, itemindex);
         edi_valor.Text:= Situarse(1, itemindex);
         stg_tabla.cells[0, itemindex]:= edi_texto.text; //modificamos la tabla
         stg_tabla.cells[1, itemindex]:= edi_valor.text;
         stg_tabla.rowcount:= stg_tabla.RowCount - 1;
         HazNavegacion;
         end;
      ActualizarEstado(itemindex)
      end;
end;


//--------------------------------------------------------------
// FUNCION: Situarse
//
// PARAMETROS: Index1, Index2 de tipo Integer
//
// ACCION: Nosotros almacenamos en cada elemento de nuestro StringList
//         cadenas con el formato  CONCEPTO=VALOR
//         Index1 representa un selector y nos permite elegir cual
//         de las dos funciones ha de ejecutarse. Con valor 0 nos devuelve
//         VALOR y con valor 1 nos devuelve el parmetro CONCEPTO
//         Sobre esto dos posibibles retornos Index2 nos elige cual
//         de las elementos de la matriz afectamos, recorriendo toda la
//         matriz como DOMINIO
//         Aqu se muestra un posible uso de las propiedades NAMES y VALUES
//         que pasan en ocasiones desapercibidas
//

           {Nota: Se debera proteger este procedimiento previniendo
            que el indice no desborde la matriz generando una excepcin.
            Vimos la forma en la que Borland nos enseaba a hacerlo durante
            los artculos anteriores}
function TfrmDatos.Situarse(Index1,Index2: Integer):String;
begin
   if index2 > 0 then
      begin
      case index1 of
      0:   Result:= listatemp.Names[index2-1];
      1:   Result:= listatemp.Values[listatemp.Names[index2-1]];
      end;
      end
   else
      Result:= '';
end;


//--------------------------------------------------------------
// PROCEDIMIENTO: ActualizarEstado
//
// PARAMETROS: Index1 de tipo Integer
//
// ACCION: Mantiene la consistencia de la aplicacin. Recibe como parmetro
//         el elemento sobre el que debe actuar. Son principalmente controles
//         de navegacin y su valor activacin o no, depende de la posicin en
//         la que nos encontremos.
//
procedure TfrmDatos.ActualizarEstado(index: Integer);
begin
   if index < 1 then
      begin   //no hay filas
      spb_primero.enabled:= false;
      spb_anterior.enabled:= false;
      spb_posterior.enabled:= false;
      spb_ultimo.enabled:= false;
      bib_validar.enabled:= false;
      bib_nuevo.enabled:= true;
      bib_borrar.enabled:= false;
      lab_Contador.Caption:= '0/0';
      edi_texto.Enabled:= false;
      edi_valor.Enabled:= false;
      end;
   if (index = 1) and (listatemp.Count = 1) then
      begin
      spb_primero.enabled:= false;
      spb_anterior.enabled:= false;
      spb_posterior.enabled:= false;
      spb_ultimo.enabled:= false;
      lab_Contador.Caption:= IntToStr(1)+'/'+IntToStr(1);
      edi_texto.Enabled:= true;
      edi_valor.Enabled:= true;
     end;
   if (index = 1) and (listatemp.Count > 1) then
      begin
      spb_primero.enabled:= false;
      spb_anterior.enabled:= false;
      spb_posterior.enabled:= true;
      spb_ultimo.enabled:= true;
      lab_Contador.Caption:= IntToStr(itemindex)+'/'+IntToStr(listatemp.Count);
      edi_texto.Enabled:= true;
      edi_valor.Enabled:= true;
     end;
   if (index > 1) and (index < listatemp.Count) then
      begin
      spb_primero.enabled:= true;
      spb_anterior.enabled:= true;
      spb_posterior.enabled:= true;
      spb_ultimo.enabled:= true;
      lab_Contador.Caption:= IntToStr(itemindex)+'/'+IntToStr(listatemp.Count);
      edi_texto.Enabled:= true;
      edi_valor.Enabled:= true;
     end;
   if (not (index = 0)) and (not (index = 1)) and (index = listatemp.Count) then
      begin
      spb_primero.enabled:= true;
      spb_anterior.enabled:= true;
      spb_posterior.enabled:= false;
      spb_ultimo.enabled:= false;
      lab_Contador.Caption:= IntToStr(itemindex)+'/'+IntToStr(listatemp.Count);
      edi_texto.Enabled:= true;
      edi_valor.Enabled:= true;
      end;
end;


{PROCEDIMIENTOS QUE AFECTAN A LA NAVEGACION DENTRO DE LA MATRIZ:
 PRIMERO-ANTERIOR-POSTERIOR-ULTIMO}


//--------------------------------------------------------------
// PROCEDIMIENTO: spb_PrimeroClick PRIMERO
//
// ACCION: Ir al primer elemento de la tabla
//
procedure TfrmDatos.spb_PrimeroClick(Sender: TObject);
begin
   itemindex:= 1;
   edi_texto.text:= Situarse(0, itemindex);
   edi_valor.text:= Situarse(1, itemindex);
   stg_tabla.row:= 1;
   ActualizarEstado(itemindex)
end;


//--------------------------------------------------------------
// PROCEDIMIENTO: spb_AnteriorClick ANTERIOR
//
// ACCION: Ir al elemento anterior
//
procedure TfrmDatos.spb_AnteriorClick(Sender: TObject);
begin
   if itemindex > 1 then
      begin
      edi_texto.text:= Situarse(0, itemindex - 1);
      edi_valor.text:= Situarse(1, itemindex - 1);
      itemindex := itemindex - 1;
      stg_tabla.row:= itemindex;
      ActualizarEstado(itemindex)
      end;
end;

//--------------------------------------------------------------
// PROCEDIMIENTO: spb_PosteriorClick POSTERIOR
//
// ACCION: Ir al elemento posterior
//
procedure TfrmDatos.spb_PosteriorClick(Sender: TObject);
begin
   if itemindex < listatemp.count then
      begin
      edi_texto.text:= Situarse(0, itemindex + 1);
      edi_valor.text:= Situarse(1, itemindex + 1);
      itemindex := itemindex + 1;
      ActualizarEstado(itemindex);
      stg_tabla.row:= itemindex;
      end;
end;


//--------------------------------------------------------------
// PROCEDIMIENTO: spb_UltimoClick ULTIMO
//
// ACCION: Ir al ltimo elemento de la tabla
//
procedure TfrmDatos.spb_UltimoClick(Sender: TObject);
begin
   itemindex := listatemp.count;
   edi_texto.text:= Situarse(0, itemindex);
   edi_valor.text:= Situarse(1, itemindex);
   stg_tabla.row:= stg_tabla.RowCount - 1;
   ActualizarEstado(itemindex);
end;


{PROCEDIMIENTOS QUE AFECTAN A LOS CONTROLES DE MANIPULACION DE DATOS:
 VALIDAR-NUEVO-BORRAR}


//--------------------------------------------------------------
// PROCEDIMIENTO: bib_ValidarClick VALIDAR
//
// ACCION: Afecta tan solo al estado de edicin y permite guardar los datos
//         tras verificar la correccin de los mismos. En este caso, es importante
//         que el concepto exista y que el valor asignado sea decimal
//
             {La proteccin que he implementado es para "andar por casa",
             por decirlo de forma sencilla. Seguro que  encontrars
             mtodos ms eficientes. Lo importante es en este caso, que nos podra
             interesar hacer cumplir la restriccin de que no puedan existir
             cadenas nulas. Si adems, cumplimos que no se pueda repetir un elemento
             dentro del array, accederemos al uso de mtodos como Sort, a traves
             de algoritmos eficaces -que ya tratamos en el nmero anterior-}
//
procedure TfrmDatos.bib_ValidarClick(Sender: TObject);
begin
   // comprobamos rapidamente que nos encontramos frente a un nmero decimal
   try
      strToFloat(edi_valor.text);
   except
   on E:Exception do
      begin
      ShowMessage('Introduce un valor decimal correcto: '+ edi_valor.text);
      edi_valor.setfocus;
      Exit;
      end;
   end;

   // si es correcto el valor decimal y cumple que el concepto es no
   // nulo o bien que no contiene caracter en blanco
   if (edi_texto.text <> '') and (edi_texto.text <> ' ') then
      begin  // actualizamos el valor en nuestro StringList en forma de igualdad
      listatemp.Strings[itemindex-1]:= edi_texto.text + '=' + edi_valor.text;
      //Y paralelamente en nuestro StringGrid
      stg_tabla.cells[0, itemindex]:= edi_texto.text;
      stg_tabla.cells[1, itemindex]:= edi_valor.text;
      //Nos situamos sobre el StringGrid
      stg_tabla.row:= itemindex;
      HazNavegacion;     //Navegamos
      ActualizarEstado(itemindex); // Actualizamos estado de los botones de navegacin
      end
   else
      begin
      ShowMessage('Introduce un texto en el cuadro de edicin de CONCEPTO');
      //Un error se ha producido y volvemos a las casillas de edicin
      edi_texto.setfocus;
      end;
end;


//--------------------------------------------------------------
// PROCEDIMIENTO: bib_NuevoClick NUEVO
//
// ACCION: Pasamos al estado de Insercin.
//         La pulsacin de este botn solo se puede producir bajo el
//         estado de Navegacion
//
procedure TfrmDatos.bib_NuevoClick(Sender: TObject);
begin
HazInsercion; // Premaramos el estado de los controles que intervienen
itemindex:= listatemp.Add('='); //Creamos una nuevo elemento en nuestra lista
//Si hay uno o mas elementos antes de la pulsacin
//Aumentamos en una fila nuestra tabla StringGrid
{Notese que el mtodo Add ya nos situa en el ltimo elemento de la lista
pero como no existe dicho mtodo desde la tabla, debemos fingirlo}
if itemindex > 0 then
        begin
        stg_tabla.RowCount:= stg_Tabla.rowcount + 1;
        stg_tabla.row:=stg_tabla.RowCount - 1;
        stg_tabla.Cells[0, stg_tabla.row]:= '';
        stg_tabla.Cells[1, stg_tabla.row]:= '';
        end;
stg_tabla.Enabled:= false;//desactivamos la tabla
Inc(itemindex); // nos situamos correctamente ya que el mtodo add nos
                // devuelve la posicin dentro de la matriz que es siempre
                // menor en un elemento, tal como ocurre cuando hacemos un
                //bucle for para recorrerla: (count-1)
edi_texto.Text:= '';
edi_valor.Text:= '0,0';
edi_texto.enabled:= true;
edi_valor.enabled:= true;
edi_texto.SetFocus; //enfocamos la casilla de edicin CONCEPTO
end;


//--------------------------------------------------------------
// PROCEDIMIENTO: bib_BorrarClick BORRAR
//
// ACCION: Procedemos a borrar un elemento de la lista.
//         Se parte siempre en un estado de Navegacin y se finaliza en el
//         mismo estado
//
procedure TfrmDatos.bib_BorrarClick(Sender: TObject);
var
saltar: boolean;
begin
// Nos vemos obligados a definir el estado de Borrado porque hay un estado
// especial que es el de cancelacin que lo necesita para obtener una diferenciacin
// (Ver pulsacin de la tecla TAB)
saltar:= false;
estado:= esBorrar;
lab_estado.caption:= 'BORRAR'; // mostramos el rtulo antes de la ventana modal
if MessageDlg('Quieres borrar la linea '+
         Situarse(0,itemindex)+ '...'+ Situarse(1,itemindex)+ '?',mtWarning,[mbOk,mbCancel],0)= mrOk then
   begin  //si decidimos borrar la linea
   lab_estado.caption:= 'BORRAR';    //mantenemos el rtulo

   listatemp.Delete(itemindex-1); //eliminamos el elemento de la lista pero
                                  //falta eliminarlo de la tabla

   //Nos situamos correctamente en el elemento anterior al borrado
   if (itemindex > 1) and (listatemp.Count >= 1) and (listatemp.count < itemindex)  then
        begin
        if (itemindex = (stg_tabla.RowCount-1)) then saltar:= true; //estamos en la ltima fila (debemos omitir copiar tabla())
        Dec(itemindex); //en cualquier caso, debemos situarnos sobre el elemento anterior
        end;
   //Salvo que estemos en el primer elemento que en vez de decrecer, lo dejamos as
   if (itemindex = 1) and (listatemp.Count = 0) then itemindex:= 0;

   HazNavegacion;  //Hala... a navegar

   //Vamos a operar con el resto de elementos que faltan (sobretodo la tabla)
   if itemindex > 0 then  //si despues de borrar todava queda algn elemento
      begin
      edi_texto.text:= Situarse(0, itemindex); // actualizamos las casilla
      edi_valor.text:= Situarse(1, itemindex); // de edicin
      if saltar then    stg_tabla.RowCount:= stg_tabla.RowCount - 1   //no hace falta borrar tabla solo eliminar ultima fila
      else CopiaTabla(itemindex);  //operamos sobre la tabla
     // Edi_texto.setfocus; //---> Elemento no resuelto.    TRAMPA
                                   {En teora parece no afectar pero podra ser
                                   un ejemplo de porque se complican las aplicaciones
                                   y de porque es necesaria la abstraccin y el
                                   trabajo con objetos y clases}
          {Nosotros buscamos un estado final de Navegacin. Aparentemente
          podra ser correcto entregar el foco a la casilla de concepto
          despues de borrar. Si lo hacemos perderemos el estado de Navegacin
          y lamentablemente entraremos en el de Edicin, perdiendo la consistencia.
          El porque esta claro. Hemos acordado que una modificacin de los valores
          en dichas casillas nos indiquen que estamos en estado de edicin y al
          enfocar al elemento recibe una pulsacin que ejecuta accidentalmente
          un procedimiento equivocado.}
      ActualizarEstado(itemindex);
      end
   else  //en caso contrario
      begin //pasamos a un estado de inactividad
      EstadoInicial;  //ya incluye estado en inactivo
      //inicializamos campos
      stg_tabla.row:= 1;
      stg_tabla.rowcount:= 2;
      stg_tabla.Cells[0,1]:= '';
      stg_tabla.Cells[1,1]:= '';
      end;
   end;
end;


//--------------------------------------------------------------
// PROCEDIMIENTO: CopiaTabla {Complementa a BORRAR}
//
// ACCION: Procedemos a borrar un elemento de la tabla.
//         Se ejecuta siempre dentro del procidimiento de BORRADO
//
procedure TfrmDatos.CopiaTabla(index: integer);
var
xIndice: Integer;
begin
   //recorremos toda la tabla (OJO, HE DICHO TODA)-------!
   for xIndice:= index to  stg_tabla.RowCount - 2 do    {!}
      begin                                             {!}
      stg_tabla.Cells[0,xIndice]:= stg_tabla.Cells[0,xIndice+1];
      stg_tabla.Cells[1,xIndice]:= stg_tabla.Cells[1,xIndice+1];
      stg_tabla.Cells[0,xIndice+1]:= '';
      stg_tabla.Cells[1,xIndice+1]:= '';
      end;
   //Toda pero a partir de determinada posicin.
   //Cada fila copia el valor de la fila posterior
   //y al final eliminamos la que sobra
   stg_tabla.RowCount:= stg_tabla.RowCount - 1;
end;


{OTROS PROCEDIMIENTOS VARIOS QUE MANTIENEN LA CONSISTENCIA Y QUE
 CONFORMAN EL ESTADO DE CANCELACIN QUE SUBYACE ASI TRAS LA PULSACION
 DE <TAB>}


//--------------------------------------------------------------
// EVENTO: edi_TextoKeyPress
//
// ACCION: Al pulsar el enter sobre CONCEPTO, enfocamos a VALOR
//
//
procedure TfrmDatos.edi_TextoKeyPress(Sender: TObject; var Key: Char);
begin
   if (key = #13) then
      begin
      edi_valor.SetFocus;
      edi_valor.SelectAll;
      end;
end;


//--------------------------------------------------------------
// EVENTO: edi_ValorKeyPress
//
// ACCION: Al pulsar el enter sobre VALOR enfocamos a VALIDAR
//
//
procedure TfrmDatos.edi_ValorKeyPress(Sender: TObject; var Key: Char);
begin
   if (key = #13) then
      if bib_validar.enabled then bib_validar.SetFocus
      else
      if bib_nuevo.enabled then bib_nuevo.SetFocus;
end;


//--------------------------------------------------------------
// EVENTO: edi_TextoKeyDown    (compartido por CONCEPTO y VALOR y Botn Validar)
//
// ACCION: Al pulsar
//
//
procedure TfrmDatos.edi_TextoKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
   // al pulsar sobre ESC entramos en estado de Cancelacin
   if (key = VK_ESCAPE) and (estado <> esBorrar) then
      begin
      HazCancelacion;
      Exit;
      end;
   //al pulsar '+' simulamos la pulsacin de NUEVO
   if (key = VK_ADD) and (estado = esNavegar) then bib_NuevoClick(sender);
   //al pulsar '-' simulamos la pulsacin de BORRAR
   if (key = VK_SUBTRACT) and (estado = esNavegar) then bib_BorrarClick(sender);
end;



//--------------------------------------------------------------
// EVENTO: FormKeyDown    (afecta a frmDatos)
//
// ACCION: Al pulsar
//
//
procedure TfrmDatos.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
   //al pulsar '+' simulamos la pulsacin de NUEVO
if (key = VK_ADD) and ((estado = esNavegar) or (estado = esInactivo)) then bib_NuevoClick(sender);
   //al pulsar '-' simulamos la pulsacin de BORRAR
if (key = VK_SUBTRACT) and (estado = esNavegar) then bib_BorrarClick(sender);
end;




//--------------------------------------------------------------
// EVENTO: edi_TextoExit
//
// ACCION: Al perder el foco de nuestra casilla de CONCEPTO lo entregamos
//         a la casilla de VALOR
//
    {Nota: Dudo un poco porque genera algn efecto raro en el flujo
           pero no es "grave" . Se podra prescindir}
//
procedure TfrmDatos.edi_TextoExit(Sender: TObject);
begin
edi_valor.SetFocus;
end;


//--------------------------------------------------------------
// EVENTO: edi_TextoEnter
//
// ACCION: Al "entrar" a la casilla de edicin.
//         Si estamos en estado de Navegacin pasamos a estado de
//         Edicin. En caso de estar en estado de Insercin tambin
//         pasamos a estado de edicin
//
procedure TfrmDatos.edi_TextoEnter(Sender: TObject);
begin
   if (estado = esNavegar) then
      begin
      estado:= esEditar;
      HazEdicion;
      end;
end;



//--------------------------------------------------------------
// EVENTO: Timer1Timer
//
// ACCION: Se podra haber prescindido de un objeto TTimer pero lo he
//         puesto para que represente a lo que suele ser habitual emplear.
//         Con el es facil mantener ciertos estados pero yo no fiara
//         demasiado del perro (a veces muerde).
//         Nos ayudar a mantener el color "desactivado" de nuestras
//         casillas de edicin.
//
procedure TfrmDatos.Timer1Timer(Sender: TObject);
begin
   if not edi_Texto.Enabled then edi_Texto.color:= clGray
   else edi_Texto.color:= clWindow;
   if not edi_Valor.Enabled then edi_Valor.color:= clGray
   else edi_Valor.color:= clWindow;
end;


//--------------------------------------------------------------
// EVENTO: Al "aparecer" la ventana
//
// ACCION: Esta rutina en principio debera ir en el OnCreate de la ventana
//         pero si lo hacemos as generar una excepcin ya que no podemos
//         pasar el foco a una ventana cuyos componentes no se han creado
//         todava. CUIDADO CON ESTE TIPO DE ERRORES
//         Asi cumple sin afectarnos
//
procedure TfrmDatos.FormShow(Sender: TObject);
begin
   if estado = esInactivo then bib_Nuevo.SetFocus;
end;


{EVENTO DE SINCRONIA <TABLA A LISTA>}


//--------------------------------------------------------------
// EVENTO: Al hacer click sobre una fila de la tabla
//
// ACCION: Nos situaremos sobre el registro correspondiente de la
//         lista de cadenas
//
procedure TfrmDatos.stg_TablaClick(Sender: TObject);
begin
   //solo en el caso de que haya algn elemento, este enfocado y en estado
   //de navegacin
   // ES MUY IMPORTANTE ESTA ULTIMA RESTRICCION
   if (itemindex > 0) and (stg_tabla.focused) and (estado = esNavegar) then
      begin
      itemindex:= stg_tabla.Row; //actualizamos el ndice
      edi_texto.text:= Situarse(0, itemindex); //obtenemos los valores
      edi_valor.text:= Situarse(1, itemindex);
      HazNavegacion;   //Hala... otra vez a navegar
      ActualizarEstado(itemindex);
      end;
end;

{OTROS PROCEDIMIENTOS MENOS IMPORTANTES, AUNQUE TODA PIEDRA HACE CAMINO}

//--------------------------------------------------------------
// EVENTO: Al hacer doble click sobre una fila de la tabla
//
// ACCION: Entramos en estado de Edicin
//         Se implementa para facilitar al usuario el uso del ratn
//         y de la tabla
//
procedure TfrmDatos.stg_TablaDblClick(Sender: TObject);
begin
   if (itemindex > 0) and (estado = esNavegar) then
      begin
      if estado <> esInsertar then estado:= esEditar;
      HazEdicion;
      edi_texto.setfocus;
      edi_texto.SelectAll;
      end;
end;

{Y UN TOQUE DE GRACIA POR GENTILEZA DEL GRUPO ALBOR   :-)
}


//--------------------------------------------------------------
// EVENTO: stg_TablaDrawCell    (MARIO RODRIGUEZ)
//
// ACCION: Hacemos un poco ms bonita nuestro STRINGRID
//
//
{Esta idea proviene de la seccin de Ideas del grupo Albor y ha sido
 entregada por D. Mario Rodrguez y con su permiso, la utilizo. Es
 un magnifico amigo con el que cada da aprendes un montonazo.
 Los comentarios los dejo tal y como Mario los puso, y tan solo hago
 una variacin para ajustarla al problema que deseo solucionar.
 Mario: Muchas gracias.}

{Es un momento estupendo para deciros lo importante es que colaboris
 aportando alguna idea. Si ha habido sitio para m, y os aseguro que
 soy bastante torpe, tambin puede haberlo para vosotros.
   -Venga, animos   :-)
}
procedure TfrmDatos.stg_TablaDrawCell(Sender: TObject; ACol, ARow: Integer;
  Rect: TRect; State: TGridDrawState);
var
   S: String;
begin
if (ARow > 0) and not (gdSelected in State) then
   begin
   stg_Tabla.Canvas.Brush.Color := clbtnface; // ... el resto en verde
   stg_Tabla.Canvas.FillRect(Rect);
   // Obtener el texto de la celda
   S := stg_Tabla.Cells[ACol, ARow];
   stg_Tabla.Canvas.Font.Color:= clBlack;
   Rect.Left := Rect.Left + 5;
   if ACol = 0 then
      Windows.DrawText(stg_Tabla.Canvas.Handle, // "Device context"
                       PChar(S),                  // Cadena a pintar
                       Length(S),                 // Longitud de la cadena
                       Rect,                      // Rectngulo de dibujo
                      (DT_NOCLIP or              // Sin recortar: va ms rpido
                       DT_NOPREFIX or            // No valorar el carcter "&"
                       DT_SINGLELINE or          // Una lnea
                       DT_LEFT or                // Alineada a la izquierda
                       DT_VCENTER))             // Centrada verticalmente
   else
      Windows.DrawText(stg_Tabla.Canvas.Handle, // "Device context"
                       PChar(S),                  // Cadena a pintar
                       Length(S),                 // Longitud de la cadena
                       Rect,                      // Rectngulo de dibujo
                      (DT_NOCLIP or              // Sin recortar: va ms rpido
                       DT_NOPREFIX or            // No valorar el carcter "&"
                       DT_SINGLELINE or          // Una lnea
                       DT_CENTER or              // Alineada a la izquierda
                       DT_VCENTER));             // Centrada verticalmente
   exit;
   end;

   if (ARow > 0) and (gdSelected in State) then
   begin
   stg_Tabla.Canvas.FillRect(Rect);
   // Obtener el texto de la celda
   S := stg_Tabla.Cells[ACol, ARow];
   Rect.Left := Rect.Left + 5;
   if ACol = 0 then
      Windows.DrawText(stg_Tabla.Canvas.Handle, // "Device context"
                       PChar(S),                  // Cadena a pintar
                       Length(S),                 // Longitud de la cadena
                       Rect,                      // Rectngulo de dibujo
                      (DT_NOCLIP or              // Sin recortar: va ms rpido
                       DT_NOPREFIX or            // No valorar el carcter "&"
                       DT_SINGLELINE or          // Una lnea
                       DT_LEFT or                // Alineada a la izquierda
                       DT_VCENTER))             // Centrada verticalmente
   else
      Windows.DrawText(stg_Tabla.Canvas.Handle, // "Device context"
                       PChar(S),                  // Cadena a pintar
                       Length(S),                 // Longitud de la cadena
                       Rect,                      // Rectngulo de dibujo
                      (DT_NOCLIP or              // Sin recortar: va ms rpido
                       DT_NOPREFIX or            // No valorar el carcter "&"
                       DT_SINGLELINE or          // Una lnea
                       DT_CENTER or              // Alineada a la izquierda
                       DT_VCENTER));             // Centrada verticalmente
   end;
end;


end.
