{*************************************************************
**************************************************************
*    Ejemplo de uso de varios mtodos de TStrings            *
*   Realizado el 09 de Enero del 2002 para la artculo sobre *
*   Objetos Auxiliares Parte VI.                             *
*   Autor: Salvador Jover   mailto: dejover@eresmas.com      *
*                                                            *
*                                                            *
*   Revista Sintesis N 8   http://www.GrupoAlbor.com/       *
**************************************************************
**************************************************************}


{*************************************************************
NOTA: La idea que mueve este pequeo ejemplo es la de practicar
algunos mtodos vstos en el ltimo artculo de la serie, por
lo que se han obviado todos aquellos procedimientos y funciones
de creacin y manipulacin de datos, carga de libreras y recursos
y otros similar, que lejos de aclarar, podran inducir a mayor
confusin. As pues, me sirvo del procedimiento de creacin del
formulario, para introducir unos cuantos datos que nos permitan
ver el flujo de la aplicacin, sin necesidad de implementar los
procedimientos de entrada y salida de datos.
**************************************************************}

unit calculos;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, Menus, Grids, ExtCtrls, ComCtrls, CompConversor;

const

   rotulo = 'GESTOR DE CAMBIO';


type


  TfrmEntradaDatos = class(TForm)
    BitBtn1: TBitBtn;
    Button3: TButton;
    stb_Estado: TStatusBar;
    pan_Superior: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    stg_Totales: TStringGrid;
    Label3: TLabel;
    Label4: TLabel;
    lab_Totales: TLabel;
    Panel1: TPanel;
    spb_500e: TSpeedButton;
    spb_200e: TSpeedButton;
    spb_100e: TSpeedButton;
    spb_50e: TSpeedButton;
    spb_20e: TSpeedButton;
    spb_5e: TSpeedButton;
    spb_2e: TSpeedButton;
    spb_1e: TSpeedButton;
    spb_50c: TSpeedButton;
    spb_20c: TSpeedButton;
    spb_10c: TSpeedButton;
    spb_5c: TSpeedButton;
    spb_2c: TSpeedButton;
    spb_1c: TSpeedButton;
    spb_10e: TSpeedButton;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Panel2: TPanel;
    stg_celdas: TStringGrid;
    MainMenu1: TMainMenu;
    Archivo1: TMenuItem;
    Abrir1: TMenuItem;
    Guardar1: TMenuItem;
    Guardarcomo1: TMenuItem;
    N1: TMenuItem;
    Imprimir1: TMenuItem;
    SetupImpresora1: TMenuItem;
    N2: TMenuItem;
    Salir1: TMenuItem;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    PrinterSetupDialog1: TPrinterSetupDialog;
    PrintDialog1: TPrintDialog;
    Nuevo1: TMenuItem;
    Configuracin1: TMenuItem;
    Datos1: TMenuItem;
    Ayuda1: TMenuItem;
    Acercade1: TMenuItem;
    Reconversor1: TMenuItem;
    Nuevo2: TMenuItem;
    Seleccionar1: TMenuItem;
    Eliminar1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure spb_GeneralClick(Sender: TObject);
    procedure Salir1Click(Sender: TObject);
    procedure Guardar1Click(Sender: TObject);
    procedure Abrir1Click(Sender: TObject);
    procedure Nuevo1Click(Sender: TObject);
    procedure stg_celdasDblClick(Sender: TObject);
    procedure stg_celdasSelectCell(Sender: TObject; ACol, ARow: Integer;
      var CanSelect: Boolean);
    procedure stg_celdasDrawCell(Sender: TObject; ACol, ARow: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Guardarcomo1Click(Sender: TObject);
    procedure Acercade1Click(Sender: TObject);
  private
    { Private declarations }
    calcTotal, calcResto: Double;
    Modificado: Boolean;
    procedure EstadoInicial;
    procedure InicializarBotones;
    procedure HaCambiado;
    procedure DespuesSeleccionMascara(Sender: TObject);
    procedure DespuesActualizarConversor(Sender: TObject);
    procedure CalcularCambio;
    procedure EstadoSeleccion(Index: Integer; Down: Boolean);
  public
    { Public declarations }
    Conversor1: TConversorCambio;
  end;

var
  frmEntradaDatos: TfrmEntradaDatos;

implementation


{$R *.DFM}


//***********************************************************
//***********************************************************
//       RUTINAS GENERALES DEL CONVERSOR
//***********************************************************
//***********************************************************


//--------------------------------------------------------------
// PROCEDIMIENTO: InicializarBotones
//
// ACCION: Nos valemos de este procedimiento que hemos declarado como
//         privado, para restaurar el estado inicial, en el que el
//         objeto conversor no continene ningn elemento.
//         Actualiza el estado de pulsacin de los botones,
//         desactivndolos.
   {NOTA:  El objetivo que persigue la implementacin de mtodos como ste
           no es otro que encapsular una serie de acciones que se repiten
           a lo largo de todo el programa, facilitando la lectura y la
           escritura de los procedimientos implementados. Forma parte del
           empleo de la abstraccin dentro de la programacin}
//
procedure TfrmEntradaDatos.InicializarBotones;
begin
     spb_1c.down:= false;
     spb_2c.down:= false;
     spb_5c.down:= false;
     spb_10c.down:= false;
     spb_20c.down:= false;
     spb_50c.down:= false;
     spb_1e.down:= false;
     spb_2e.down:= false;
     spb_5e.down:= false;
     spb_10e.down:= false;
     spb_20e.down:= false;
     spb_50e.down:= false;
     spb_100e.down:= false;
     spb_200e.down:= false;
     spb_500e.down:= false;
end;


//--------------------------------------------------------------
// PROCEDIMIENTO: EstadoInicial
//
// ACCION: Nos valemos de este procedimiento que hemos declarado como
//         privado, para restaurar el estado inicial, en el que el
//         objeto conversor no continene ningn elemento.
//         Actualiza el interfaz grfico y es invocado en tres momentos
//         diferentes:
//         -Cuando se cre la ventana.
//         -Cuando se necesita actualizar el interfaz si est vacio el
//          conversor.
//         -Al pulsar sobre la opcin del MENU: NUEVO
//
procedure TfrmEntradaDatos.EstadoInicial;
begin
     lab_Totales.Caption:= 'Suma Euros...............0' + #13 + 'Resto por distribuir....0';
     calcTotal:= 0.0;
     calcResto:= 0.0;
     with stg_Celdas do  //inicializamos la tabla de desgloses
          begin
          ColCount:= 2;
          RowCount:= 2;
          ColWidths[0]:= 250;
          ColWidths[1]:= 100;
          Cells[0,0]:= 'CONCEPTOS';
          Cells[1,0]:= 'VALOR EUROS';
          Cells[0,1]:= '';
          Cells[1,1]:= '';
          end;
     with stg_Totales do  //inicializamos la tabla de totales
          begin
          ColCount:= 1;
          RowCount:= 2;
          Cells[0,1]:= '';
          Cells[0,0]:= '';
          end;
     Conversor1.Inicializar_Mascaras;//desactivamos todas las mscaras
     InicializarBotones;
     Modificado:= false; //iniciamos una puesta a cero de nuestra variable MODIFICADO
end;


//--------------------------------------------------------------
// EVENTO: FormCreate
//
// ACCION: Inicializa los valores adecuados para que podamos desarrollar
//         nuestro ejemplo. La mayora de estos valores son circunstanciales
//         y tan solo nos permiten partir de un estado coherente.
// Nota: Dado que hemos optado por no registrar el componente TConversorCambio
//       procedemos a su creacin dinmica.
//
procedure TfrmEntradaDatos.FormCreate(Sender: TObject);
begin
     Application.HintHidePause:= 4200;
     Conversor1:= TConversorCambio.Create(Self);
     //Este eventos nos permite ejecutar las acciones deseadas
     //para actualizar el interfaz grfico
     Conversor1.OnAfterChangeMascaraEvent:= DespuesSeleccionMascara;
     Conversor1.OnAfterChangeConversorEvent:= DespuesActualizarConversor;
     Caption:= rotulo + ' : ' + 'Nuevo archivo.';
     EstadoInicial; // inicializamos el interfaz
end;


//--------------------------------------------------------------
// EVENTO: FormDestroy
//
// ACCION: Antes de destruir el formulario
//
procedure TfrmEntradaDatos.FormDestroy(Sender: TObject);
begin
     with Conversor1 do
          begin
          OnAfterChangeMascaraEvent:= Nil;
          OnAfterChangeConversorEvent:= Nil;
          Free; //Destruccin del objeto creado dinmicamente
          end;
end;


//--------------------------------------------------------------
// EVENTO: DespuesSeleccionMascara
//
// ACCION: Este procedimento es ejecutado al producirse el evento
//         OnAfterChangeMascaraEvent del objeto TConversorCambio,
//         dado que tras la creacin del mismo, ha sido asignado
//         a dicho evento
//         Este evento da la oportunidad de realizar las acciones
//         deseadas, tras la seleccin o deseleccin de una mscara
//
procedure TfrmEntradaDatos.DespuesSeleccionMascara(Sender: TObject);
begin
     if Conversor1.Count > 0 then
          begin
          CalcularCambio; // procedemos a actualizar el conversor
          modificado:= true;
          end;
end;


//--------------------------------------------------------------
// EVENTO: DespuesActualizarConversor
//
// ACCION: Este procedimento es ejecutado al producirse el evento
//         OnAfterChangeConversorEvent del objeto TConversorCambio,
//         dado que tras la creacin del mismo, ha sido asignado
//         a dicho evento.
//         Este evento da la oportunidad de realizar las acciones
//         deseadas en el interfaz, tras modificar el contenido del
//         objeto conversor.
//         ESTE ES EL EVENTO MS IMPORTANTE DEL CONVERSOR Y NOS
//         PERMITE ACTUALIZAR EL INTERFAZ GRFICO
//
procedure TfrmEntradaDatos.DespuesActualizarConversor(Sender: TObject);
var
xIndice, yIndice, zIndice: Integer;
begin
     if Conversor1.Count > 0 then
          begin
          lab_Totales.Caption:= 'Suma Euros..............'+ Conversor1.GetTotal + #13+
                                'Resto por distribuir....'+ Conversor1.GetResto;

          stg_celdas.RowCount:= Conversor1.Count + 1;
          stg_celdas.ColCount:= Conversor1.Contar_Mascaras + 2;

          {Actualizamos el estado de los botones que representan las mscaras}
          for xIndice:= 0 to Conversor1.Total_Mascaras do
               if Conversor1.Buscar_Mascara(TMascaras(xIndice)) then
                    EstadoSeleccion(xIndice, True)
               else
                    EstadoSeleccion(xIndice, False);

          zIndice:= 2;
          for xIndice:= 0 to Conversor1.Total_Mascaras do
               begin
               if Conversor1.Buscar_Mascara(TMascaras(xIndice)) then
                    begin
                    stg_celdas.cells[zIndice, 0]:= Conversor1.Nominal_Mascara(TMascaras(xIndice));
                    Inc(zIndice);
                    end;
               end;

          for xIndice:= 0 to Conversor1.Count - 1 do
               begin
               zIndice:= 0;
               for yIndice:= 0 to Conversor1.Total_Mascaras do
                    begin
                    if Conversor1.Buscar_Mascara(TMascaras(yIndice)) then
                         begin
                         if zIndice = 0 then stg_celdas.cells[zIndice, xIndice+1]:= Conversor1.Names[xIndice];
                         if zIndice = 1 then stg_celdas.cells[zIndice, xIndice+1]:= Conversor1.Values[xIndice];
                         stg_celdas.cells[zIndice + 2, xIndice+1]:= IntToStr(Conversor1.DesgloseCambio[xIndice, TMascaras(yIndice)]);
                         Inc(zIndice);
                         end;
                    end;
               end;

          stg_Totales.ColCount:= Conversor1.Contar_Mascaras;

          if Conversor1.Contar_Mascaras = 0 then  //si no hay seleccin
               begin
               //inicializamos el segundo TStringGrid de totales
               stg_Totales.ColCount:= stg_Celdas.Colcount - 2;
               stg_Totales.Cells[0,0]:= '';
               stg_Totales.Cells[0,1]:= '';
               end
          else //en caso contrario
               begin
               zIndice:= 0;
               for xIndice:= 0 to Conversor1.Total_Mascaras do
                    begin
                    if Conversor1.Buscar_Mascara(TMascaras(xIndice)) then
                         begin
                         EstadoSeleccion(xIndice, True);
                         stg_Totales.cells[zIndice, 0]:= Conversor1.Nominal_Mascara(TMascaras(xIndice));
                         stg_Totales.cells[zIndice, 1]:= IntToStr(Conversor1.DesgloseTotal[TMascaras(xIndice)]);
                         Inc(zIndice);
                         end
                    else
                         EstadoSeleccion(xIndice, False);
                    end;
               end;
          end
     else  //en el caso de que el conversor no contenga ninguna linea
          begin
          EstadoInicial;
          end;
end;


//--------------------------------------------------------------
// EVENTO: CalcularCambio
//
// ACCION: Es un procedimiento principal (realiza todos los clculos)
//         Nos valemos de este mtodo que hemos declarado en la parte
//         privada del interfaz, para actualizar los valores de los
//         desgloses del conversor, que pueden ser distintos aunque
//         mantenga los mismo valores (por ejemplo tras seleccionar una
//         nueva mscara).
//         Llamamos este mtodo al seleccionar una mscara y al hacer
//         doble click sobre la tabla principal tras invocar al editor.
//
procedure TfrmEntradaDatos.CalcularCambio;
var
xIndice: Integer;
Valores: Array of TValor; //matriz de conceptos y valores
begin
     if Conversor1.Count= 0 then  //de estar vacia toma filas = 1
          begin
          stg_celdas.RowCount:= 2; // restauramos la primera fila de datos vacia
          Exit; //salimos de procedimiento
          end;

     SetLength(Valores, Conversor1.Count); //inicializamos matriz Valores

     for xIndice:= 0 to Conversor1.Count - 1 do
          begin
          Valores[xIndice].Concepto:= PChar(Conversor1.Names[xIndice]);
          try
          Valores[xIndice].Entrada:= StrToFloat(Conversor1.Values[xIndice]);
          except
          on EEConverError:Exception do
               begin
               ShowMessage('Error: CELDA[1,'+ IntToStr(xIndice) + ']-Invalido valor decimal');
               Exit;
               end;
          end;//endtry
          end;

     Conversor1.AgregarLista(Valores);
end;


//--------------------------------------------------------------
// EVENTO: spb_GeneralClick( )
//
// ACCION: Agrega una mscara al objeto conversor.
//         Este procedimiento es compartido por todos los componentes de la
//         clase TSpeedButton que nos permitirn seleccionar en que monedas
//         deseamos obtener el cambio. El campo tag diferencia las pulsaciones
//         segn el objeto.
//
procedure TfrmEntradaDatos.spb_GeneralClick(Sender: TObject);
begin
     with frmEntradaDatos do
          begin
          if (Sender as TSpeedButton).down then    //si esta pulsado el botn
               case (sender as TSpeedButton).tag of
               1: Conversor1.Agregar_Mascara(UN_CENT);
               2: Conversor1.Agregar_Mascara(DOS_CENT);
               3: Conversor1.Agregar_Mascara(CINCO_CENT);
               4: Conversor1.Agregar_Mascara(DIEZ_CENT);
               5: Conversor1.Agregar_Mascara(VEINTE_CENT);
               6: Conversor1.Agregar_Mascara(CINCUENTA_CENT);
               7: Conversor1.Agregar_Mascara(UN_EUROS);
               8: Conversor1.Agregar_Mascara(DOS_EUROS);
               9: Conversor1.Agregar_Mascara(CINCO_EUROS);
               10: Conversor1.Agregar_Mascara(DIEZ_EUROS);
               11: Conversor1.Agregar_Mascara(VEINTE_EUROS);
               12: Conversor1.Agregar_Mascara(CINCUENTA_EUROS);
               13: Conversor1.Agregar_Mascara(CIEN_EUROS);
               14: Conversor1.Agregar_Mascara(DOSCIENTOS_EUROS);
               15: Conversor1.Agregar_Mascara(QUINIENTOS_EUROS);
               end
          else //en caso de no estar pulsado
               case (sender as TSpeedButton).tag of
               1: Conversor1.Eliminar_Mascara(UN_CENT);
               2: Conversor1.Eliminar_Mascara(DOS_CENT);
               3: Conversor1.Eliminar_Mascara(CINCO_CENT);
               4: Conversor1.Eliminar_Mascara(DIEZ_CENT);
               5: Conversor1.Eliminar_Mascara(VEINTE_CENT);
               6: Conversor1.Eliminar_Mascara(CINCUENTA_CENT);
               7: Conversor1.Eliminar_Mascara(UN_EUROS);
               8: Conversor1.Eliminar_Mascara(DOS_EUROS);
               9: Conversor1.Eliminar_Mascara(CINCO_EUROS);
               10: Conversor1.Eliminar_Mascara(DIEZ_EUROS);
               11: Conversor1.Eliminar_Mascara(VEINTE_EUROS);
               12: Conversor1.Eliminar_Mascara(CINCUENTA_EUROS);
               13: Conversor1.Eliminar_Mascara(CIEN_EUROS);
               14: Conversor1.Eliminar_Mascara(DOSCIENTOS_EUROS);
               15: Conversor1.Eliminar_Mascara(QUINIENTOS_EUROS);
               end;
          end;
end;


//--------------------------------------------------------------
// EVENTO: EstadoSeleccion
//
// PARAMETROS: Index: Integer-----> Identifica al botn que debe restaurar su estado de pulsacin
//             Down: Boolean------> Est pulsado o no?
//
// ACCION: Hemos implementado este mtodo para restaurar el estado de los botones
//         Nos permitir realizar esta operacin dentro de un bucle For
//         facilitando la escritura de cdigo y el tener que asignar objeto a
//         objeto los valores deseados
//
procedure TfrmEntradaDatos.EstadoSeleccion(Index: Integer; Down: Boolean);
begin
     if Down then
          case index + 1 of
          1: spb_1c.down:= true;
          2: spb_2c.down:= true;
          3: spb_5c.down:= true;
          4: spb_10c.down:= true;
          5: spb_20c.down:= true;
          6: spb_50c.down:= true;
          7: spb_1e.down:= true;
          8: spb_2e.down:= true;
          9: spb_5e.down:= true;
          10: spb_10e.down:= true;
          11: spb_20e.down:= true;
          12: spb_50e.down:= true;
          13: spb_100e.down:= true;
          14: spb_200e.down:= true;
          15: spb_500e.down:= true;
          end
     else //en caso de no estar pulsado
          case index + 1 of
          1: spb_1c.down:= false;
          2: spb_2c.down:= false;
          3: spb_5c.down:= false;
          4: spb_10c.down:= false;
          5: spb_20c.down:= false;
          6: spb_50c.down:= false;
          7: spb_1e.down:= false;
          8: spb_2e.down:= false;
          9: spb_5e.down:= false;
          10: spb_10e.down:= false;
          11: spb_20e.down:= false;
          12: spb_50e.down:= false;
          13: spb_100e.down:= false;
          14: spb_200e.down:= false;
          15: spb_500e.down:= false;
     end;
end;


//***********************************************************
//***********************************************************
//       RUTINAS PARA GUARDAR, ABRIR Y NUEVO ARCHIVO
//***********************************************************
//***********************************************************

// PROCEDIMIENTO: Nuevo1Click
//
// ACCION: Es pulsado MENU:NUEVO y debemos inicializar el conversor
//         pero previamente se ha de comprobar si el usuario desea
//         guardar el contenido actual (HaCambiado).
//
procedure TfrmEntradaDatos.Nuevo1Click(Sender: TObject);
begin
     HaCambiado;
     Conversor1.BorrarLista;
     frmEntradaDatos.caption:= rotulo + ' : ' + 'Nuevo archivo.';
     EstadoInicial;
     SaveDialog1.filename:= '';  // para que vuelva a salir el cuadro dialogo de guardar
end;


// PROCEDIMIENTO: Abrir1Click
//
// ACCION: Abrimos un nuevo archivo. Tambien debemos de asegurarnos que
//         el usuario desea conservar el contenido anterior.
//         El procedimiento LoadFromFile nos facilitar la apertura del archivo
//
procedure TfrmEntradaDatos.Abrir1Click(Sender: TObject);
begin
     HaCambiado;
     if OpenDialog1.Execute then
          begin
          Conversor1.LoadFromFile(OpenDialog1.FileName);
          SaveDialog1.filename:= OpenDialog1.filename;
          frmEntradaDatos.caption:= rotulo + ' : ' + OpenDialog1.filename;
          end;
end;


// PROCEDIMIENTO: Guardar1Click
//
// ACCION: Guardamos el contenido del conversor en un archivo.
//         Si est asignado el nombre del archivo lo hacemos
//         directamente. En caso contrario hemos de invocar
//         el procedimiento GuardarComo.
//
procedure TfrmEntradaDatos.Guardar1Click(Sender: TObject);
begin
     if (Conversor1.Count > 0) or (Modificado) then
          if (SaveDialog1.Filename <> '') then
               begin
               Conversor1.SaveToFile(SaveDialog1.FileName);
               Modificado:= False;
               end
          else
               begin
               if SaveDialog1.Execute then
                    begin
                    Conversor1.SaveToFile(SaveDialog1.FileName);
                    Modificado:= False;
                    end;
               end;
end;


// PROCEDIMIENTO: Guardarcomo1Click
//
// ACCION: Queremos darle un nuevo nombre al archivo
//
procedure TfrmEntradaDatos.Guardarcomo1Click(Sender: TObject);
begin
     if Conversor1.Count > 0 then
          if SaveDialog1.Execute then
               begin
               Conversor1.SaveToFile(SaveDialog1.FileName);
               Modificado:= False;
               frmEntradaDatos.caption:= rotulo + ' : ' + SaveDialog1.filename;
               OpenDialog1.FileName:= SaveDialog1.filename;
               end;
end;


// PROCEDIMIENTO: HaCambiado
//
// ACCION: Evaluamos si es necesario guardar el archivo. Esta rutina es llamada
//         por varios procedimientos para comprobar si se desea guardar el archivo
//         antes de proceder a actualizar el conversor
//
procedure TfrmEntradaDatos.HaCambiado;
begin
     if Modificado and (Conversor1.Count > 0) then
          if MessageDlg('Desea guardar el archivo actual?', mtWarning, [mbOk,mbCancel],0) = mrOk then
               Guardar1Click(Nuevo1);
end;



// EVENTO: FormClose
//
// ACCION  Figura dentro de estas rutinas porque tambin evalua la variable
//         MODIFICADO para conocer si es necesario proceder a guardarlo o
//         ya se ha hecho.
//
procedure TfrmEntradaDatos.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
     if MessageDlg('Quieres cerrar la aplicacin?', mtWarning, [mbOk,mbCancel],0) = mrOk then
          begin
          if modificado then
               begin
               if messagedlg('El fichero ha sido modificado, Quieres guardarlo?', mtWarning, [mbOk, mbCancel], 0) = mrOk then
                    begin
                    If SaveDialog1.Execute then Conversor1.SaveToFile(SaveDialog1.FileName);
                    end;
               end;
          end
     else
          Action:= caNone;
end;


//***********************************************************
//***********************************************************
//       INTRODUCCION DE DATOS
//***********************************************************
//***********************************************************


// EVENTO: stg_celdasDblClick
//
// ACCION: Modificamos el contenido del conversor a traves del editor
//         que construimos en el artculo editor. ste, es llamado
//         desde el conversor y le pasamos como parmetro la posicin
//         actual dentro de la tabla (simboliza el registro activo)
//         Nos devuelve la posicin al finalizar la actualizacin
//
procedure TfrmEntradaDatos.stg_celdasDblClick(Sender: TObject);
begin
     if Conversor1.Contar_Mascaras < 2 then
          begin
          ShowMessage('Selecciona al menos dos unidades para el desglose');
          Exit;
          end;
     stg_celdas.Row:= Conversor1.ShowEditor(stg_celdas.row);
     if (stg_celdas.RowCount > 9) and (stg_celdas.Row > 9) then
          begin
          stg_celdas.TopRow:= stg_celdas.Row - 8;
          end;
     Modificado:= True;
     CalcularCambio;
     stg_totales.SetFocus;
end;


//***********************************************************
//***********************************************************
//       RUTINAS QUE AFECTAN A LA TABLA PRINCIPAL
//***********************************************************
//***********************************************************

// EVENTO: stg_celdasSelectCell
//
// ACCION: Implementamos este evento para impedir que puedan ser
//         seleccionadas las columnas de los desgloses.
//
procedure TfrmEntradaDatos.stg_celdasSelectCell(Sender: TObject; ACol,
  ARow: Integer; var CanSelect: Boolean);
begin
     CanSelect:= (ACol < 2);
end;


//--------------------------------------------------------------
// EVENTO: stg_celdasDrawCell    (MARIO RODRIGUEZ)
//
// ACCION: Hacemos un poco ms bonita nuestro STRINGRID
//
//
{Esta idea proviene de la seccin de Ideas del grupo Albor y ha sido
 entregada por D. Mario Rodrguez y con su permiso, la utilizo. Es
 un magnifico amigo con el que cada da aprendes un montonazo.
 Los comentarios los dejo tal y como Mario los puso, y tan solo hago
 una variacin para ajustarla al problema que deseo solucionar.
 Mario: Muchas gracias.}
//
procedure TfrmEntradaDatos.stg_celdasDrawCell(Sender: TObject; ACol,
  ARow: Integer; Rect: TRect; State: TGridDrawState);
var
   S: String;
begin
     if ((0 < ARow) and (1 < ACol)) then
          begin
          // Esto dibuja una de cada 3 lneas en color...
          if (0 = (ARow mod 2)) then
               stg_celdas.Canvas.Brush.Color := clgray + 50
          else
               stg_celdas.Canvas.Brush.Color := clgray;
          // Dibujar el fondo
          stg_celdas.Canvas.FillRect(Rect);
          // Obtener el texto de la celda
          S := stg_celdas.Cells[ACol, ARow];
          // Si no es una cadena en blanco...
          if ('' <> S) then
               begin
               if ACol > 1 then stg_celdas.Canvas.Font.Color:= clWhite;
               // Dejar un par de pixeles a la izquierda para el texto
               Rect.Left := Rect.Left + 5;
               // ... dibujar
               //DrawText(Canvas.Handle,PChar(Cells[Acol,ARow]),-1,Rect,
               //         DT_CENTER or DT_RIGHT or DT_SINGLELINE);
               Windows.DrawText(stg_celdas.Canvas.Handle, // "Device context"
                                PChar(S),                  // Cadena a pintar
                                Length(S),                 // Longitud de la cadena
                                Rect,                      // Rectngulo de dibujo
                               (DT_NOCLIP or              // Sin recortar: va ms rpido
                                DT_NOPREFIX or            // No valorar el carcter "&"
                                DT_SINGLELINE or          // Una lnea
                                DT_CENTER or                // Alineada a la izquierda
                                DT_VCENTER));             // Centrada verticalmente
               end;
          end;
end;


//***********************************************************
//***********************************************************
//       OTRAS RUTINAS
//***********************************************************
//***********************************************************


// PROCEDIMIENTO Salir1Click
//
// ACCION: Al pulsar sobre el MENU: SALIR, finalizamos la aplicacin
//
procedure TfrmEntradaDatos.Salir1Click(Sender: TObject);
begin
     Close;
end;

//
procedure TfrmEntradaDatos.Acercade1Click(Sender: TObject);
begin
     ShowMessage('                   CONVERSOR DE CAMBIO' + #13 +
                 'Copyright (c) 2002 Salvador Jover' + #13 +
                 'mailto:dejover@eresmas.com' +#13#13 +
                 'Utilidad incluida como fuentes, en los nmeros 6 y 7' +#13 +
                 'de la Revista Sntesis: Serie sobre Objetos Auxiliares' + #13 +
                 'en Delphi. Implementacin de TDAs'+ #13 +
                 '                http://www.grupoalbor.com/');

end;

end.
