{*************************************************************
**************************************************************
*   Ejemplo de uso de las clases TStack y TQueue             *
*   Realizado el 14 de Mayo del 2002  para la artculo sobre *
*   Objetos Auxiliares VII.                                  *
*   Autor: Salvador Jover   mailto: dejover@eresmas.com      *
*                                                            *
*                                                            *
*   Revista Sintesis N 9   http://www.GrupoAlbor.com/       *
**************************************************************
**************************************************************}

{ NOTA:
  Este pequeo y bastante tonto ejemplo, solo funcionar en
  Delphi 5, dado que las clases TStack y TQueue son nuevas y
  que el mdulo que las declara e implementa se incorpora en
  dicha versin. El mdulo es "contnrs.pas". Todas las clases
  que pertenecen a dicho mdulo estn relacionadas directa o
  indirectamente con las listas de punteros: o bien desciendes
  de TList, como TClassList, o bien se apoyan en una lista para
  adquirir una nueva funcionalidad, como lo es el caso de las
  clases que representan a la especificacin "cola" y "pila",
  tan habitual en la programacin.}

unit stack_queue;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, contnrs, ExtCtrls;

{SOLO DELPHI 5 (ver nota)}

const
   max_participantes = 8;   //numero mximo de botones participantes
   separacion = 5;          //mxima separacin entre botn y botn
type

  {Declaramos una nueva clase TTimer que nos permitir en cada uno
   de los eventos de reloj efectuar un movimiento aleatorio rectilineo
   para cada botn. Por eso se puede hacer necesaria una lista (TList)
   que nos evite buscar el puntero a los mismos a traves del contenedor
   sobre el que se visualizan. Yo opto en este momento por esa opcin
   porque me parece sencilla. Me hace falta tan solo declarar una variable
   de tipo TList y crearla en el momento de la creacin del componente
   TTimerList, y destruirla explicitamente en la destruccin del mismo.}

  TTimerList = class(TTimer)
  private
    FLista: TList; //lista que alberga una referencia a cada uno de los botones
  public
    constructor Create(aOwner: TComponent); override;
    destructor Destroy; override;
    // podemos tanto leer como escribir sobre dicha lista  (*)
    property Lista: TList read FLista write FLista;
  end;

  { Es la ventana principal de nuestra aplicacin. Con ella se pretende
   tan solo ver que no puede ser ms sencillo el uso de las clases TStack
   y TQueue. El ejemplo es lo ms tonto que se me ha ocurrido en mucho
   tiempo, pero quiz por eso sea ms facil de ver.
   La idea es muy sencilla. Vamos a organizar una carrera de botones.
   Podremos ver como se usa la clase TStack o "pila" cuando se aadan
   participantes a la carrera. Y nos serviremos de dicho objeto para
   alinear cada participante en la parrilla de salida.
   Una vez alineados la pila quedara vacia.
   La clase TQueue o "cola" es usada para ir incorporando a la misma,
   sucesivamente, la llegada de los corredores. Una vez llena, procederemos
   a vaciarla, exponiendo los resultados de la carrera y dejando la
   oportunidad de iniciarla de nuevo.
   Espero que sea de vuestro agrado. }

  TfrmOlimpiadas = class(TForm)
    btb_crear: TButton;
    btb_salida: TButton;
    Label1: TLabel;
    Bevel1: TBevel;
    btb_parrilla: TButton;
    btb_cancelar: TButton;
    Label2: TLabel;
    lab_ppeek: TLabel;
    lab_pcount: TLabel;
    Label5: TLabel;
    lab_cpeek: TLabel;
    lab_ccount: TLabel;
    marco: TBevel;
    Label8: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label9: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btb_crearClick(Sender: TObject);
    procedure btb_salidaClick(Sender: TObject);
    procedure btb_parrillaClick(Sender: TObject);
    procedure btb_cancelarClick(Sender: TObject);
  private
    { Private declarations }
    Lista_botones: TTimerList; // nos ayuda en el movimiento de los participantes.
    pila: TStack;  // almacena los participante y facilitar su alineacin
    cola: TQueue;  // almacena la llegada de los participantes y emite resultado
    corredores: Integer; //nmero de corredores que han llegado a meta
    procedure TimerAction(sender: TObject);  //Evento on Timer
    procedure MostrarResultados; //muestra los resultados
    procedure ReiniciarJuego;    //para reiniciar el juego
  public
    { Public declarations }
  end;

var
  frmOlimpiadas: TfrmOlimpiadas;

implementation

{$R *.DFM}

{ class TTimerList }

//--------------------------------------------------------------
// CONSTRUCTOR: Create
//
// ACCION:  Redefinimos el constructor del componente para
//          poder crear nuestra parte del mismo.
//
constructor TTimerList.Create( AOwner: TComponent);
begin
  inherited Create(AOwner); //llamamos al constructor heredado
  FLista:= TList.Create;    //creamos nuestra parte de componente
end;

//--------------------------------------------------------------
// DESTRUCTOR: Destroy
//
// ACCION: Redefinimos el destructor del componente. Destruimos
//         la lista y procedemos posteriormente a llamar al destructor
//         en el ascendente, para que destruya igualmente su parte de
//         objeto.
//
// NOTA IMPORTANTE: Fijaros que no es necesario destruir los botones
//                  de la lista. Dichos componentes sern destruidos
//                  por el propietario de los mismos (owner).
//                  De haber hecho uso de punteros a estructuras que
//                  hicieran necesaria la reserva de memoria, SI que
//                  deberamos asegurarnos antes de la destruccin de
//                  la lista, que se ha eliminado dicha memoria.
//                  Se puede repasar sobre esto los primeros artculos
//                  de la serie que hablan de TList.
//
destructor TTimerList.Destroy;
begin
  FLista.Free;   // destruimos la lista
  FLista:= nil;  // desasignamos la variable
  inherited Destroy;  // invocamos el destructor heredado
end;

{ class TForm1 }


//--------------------------------------------------------------
// PROCEDIMIENTO: FormCreate
//
// ACCION:  En la creacin del formulario, procedemos a la
//          inicializacin de las variables que intervienen, creacin
//          del objeto "pila" y del objeto "cola"
//
//
procedure TfrmOlimpiadas.FormCreate(Sender: TObject);
begin
   Randomize; //inicializacin del generador de nmeros aleatorios
   Lista_Botones:= TTimerList.Create(self); //creacin del temporizador
   Lista_Botones.OnTimer:= TimerAction;  // Asignamos el envento OnTimer
   Lista_Botones.Interval:= 100;         // ajustando el intervalo de tiempo
   Lista_Botones.Enabled:= False;        // y de momento lo desactivamos
   corredores:= 0;    // inicializamos el n de corredores que llegar a Meta.
   pila:= TStack.Create;   //creacin de la pila
   cola:= TQueue.Create;   //creacin de la cola
end;

//--------------------------------------------------------------
// PROCEDIMIENTO:FormDestroy;
//
// ACCION: Procedemos a destruir todos aquellos objetos creados
//         dinmicamente y que depositan en nosotros la responsabilidad
//         de su destruccin.
//
procedure TfrmOlimpiadas.FormDestroy(Sender: TObject);
begin
   pila.Free;
   pila:= Nil;          //destruimos la pila
   cola.Free;
   cola:= Nil;          // destruimos la cola de resultados
end;

//--------------------------------------------------------------
// PROCEDIMIENTO: TimerAction;
//
// ACCION:  Es el evento OnTimer de nuestro Temporizador. La misin
//          del mismo es bsicamente recorrer la lista de objetos y
//          simular un movimiento aleatorio rectilineo.
//          Cuando los objetos han llegado a la figurada Meta, son
//          incorporados a la cola de resultados, sucesivamente.
//
procedure TfrmOlimpiadas.TimerAction(sender: TObject);
var
xIndice, yIndice: Integer;
boton: TButton;
begin
   Application.ProcessMessages;
   //mientras existan botones en el temporizador
   if Lista_Botones.Lista.Count > 0 then
      begin
      //recorremos la lista para obtener una referencia a ellos
      for xIndice:= 0 to Lista_Botones.Lista.Count - 1 do
         begin
         Application.ProcessMessages;
         //obtenemos la referencia al objeto actual
         boton:= TButton(Lista_Botones.Lista[xIndice]);
         //si no ha llegado a META (me vale tocarla con el extremo)
         if boton.Left + boton.Width <= bevel1.width then
            //procedemos a desplazarlo aleatoriamente
            boton.Left:= boton.Left + Random(15)
         else  //en caso contrario
            begin
            {aprovechamos el tag del boton para detectar si el
             objeto a llegado a meta. Si lo ha hecho, su tag
             valdr 1}
            If boton.tag = 0 then    // si no ha llegado a meta
               begin
               // lo incorporamos a la cola de resultados
               cola.Push(Lista_Botones.Lista[xIndice]);
               // lo anunciamos en la etiqueta la incorporacin
               lab_cpeek.caption:= 'Cola apunta a ' + TButton(cola.Peek).name;
               // actualizamos la etiqueta contador de referencias
               lab_ccount.caption:= 'Cola cuenta ' + IntToStr(cola.count) + ' Refs.';
               // minoramos en un corredor los participante ptes. de llegada
               Dec(corredores);
               If corredores = 0 then  //si han llegado todos
                  begin
                  Lista_Botones.Enabled:= False; // desactivamos el temporizador
                  // los resituamos en la linea de salida
                  for yIndice:= 0 to Lista_Botones.Lista.Count - 1 do
                     TButton(Lista_Botones.Lista[yIndice]).Left:= bevel1.Left + separacion;
                  // mostramos los resultados de la carrera
                  MostrarResultados;
                  // y reiniciamos el juego por si se quiere repetir
                  ReiniciarJuego;
                  Exit; // vamonos fuera de procedimiento !! hemos acabado!!
                  end;
               // este boton ya ha cruzado la META
               if Assigned(boton) then boton.tag:= 1;
               end;
            end;
         end;
      end;
end;


{ **********************************************************
  **********************************************************

                DOS PROCEDIMIENTOS AUXILIARES

  **********************************************************
  ********************************************************** }



//--------------------------------------------------------------
// PROCEDIMIENTO: MostrarResultados
//
// ACCION: Su misin es devolver los resultados de la carrera y para ello
//         nos basta con ir extrayendo del objeto "cola" los botones cuya
//         referencia ha almacenado internamente, en el orden de llegada.
//
procedure TfrmOlimpiadas.MostrarResultados;
var
cadena: String;
ganador: String;
contador: Integer;
begin
   // queremos ver los resultados?
   If Messagedlg('Quieres ver los resultados de la carrera?:', mtInformation, [mbOk, mbCancel], 0) = mrOk then
        begin
        cadena:= '';
        contador:= 0;
        // obtenemos el nombre del objeto "cima" de la "cola".
        // Peek nos devuelve una referencia al mismo que moldeamos para
        // obtener dicho nombre. El puntero NO es removido, solo consultado
        ganador:= 'EL GANADOR ES ' +  TButton(cola.Peek).Name;
        // mientras queden referencias
        while cola.Count > 0 do
           begin
           Inc(contador);  // nos da la posicin de llegada
           // vamos extrayendo (POP) y eliminando cada una de las
           // referencias, (el orden es el de llegada)
           cadena:= cadena + IntToStr(contador) + ': ' + TButton(cola.Pop).Name + #13#10;
           end;
        cadena:= cadena + #13#10 + ganador;
        // y visualizamos toda la cadena de resultados
        ShowMessage('Resultados de la carrera: '#13#10 + cadena);
        end
   else // si no queremos ver los resultados tambin...
        while cola.count > 0 do cola.pop; //vaciamos la "cola"
end;

//--------------------------------------------------------------
// PROCEDIMIENTO: ReiniciarJuego
//
// ACCION:  Inicializamos todas las variables que intervienen en
//          el pequeo y simple juego. Nos preparamos para volver
//          a jugar
//
procedure TfrmOlimpiadas.ReiniciarJuego;
var
xIndice: Integer;
begin
   xIndice:= 0; // contador temporal
   corredores:= 0; // inicializamos el n de corredores activos
   Lista_botones.Enabled:= False; // desactivamos el temporizador
   //restauramos la situacin inicial de los botones
   btb_salida.Enabled:= False;
   btb_parrilla.enabled:= False;
   btb_cancelar.visible:= False;
   btb_crear.enabled:= true;
   // liberamos los botones que han participado en el juego anterior
   //     QUEREMOS NUEVOS PARTICIPANTES !!!!!!!!!!!!!!!!
   while xIndice <= Lista_botones.Lista.Count - 1 do
      begin
      TButton(Lista_botones.Lista[xIndice]).Free;
      Inc(xIndice);
      end;
   Lista_botones.Lista.Clear;
   // y anunciamos el nuevo evento
   lab_ccount.caption:= 'Cola vacia';
   lab_cpeek.caption:= 'Cola vacia';
   // restaurando el marco y las dimensiones del form inicial
   bevel1.Height:= 33;
   frmOlimpiadas.height:= 171;
end;


{ **********************************************************
  **********************************************************

             ACCIONES DE LOS BOTONES PRINCIPALES

  **********************************************************
  ********************************************************** }


//--------------------------------------------------------------
// PROCEDIMIENTO: btb_crearClick
//
// ACCION: Procedemos a aadir un nuevo participante a la lista
//         Admitimos tan solo un mximo de 8 botones corredores.
//         JEJE No es precisamente un maratn popular... :-)
//
procedure TfrmOlimpiadas.btb_crearClick(Sender: TObject);
var
boton: TButton;
begin
   // solo mientras no rebasemos el nmero de participantes mximos
   // Hay que tener en cuenta que en este momento Count de la pila
   // devuelve 0 por lo que iniciamos la cuenta desde dicho valor
   if pila.Count <= max_participantes - 1 then
      begin
      boton:= TButton.Create(self); // creamos el botn (CON PROPIETARIO)
      Lista_Botones.Lista.Add(boton);  // y lo aadimos al temporizador
      boton.parent:= self; //  un padre para el nuevo botn
      boton.name:= 'Boton' + IntToSTr((pila.count + 1)); // y nombre y todo
      boton.caption:= IntToStr(pila.count + 1);  // un rtulo numrico
      boton.Font.Style:= boton.Font.Style + [fsBold]; // que se vea bien !!!
      // cuadradito to...
      boton.height:= 25;
      boton.width:= 25;

      if pila.Count >= 0 then // si hay referencias en la pila
         begin
         // fijamos la posicin en altura del boton
         boton.top:= bevel1.top +
                     separacion +
                     (separacion * pila.count) +
                     (pila.count * boton.Height);
         // ajustamos la altura del marco tambin
         bevel1.Height:= separacion +
                         (separacion * (pila.count + 1)) +
                         ((pila.count + 1) * boton.height);
         // lo dejamos entrenar en la pista hasta la salida
         boton.left:= random( bevel1.width - bevel1.left - boton.width) +
                      bevel1.left +
                      separacion;
         // y dimensionamos correctamente el form
         frmOlimpiadas.height:= bevel1.top +
                                bevel1.height +
                                boton.height +
                                separacion;
         end;
      pila.push(boton); // aadimos una referencia a la pila para finalizar
      // actualizando los avisadores
      lab_ppeek.caption:= 'Pila apunta a ' + TButton(pila.Peek).name;
      lab_pcount.caption:= 'Pila cuenta ' + IntToStr(pila.count) + ' refs.';
      // y el nmero de participantes en la carrera
      Inc(corredores);
      end;
   // solo dejamos iniciar la salida si hay ms de tres corredores
   btb_parrilla.enabled:= (pila.count >= 3);
end;

//--------------------------------------------------------------
// PROCEDIMIENTO: btb_parrillaClick
//
// ACCION: Alinea en la figurada parrilla de salida todos los participantes
//         de la carrera.
//         Podemos ver como se puede hacer uso del mtodo Pop, que nos
//         devuelve la cima de la "pila" (extrae el puntero) y a su vez
//         procede a su eliminacin.
//         Nos valemos de dicho mtodo para obtener una referencia a
//         cada uno de los participantes que nos ordene en la posicin
//         de salida dichos objetos.
//
procedure TfrmOlimpiadas.btb_parrillaClick(Sender: TObject);
begin
   // estado de los botones
   btb_salida.enabled:= (Pila.Count > 0); // salida activo si hay referencias
   // una vez alineados, ya no es tiempo de realinear o aadir mas botones
   // Se ha cerrado la participacin...
   btb_crear.enabled:= False;
   btb_parrilla.enabled:= False;
   // procedemos a ordenar los botones
   while (Pila.Count > 0) do
      TButton(Pila.Pop).Left:= Bevel1.Left + separacion;
   // y anunciamos la nueva situacin de la pila
   lab_ppeek.caption:= 'Pila vacia';
   lab_pcount.caption:= 'Pila vacia';
end;


//--------------------------------------------------------------
// PROCEDIMIENTO: btb_salidaClick
//
// ACCION: Damos la salida a la carrera... Activamos el temporizador
//
//
procedure TfrmOlimpiadas.btb_salidaClick(Sender: TObject);
begin
   Lista_botones.Enabled:= True; // temporizador activo
   btb_salida.Enabled:= False;   // desactivamos la salida
   btb_cancelar.visible:= True;  // permitimos cancelar si es necesario
end;


//--------------------------------------------------------------
// PROCEDIMIENTO: btb_cancelarClick
//
// ACCION: Mediante este botn podramos cancelar la carrera. Debemos
//         en la implementacin asegurarnos que se reponen los estados
//         que garantizan la correcta vuelta atrs.
//
//
procedure TfrmOlimpiadas.btb_cancelarClick(Sender: TObject);
var
xIndice: Integer;
begin
   xIndice:= 0;    // contador temporal bucle
   corredores:= 0; // inicializamos el contador
   // situacin anterior de los botones
   Lista_botones.Enabled:= False;
   btb_salida.Enabled:= False;
   btb_parrilla.enabled:= true;
   btb_cancelar.visible:= False;
   btb_crear.enabled:= true;
   // eliminamos de la cola aquellos botones que alcanzaron la meta
   // antes de cancelar.
   while cola.count > 0 do cola.pop;
   // reponemos tambin la pila que nos permita reordenar los botones
   // a la situacin de partida. Hay que tener en cuenta que se eliminarn
   // precisamente en la ordenacin anterior. "Cola" est vaca y debemos
   // reponerla
   while xIndice <= Lista_botones.Lista.Count - 1 do
      begin
      pila.push(lista_botones.lista[xIndice]);
      // inicializamos el tag del botn
      TButton(lista_botones.lista[xIndice]).tag:= 0;
      // incrementamos un nuevo corredor
      Inc(corredores);
      Inc(xIndice);
      end;
end;

end.
