{**************************************************************
***************************************************************
*  Segundo ejemplo explicativo de la asignacin de prioridad. *
*  Realizado el 08 de Marzo del 2003 para la artculo sobre   *
*  hilos de ejecucin: Thread IV                              *
*  Autor: Salvador Jover   mailto: s.jover@wanadoo.es         *
*                                                             *
*                                                             *
*  Revista Sintesis N 14  http://www.GrupoAlbor.com/         *
***************************************************************
***************************************************************}

unit Uni_prior2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  ComCtrls, StdCtrls, Gauges, Buttons, ExtCtrls, Hilos;

type

  Par = Record
    Gauge: TGauge;
    Combo: TComboBox;
    Hilo : TMiHilo;
  end;

  TfrmPrincipal = class(TForm)
    but_Lanzar: TButton;
    Gau1: TGauge;
    Gau2: TGauge;
    Gau3: TGauge;
    Gau4: TGauge;
    Gau5: TGauge;
    Gau6: TGauge;
    Gau7: TGauge;
    Cbx1: TComboBox;
    Cbx2: TComboBox;
    Cbx3: TComboBox;
    Cbx4: TComboBox;
    Cbx5: TComboBox;
    Cbx6: TComboBox;
    Cbx7: TComboBox;
    rgp_Selector: TRadioGroup;
    procedure but_LanzarClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure rgp_SelectorClick(Sender: TObject);
    procedure OnChangeGeneral(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    MisBarras: array[0..6] of Par;
    procedure LanzarHilos;
    procedure OnFinish(Sender: TObject);
  end;

var
  frmPrincipal: TfrmPrincipal;
  MiHilo: TMiHilo;

implementation

{$R *.dfm}


{ TForm1 }

procedure TfrmPrincipal.LanzarHilos;
var
  xIndice: integer;
begin
  Contador:= 0;    //inicializamos el contador de hilos
  for xIndice:= 0 to 6 do
  begin
     with MisBarras[xIndice] do
     begin
        Gauge.Progress:= 0;           //Inicializamos la barra de progreso
        Hilo:= TMiHilo.Create(Gauge); //Creamos el hilo [estado suspendido]
        Hilo.Id:= xIndice;            //Almacenamos el indice de la matriz dentro del hilo
        Hilo.OnTerminate:= OnFinish;  //Asignamos el evento de finalizacin
        //Ajustamos la prioridad segn el indice del combobox correspondiente
        case Combo.ItemIndex of
           0: Hilo.Priority:= tpIdle;
           1: Hilo.Priority:= tpLowest;
           2: Hilo.Priority:= tpLower;
           3: Hilo.Priority:= tpNormal;
           4: Hilo.Priority:= tpHigher;
           5: Hilo.Priority:= tpHighest;
           6: Hilo.Priority:= tpTimeCritical;
        else
           Hilo.Priority:= tpNormal;
        end;
        Inc(Contador); //incrementamos un contador de hilos
        Hilo.Resume;   //y lanzamos la ejecucin del hilo
     end;
  end;
end;

// Procedimiento but_LanzarClick
//
// Corresponde al hacer click sobre el boton. Lanza la ejecucin de
// los hilos y se desactiva hasta que han finalizado.
//
procedure TfrmPrincipal.but_LanzarClick(Sender: TObject);
begin
   LanzarHilos;
   but_Lanzar.Enabled:= False;
end;

// Evento OnCreate del Formulario
//
// Damos valores al array, asignando las barras de progreso y los
// TComboBox. Nos permitir mediante bucles acceder a las propiedades
// de dichos objetos.
//
procedure TfrmPrincipal.FormCreate(Sender: TObject);
var
  xIndice: Integer;
begin
  MisBarras[0].Gauge:= Gau1;
  MisBarras[1].Gauge:= Gau2;
  MisBarras[2].Gauge:= Gau3;
  MisBarras[3].Gauge:= Gau4;
  MisBarras[4].Gauge:= Gau5;
  MisBarras[5].Gauge:= Gau6;
  MisBarras[6].Gauge:= Gau7;

  MisBarras[0].Combo:= Cbx1;
  MisBarras[1].Combo:= Cbx2;
  MisBarras[2].Combo:= Cbx3;
  MisBarras[3].Combo:= Cbx4;
  MisBarras[4].Combo:= Cbx5;
  MisBarras[5].Combo:= Cbx6;
  MisBarras[6].Combo:= Cbx7;

  for xIndice:= 0 to 6 do
    MisBarras[xIndice].Combo.ItemIndex:= xIndice;
end;

// Evento OnDestroy del Formulario
//
// Desasignamos las referencias del array y terminamos la ejecucin
// de los hilos en el caso de estar ejecutndose
//
procedure TfrmPrincipal.FormDestroy(Sender: TObject);
var
  xIndice: integer;
begin
  for xIndice:= 0 to 6 do
  begin
     with MisBarras[xIndice] do
     begin
        Gauge:= Nil;
        Combo:= Nil;
        if Hilo <> Nil then Hilo.Terminate;
     end;
  end;
end;

// Evento OnClick del TRadioGroup
//
// Seleccionamos todos los hilos a prioridad normal o bien con prioridad
// distinta (cada hilo tiene una de las siete prioridades)
//
procedure TfrmPrincipal.rgp_SelectorClick(Sender: TObject);
var
   xIndice: Integer;
begin
  xIndice:= 0;
  if rgp_Selector.ItemIndex = 0 then
  begin
     while xIndice <= 6 do
     begin
        MisBarras[xIndice].Combo.ItemIndex:= 3;
        Inc(xIndice);
     end;
  end
  else
  begin
     while xIndice <= 6 do
     begin
     MisBarras[xIndice].Combo.ItemIndex:= xIndice;
     Inc(xIndice);
     end;
  end;
end;

// Evento OnChange de los TComboBox
//
// El evento es implementado para todos los componentes TComboBox,
// que representan un selector de la prioridad.
// Distinguimos la pulsacin de cada uno por el tag
//
procedure TfrmPrincipal.OnChangeGeneral(Sender: TObject);
var
  prioridad: TThreadPriority;
begin
  if TComboBox(Sender).itemindex <> -1 then
     prioridad:= TThreadPriority(TComboBox(Sender).itemindex)
  else
     prioridad:= tpNormal;

  if MisBarras[TComboBox(Sender).tag].Hilo <> nil then
     if MisBarras[TComboBox(Sender).tag].Hilo.Gauge <> nil then
        MisBarras[TComboBox(Sender).tag].Hilo.Priority:= prioridad;
end;

// Evento OnFinish de los hilos
//
// En este caso, la implementacin la hacemos desde el form.
// Este evento se producir al finalizar el hilo.
//
procedure TfrmPrincipal.OnFinish(Sender: TObject);
begin
   //Es necesario liberar la referencia para que el evento OnChange
   //no genere una excepcin en el caso que se intente cambiar la prioridad
   //tras la finalizacin del hilo
   MisBarras[TMiHilo(Sender).Id].Hilo:= Nil;
   //nos valemos del contador para evaluar el estado del boton
   //y del cuadro selector
   but_Lanzar.Enabled:= Contador = 0;
   rgp_Selector.Enabled:= but_Lanzar.Enabled;
end;

end.
