unit hilos;

interface

uses
  Windows, Classes, Gauges;

type

  TMiHilo = class(TThread)
  private
    FGauge: TGauge;
    Continuar: Boolean;
    ContadorLocal: Integer;
    FId: Integer;
    procedure SetId(const Value: Integer);
  protected
    procedure HiloPrincipal; virtual;
    procedure Execute; override;
  public
    Property Id: Integer read FId write SetId;
    Property Gauge: TGauge read FGauge;
    Constructor Create(MiGauge: TGauge);
    Destructor Destroy; Override;
  end;

ThreadVar
  Contador: Integer;

implementation

uses uni_Prior2;


{ TMiHilo }

constructor TMiHilo.Create(MiGauge: TGauge);
begin
   FGauge:= MiGauge;
   Continuar:= True;
   inherited Create(True);
end;

destructor TMiHilo.Destroy;
begin
  FGauge:= Nil;
  inherited Destroy;
end;

procedure TMiHilo.Execute;
begin
   Continuar:= True;
   FreeOnTerminate:= True;
   repeat
      ContadorLocal:= Contador;
      Synchronize(HiloPrincipal);
      Inc(Contador);
   until Continuar;
end;

procedure TMiHilo.HiloPrincipal;
begin
   Continuar:= (ContadorLocal >= FGauge.MaxValue) or Terminated;
   if Continuar then Dec(Contador);
   FGauge.Progress:= ContadorLocal;
end;

procedure TMiHilo.SetId(const Value: Integer);
begin
  FId := Value;
end;

end.
