{*************************************************************
**************************************************************
*   Ejemplo explicativo de la declaracin de ThreadVar & Var *
*   Realizado el 08 de Marzo del 2003 para la artculo sobre *
*   hilos de ejecucin: Thread IV                            *
*   Autor: Salvador Jover   mailto: s.jover@wanadoo.es       *
*                                                            *
*                                                            *
*   Revista Sintesis N 14  http://www.GrupoAlbor.com/       *
**************************************************************
**************************************************************}


unit unit_Threadvar;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  StdCtrls, ExtCtrls;

type

  TMiHilo = class(TThread)
  private
    MiNumero: Integer;
  protected
    procedure Execute; override;
    procedure MiMetodo;
  public
    constructor Create(Valor: Integer);
  end;

  TForm1 = class(TForm)
    Button1: TButton;
    Label1: TLabel;
    Bevel1: TBevel;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Hilo1: TMiHilo;
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

{ MiHilo }

{**********************************************************************
El por qu...
Tenis que ejecutar el ejemplo de la siguiente forma. Primero tal y como
est. El resultado que os mostrar el Caption de Form principal es "Mi
Numero es 10". El motivo es el siguiente: cuando una variable es declarada
como threadvar, cada uno de los hilos que accede a la variable lo hace a
una copia de la misma y por dicha razn, al ejecutarse el mtodo MiMetodo
dentro del contexto del hilo primario de la aplicacin, la variable
NumeroGlobal tiene el valor original de la primera asignacin, puesto
que el thread ha afectado tan solo a su copia.
Por esa razn, al ser declarada como Var en lugar de threadVar, actua como
una variable global y es modificada por el hilo. Entonces nos mostrar el
valor 5 en lugar del valor 10.
************************************************************************}

//var
threadvar
NumeroGlobal: Integer;


constructor TMiHilo.Create(Valor: Integer);
begin
  MiNumero:= Valor;
  inherited Create(False);
  {Si desmarcas el comentario de la siguiente
   linea la variable MiNumero mostrar el valor 5
   (suponemos que la variable global se ha declarado
   como threadvar).
   Por qu? Es un buen momento para razonarlo y
   confirmar lo dicho anteriormente}
   
//  NumeroGlobal:= MiNumero;
end;

procedure TMiHilo.Execute;
begin
  FreeOnTerminate:= True;
  NumeroGlobal:= MiNumero;
  Synchronize(MiMetodo);
end;

procedure TMiHilo.MiMetodo;
begin
  Form1.Caption:= 'Mi Numero vale ' + IntToStr(NumeroGlobal);
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  NumeroGlobal:= 10;
  Hilo1:= TMiHilo.Create(5);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  label1.Caption:= 'Pulsa primero el botn inferior.'                              + #13#10 +
                   'Podramos pensar que la variable [NumeroGlobal] debera'       + #13#10 +
                   'valer 5 al final de la ejecucin del hilo creado, ya que'      + #13#10 +
                   'ste modifica su valor. Vemos que esto solo es as si dicha'   + #13#10 +
                   'variable fuera declarada como Var, puesto que solo en ese'     + #13#10 +
                   'caso su mbito sera global a todos los hilos. Si es declarada'+ #13#10 +
                   'como ThreadVar vemos que no es as y que en ese caso toma'     + #13#10 +
                   'el valor 10.'
end;

end.
