{*************************************************************
**************************************************************
*   Ejemplo explicativo de la asignacin de prioridad.       *
*   Realizado el 08 de Marzo del 2003 para la artculo sobre *
*   hilos de ejecucin: Thread IV                            *
*   Autor: Salvador Jover   mailto: s.jover@wanadoo.es       *
*                                                            *
*                                                            *
*   Revista Sintesis N 14  http://www.GrupoAlbor.com/       *
**************************************************************
**************************************************************}


unit Uni_prior;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  ComCtrls, StdCtrls;

type

  TPrioritario = class(TThread)
  private
    Continuar: Boolean;
  protected
    procedure MiMetodo;
    procedure Execute; override;
  end;

  TForm1 = class(TForm)
    stb_Estado: TStatusBar;
    Button1: TButton;
    procedure FormCreate(Sender: TObject);
    procedure stb_EstadoDrawPanel(StatusBar: TStatusBar;
      Panel: TStatusPanel; const Rect: TRect);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    procedure LanzarHilos;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  MiHilo: TPrioritario;

threadvar
  NumeroGlobal: Integer;

implementation

{$R *.dfm}

{ TPrioritario }

procedure TPrioritario.Execute;
var
  xIndice, xtmp: Integer;
begin
  FreeOnTerminate:= True;
  NumeroGlobal:= 1;
  repeat
  Continuar:=  NumeroGlobal < 10;
  for xIndice:= 0 to 1000000 do Inc(xtmp);//perdemos tiempo
  Synchronize(MiMetodo);
  Inc(NumeroGlobal,1);
  until Not Continuar;
end;

procedure TPrioritario.MiMetodo;
begin
  Inc(NumeroGlobal, 2);
  with Form1.Canvas do
  begin
     case Priority of
        tpIdle        : Pen.Color:= clBlue;
        tpLowest      : Pen.Color:= clBlack;
        tpLower       : Pen.Color:= clMaroon;
        tpNormal      : Pen.Color:= clTeal;
        tpHigher      : Pen.Color:= clNavy;
        tpHighest     : Pen.Color:= clGray;
        tpTimeCritical: Pen.Color:= clRed;
     end;
     Pen.Width:= 1;
     MoveTo(NumeroGlobal, 5);
     case Priority of
        tpIdle        : LineTo(NumeroGlobal, 200);
        tpLowest      : LineTo(NumeroGlobal, 220);
        tpLower       : LineTo(NumeroGlobal, 240);
        tpNormal      : LineTo(NumeroGlobal, 260);
        tpHigher      : LineTo(NumeroGlobal, 280);
        tpHighest     : LineTo(NumeroGlobal, 300);
        tpTimeCritical: LineTo(NumeroGlobal, 320);
     end;
  end; //endBeginWith
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
//   LanzarHilos;
end;

procedure TForm1.LanzarHilos;
var
  Prioridad: TThreadPriority;
begin
  NumeroGlobal:= 0;
  for Prioridad:= Low(TThreadPriority) to High(TThreadPriority) do
  begin
    MiHilo:= TPrioritario.Create(True);
    MiHilo.Priority:= Prioridad;
    MiHilo.Resume;
  end;
end;

procedure TForm1.stb_EstadoDrawPanel(StatusBar: TStatusBar;
  Panel: TStatusPanel; const Rect: TRect);
begin
   with StatusBar.Canvas do
   begin
      Font.Color:= clWhite;
      Font.Style:= [fsBold];
      case Panel.Index of
        0: begin
              Brush.Color:= clBlue;
              FillRect(Rect);
              TextRect(Rect, Rect.Left, Rect.Top, 'tpIdle');
           end;
        1: begin
              Brush.Color:= clBlack;
              FillRect(Rect);
              TextRect(Rect, Rect.Left, Rect.Top, 'tpLowest');
           end;
        2: begin
              Brush.Color:= clMaroon;
              FillRect(Rect);
              TextRect(Rect, Rect.Left, Rect.Top, 'tpLower');
           end;
        3: begin
              Brush.Color:= clTeal;
              FillRect(Rect);
              TextRect(Rect, Rect.Left, Rect.Top, 'tpNormal');
           end;
        4: begin
              Brush.Color:= clNavy;
              FillRect(Rect);
              TextRect(Rect, Rect.Left, Rect.Top, 'tpHigher');
           end;
        5: begin
              Brush.Color:= clGray;
              FillRect(Rect);
              TextRect(Rect, Rect.Left, Rect.Top, 'tpHighest');
           end;
        6: begin
              Brush.Color:= clRed;
              FillRect(Rect);
              TextRect(Rect, Rect.Left, Rect.Top, 'tpTimeCritical');
           end;
      end; //endCase
   end; //endbeginWidth
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Canvas.FillRect(ClientRect);
  LanzarHilos;
end;

end.
