unit uLabelAsociado;

//*****************************************************************************
//  Componente TLabelAsociado
//
//*****************************************************************************
//  Fecha creacin: 15/06/2006
//  Autor         : Salvador Jover
//  Mail          : salvador@sjover.com
//  HTTP          : http://www.sjover.com/delphi
//
//*****************************************************************************
//
//  Objetivo : Modificar el caption de la etiqueta vinculandolo con el valor
//             de la propiedad DisplayLabel de los campos persistentes de las
//             tablas
//
//  Reflexin: Es un ejercicio sobre el uso de RTTI para cuando uno se aburre...
//
//  Ver      : Pgina de Neftali
//             http://neftali.clubdelphi.com/delphi_tips.html#Acceder_a_las_propiedades_de_un

interface

uses
  SysUtils, Classes, Controls, StdCtrls, Dialogs, TypInfo, DB;

type

  PObjetoInfo = ^TObjetoInfo;
  TObjetoInfo = record
     AInfo: PPropInfo;
     AObjeto: TObject;
  end;

  TLabelAsociado = class(TLabel)
  private
    //metodos de escritura y lectura
    procedure SetFocusControl(Value: TWinControl);
    function GetFocusControl: TWinControl;
    { Private declarations }
  published
    { Published declarations }
    property FocusControl: TWinControl read GetFocusControl write SetFocusControl;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TLabelAsociado]);
end;

{ TcxLabelAsociado }

// ****************************************************************************
// ****************************************************************************
//  Metodo    : GetRTTIDataSourceObject
//  Parametros: AControl: TObject
//  Resultado : TDataSource
//
//  Objetivo  :
//
// ****************************************************************************

function GetRTTIDataSourceObject(AControl: TObject): TDataSource;
var
i: integer;
props: PPropList;
tData: PTypeData;
FObject: TObject;
begin
   // Inicial
   Result := nil;

   // No asignado el control ==> Salimos
   if (AControl = nil) or (AControl.ClassInfo = nil) then begin
      Exit;
   end;

   // Obtener la informacin
   tData := GetTypeData(AControl.ClassInfo);

   // Tipo desconocido o sin propiedades ==> Salimos
   if (tData = nil) or (tData^.PropCount = 0) then Exit;

   //Obtenemos memoria para la estructura que almacenar la propiedades
   GetMem(props, tData^.PropCount * SizeOf(Pointer));
   try
      //rellenamos la estructura con la informacin de clase
      GetPropInfos(AControl.ClassInfo, props);

      //recorremos la lista de propiedades
      for i := 0 to tData^.PropCount - 1 do begin
         //si la propiedad es de tipo clase (capaz de convertirse en un objeto)
         if Props^[i]^.PropType^^.Kind in [tkClass] then begin
            //vamos a apuntar hacia dicho objeto
            FObject:= GetObjectProp(AControl, Props^[i]);
            //solo consideraremos aquellos objetos referenciados
            if (FObject <> nil) and (FObject is TDataSource) then begin
               //hemos encontrado nuestro datasource
               Result:= (FObject as TDataSource);
               Exit; //abur...
            end
            else if FObject <> nil then begin
               //es una instancia pero no de la clase que buscamos pero...
               //estar dentro de dicha instancia el datasource buscado?
               //recursivamente lo sabermos
               Result:= GetRTTIDataSourceObject(FObject);
               //si tuviera exito nos vamos...
               if Result <> nil then Exit; //abur...
            end;
         end;
      end;
   finally
      FreeMem(props); //liberamos finalmente la memoria asignada dinmicamente
   end;
end;

// ****************************************************************************
// ****************************************************************************
//  Metodo    : GetRTTIControlInfo
//  Parametros: var AObjetoInfo: TObjetoInfo; AControl: TObject; AProperty: string
//
//  Objetivo  : Devolver el par Objeto-Informacion_Extructur_propiedades
//              en la variable AObjetoInfo que nos permita obtener el valor
//              de la propiedad consultada (FieldName).
//
//  Comentario: No solo nos hace falta la estructura de propiedades del objeto
//              sino tambien el mismo objeto puesto que de estar anidadas
//              no coincidira con el original que es pasado como parmetro
//
// ****************************************************************************

procedure GetRTTIControlInfo(var AObjetoInfo: TObjetoInfo; AControl: TObject; AProperty: string);
var
i: integer;
props: PPropList;
tData: PTypeData;
begin
   //Inicializamos la estructura que va a contener el par de retorno Info-Objeto
   //la Precondicion AInfo = nil garantiza la finalizacin con el valor de estructura
   with AObjetoInfo do begin
      AInfo:= nil;
      AObjeto:= nil;
   end;

   // No asignado el control ==> Salimos
   if (AControl = nil) or (AControl.ClassInfo = nil) then begin
      Exit;
   end;

   // Obtener la informacin
   tData := GetTypeData(AControl.ClassInfo);

   // Tipo desconocido o sin propiedades ==> Salimos
   if (tData = nil) or (tData^.PropCount = 0) then Exit;

   //Obtenemos memoria para la estructura que almacenar la propiedades
   GetMem(props, tData^.PropCount * SizeOf(Pointer));
   try
      //rellenamos la estructura con la informacin de clase
      GetPropInfos(AControl.ClassInfo, props);

      //recorremos la lista de propiedades
      for i := 0 to tData^.PropCount - 1 do begin
         //si la propiedad es de tipo clase (capaz de convertirse en un objeto)
         if Props^[i]^.PropType^^.Kind in [tkClass] then begin
            GetRTTIControlInfo(AObjetoInfo, GetObjectProp(AControl, Props^[i]), AProperty);
            //si ha tenido exito
            if AObjetoInfo.AInfo <> nil then begin
               Exit; //nos vamos...
            end;
         end
         else
         if (Props^[i]^.Name = AProperty) then begin
            with AObjetoInfo do begin
               AInfo:= Props^[i];
               AObjeto:= AControl;
            end;
            Exit; //nos vamos... Encontrado par [Objeto/Info]
         end;
      end;
   finally
      FreeMem(props);
   end;
end;


// ****************************************************************************
// ****************************************************************************
//  Metodo    : GetFocusControl
//  Parametros:
//  Resultado : TWinControl
//
//  Objetivo  : Metodo de lectura de la propiedad FocusControl
//
// ****************************************************************************

function TLabelAsociado.GetFocusControl: TWinControl;
begin
  Result:= inherited FocusControl;
end;


// ****************************************************************************
// ****************************************************************************
//  Metodo    : SetFocusControl
//  Parametros: Value: TWinControl
//  Resultado : Void
//
//  Objetivo  : Metodo de escritura de la propiedad FocusControl
//
// ****************************************************************************

procedure TLabelAsociado.SetFocusControl(Value: TWinControl);
var
  pOInfo: PObjetoInfo;
  FDataSource: TDataSource;
  FFieldName: String;
begin
  //asignamos el valor al ascendente y que haga lo que tenga que hacer
  inherited FocusControl := Value;

  //ahora empezamos nosotros...

  //solo actuaremos en tiempo de diseo
  if (Value = nil) or (ComponentState <> [csDesigning])  then Exit;

  //reservamos memoria a la estructura TObjetoInfo que vamos a apuntar
  GetMem(pOInfo, SizeOf(TObjetoInfo));
  try
     // Acceder a la info de la propiedad
     GetRTTIControlInfo(poInfo^, Value, 'DataField');

     //comprobamos que hemos tenido un resultado positivo y la estructura
     //contiene la propiedad desesada.
     if (pOInfo.AInfo <> nil) then begin
        //esta comprobacin es redundante pero la dejo como segurida
        //puesto que pudiera darse el caso de existir un componente
        //con el mismo nombre de propidad y distinto tipo...
        if (pOInfo.AInfo.PropType^^.Kind in [tkLString]) then begin
           // Obtenemos el valor
           FFieldName:= Format('%s', [GetStrProp(pOInfo.AObjeto, pOInfo.AInfo)]);

           //Vamos a la segunda parte que nos permitir obtener el datasource
           FDataSource:= GetRTTIDataSourceObject(Value);
           //si ha tenido exito y se puede obtener el valor de la etiqueta
           if Assigned(FDataSource) and Assigned(FDataSource.DataSet) and (Trim(FFieldName) <> '') then begin
                 Caption:= FDataSource.DataSet.FieldByName(FFieldName).DisplayLabel;
                 Exit; //hemos acabado
           end;
        end;
     end;
     Caption:= '';  //fall lo anterior y aqui vaciamos el valor de la propiedad Caption
  finally
     FreeMem(pOInfo); //liberamos la memoria dinmica
  end;
end;

end.
