unit uPruebaVariants;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, VarCmplx;

type
  TObjetoMio = class(TComponent)
  private
    FNombre: String;
    procedure SetNombre(const Value: String);
  protected
  public
     property Nombre: String read FNombre write SetNombre;
     destructor Destroy; override;
  end;

  TComplexVarData = packed record
    VType: TVarType;
    Reserved1, Reserved2, Reserved3: Word;
    VComplex: TObjetoMio;
    Reserved4: LongInt;
  end;

  TForm1 = class(TForm)
    btnOk: TButton;
    lbxLista: TListBox;
    procedure btnOkClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure RecorrerLista(ALista: Array of Variant);
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

type

 TMyVariantType = class(TCustomVariantType)
 public
    procedure Clear(var V: TVarData); override;
    procedure Copy(var Dest: TVarData; const Source: TVarData;
      const Indirect: Boolean); override;
 end;

var
  ComplexVariantType: TMyVariantType;

function VarComplex: TVarType;
begin
  Result := ComplexVariantType.VarType;
end;

procedure VarComplexCreateInto(var ADest: Variant; const AComplex: TObjetoMio);
begin
  VarClear(ADest);
  TComplexVarData(ADest).VType := VarComplex;
  TComplexVarData(ADest).VComplex := AComplex;
end;

function VarComplexCreate(AObject: TObjetoMio): Variant; overload;
begin
  VarComplexCreateInto(Result, AObject);
end;


function VarIsComplex(const AValue: Variant): Boolean;
begin
  Result := (TVarData(AValue).VType and varTypeMask) = VarComplex;
end;


{ TObjetoMio }

destructor TObjetoMio.Destroy;
begin
  inherited Destroy;
end;

procedure TObjetoMio.SetNombre(const Value: String);
begin
  FNombre := Value;
end;

{ TForm }

procedure TForm1.btnOkClick(Sender: TObject);
var
  MiObjeto: TObjetoMio;
  i: Integer;
begin
   //creamos dos objetos cualquiera
   MiObjeto:= TObjetoMio.Create(self);
   MiObjeto.Nombre:= 'Mi objeto';

   i:= 265;

   RecorrerLista([VarComplexCreate(MiObjeto), i])
end;

procedure TForm1.RecorrerLista(ALista: array of Variant);
var
  i: Integer;
  FObjeto: TObjetoMio;
begin
   for i:= Low(ALista) to High(ALista) do begin
      if VarIsComplex(ALista[i]) then begin
         FObjeto:= TComplexVarData(ALista[i]).VComplex;
         lbxLista.Items.Add(FObjeto.Nombre);
      end
      else begin
         case VarType(ALista[i]) of
            varInteger: begin
                          lbxLista.Items.Add(IntToStr(ALista[i]));
                        end;
         end;
      end;
   end;
end;

{ TMyVariantType }

procedure TMyVariantType.Clear(var V: TVarData);
begin
  inherited;
  V.VType := varEmpty;
  TComplexVarData(V).VComplex:= Nil;
end;

procedure TMyVariantType.Copy(var Dest: TVarData; const Source: TVarData;
  const Indirect: Boolean);
begin
  inherited;
  if Indirect and VarDataIsByRef(Source) then
    VarDataCopyNoInd(Dest, Source)
  else
    with TComplexVarData(Dest) do
    begin
      VType := VarType;
      VComplex := TComplexVarData(Source).VComplex;   
    end;
end;

initialization
  ComplexVariantType := TMyVariantType.Create;

finalization
  FreeAndNil(ComplexVariantType);

end.
