library seldir;

uses
  Windows,
  ShlObj,
  ActiveX;

function BrowseCallBackProc(hWnd: HWND; uMsg: UINT; lparam, lpData: LPARAM): Integer; stdcall;
var
    Ruta: Array[0..MAX_PATH] of Char;
begin
   case uMsg of
       //Se inicializ el ventana de exploracin de carpetas
       BFFM_INITIALIZED: ; 
       
       //El usuario seleccion la carpeta en la ventana 
       BFFM_SELCHANGED: begin
          //obtenemos la ruta de la carpeta seleccionada
          SHGetPathFromIDList(PItemIDList(lparam), @Ruta);
          //enviamos un mensaje a la ventana para que muestre la cadena en
          //el interior de la misma
          SendMessage(hwnd, BFFM_SETSTATUSTEXT, 0, LongInt(PChar(@Ruta)));
       end;
   end;
   //siempre devuelve cero
   Result:= 0;
end;

function MostrarCuadroCarpetas(ACaption: PChar; ACallBack: Boolean): PChar; stdcall;
var
  fres: Array[0..MAX_PATH] of Char;
  fName: Array[0..MAX_PATH] of Char;
  IDList: PItemIDList;
  BrowseInfo: TBrowseInfo;
  Malloc: IMalloc;
begin
  //rellenamos la estructura con los datos deseados
  with BrowseInfo do begin
    hwndOwner:= 0;       //en nuestro caso no existe handle y 
                         //se mostrara de forma no modal
    pidlRoot:= nil;      //no existe origen predefinido
    pszDisplayName:= fName;  //Nombre de la carpeta
    lpszTitle:= ACaption;  //Titulo de la ventana    
    //se podria parametrizar desde Velneo para mostrar opciones distintas
    //en este caso solo hemos seleccionado la posibilidad de mostrar el
    //texto a traves del mensaje en la funcin callback
    {

    }
    ulFlags:= BIF_STATUSTEXT;
    //si no queremos ejecutar el callback para modificar la ventana de exploracion
    if ACallBack then
       lpfn:= @BrowseCallBackProc
    else lpfn:= nil;    
    lParam:= 0;
  end;
  //Invocamos la funcion del API SHBrowseForFolder pasando como parmetro la
  //estructura que hemos inicializado
  IDList:= SHBrowseForFolder(BrowseInfo);
  //Obtenemos la ruta
  ShGetPathFromIDList(IDList, @fres);
  //segun la documentacin de windows sera necesario liberar la memoria
  //que windows reserva para la estructura IDList. Nosotros seguimos la 
  //mecanica aconsejada y hacemos uso de la interfaz IMalloc para ello.
  //El metodo Free libera la memoria asignada
  //Previamente comprobamos que podemos obtener un handle a la interfaz
  //para hacer uso de las funciones.
  if Succeeded(SHGetMalloc(Malloc)) then begin
    Malloc.Free(IDList);
  end;
  Result:= fres;
end;     

{$R *.res}

exports
  BrowseCallBackProc,
  MostrarCuadroCarpetas;

begin
end.
