unit uRegistros1;

interface

const
  PrecioBasico = 1;
  PrecioDoble  = 2;
  PrecioTriple = 3;

type
  TTarifa = class
  private
    FPrecio: Double;
    FNombreTarifa: String;
    procedure SetNombreTarifa(const Value: String);
    procedure SetPrecio(const Value: Double);
  public
   property Precio: Double read FPrecio write SetPrecio;
   property NombreTarifa: String read FNombreTarifa write SetNombreTarifa;
  end;

  TTarifaSimple = class(TTarifa)
  end;

  TTarifaDoble = class(TTarifa)
  end;

  TTarifaTriple = class(TTarifa)
  end;

  Tarifa = (fbasica, fDoble, fTriple);

  TArrayTarifa = Array[Tarifa] of TTarifa;

  TTarifaRecord = record
  private
    ListaTarifas: TArrayTarifa;
  public
    class operator Explicit(var ATarifa: TTarifaRecord): TTarifaSimple;
    class operator Explicit(var ATarifa: TTarifaRecord): TTarifaDoble;
    class operator Explicit(var ATarifa: TTarifaRecord): TTarifaTriple;
    procedure Inicializar;
    procedure Eliminar;
  end;

implementation

uses SysUtils;

class operator TTarifaRecord.Explicit(var ATarifa: TTarifaRecord): TTarifaSimple;
begin
    if ATarifa.ListaTarifas[fBasica] = Nil then begin
      Result:= TTarifaSimple.Create;
      Result.Precio:= PrecioBasico;
      Result.NombreTarifa:= 'Tarifa bsica';
      ATarifa.ListaTarifas[fBasica]:= Result;
    end
    else
      Result:= TTarifaSimple(ATarifa.ListaTarifas[fBasica]);
end;

class operator TTarifaRecord.Explicit(var ATarifa: TTarifaRecord): TTarifaDoble;
begin
    if ATarifa.ListaTarifas[fDoble] = Nil then begin
      Result:= TTarifaDoble.Create;
      Result.Precio:= PrecioDoble;
      Result.NombreTarifa:= 'Tarifa doble';
      ATarifa.ListaTarifas[fDoble]:= Result;
    end
    else
      Result:= TTarifaDoble(ATarifa.ListaTarifas[fDoble]);
end;

class operator TTarifaRecord.Explicit(var ATarifa: TTarifaRecord): TTarifaTriple;
begin
    if ATarifa.ListaTarifas[fTriple] = Nil then begin
      Result:= TTarifaTriple.Create;
      Result.Precio:= PrecioTriple;
      Result.NombreTarifa:= 'Tarifa triple';
      ATarifa.ListaTarifas[fTriple]:= Result;
    end
    else
      Result:= TTarifaTriple(ATarifa.ListaTarifas[fTriple]);
end;

procedure TTarifaRecord.Eliminar;
var
  Item: TTarifa;
begin
  for Item in ListaTarifas do begin
     if Assigned(Item) then begin
       Item.Free;
     end;
  end;
  Inicializar;
end;

procedure TTarifaRecord.Inicializar;
begin
  ListaTarifas[fBasica]:= Nil;
  ListaTarifas[fDoble]:= Nil;
  ListaTarifas[fTriple]:= Nil;
end;

{ TTarifa }

procedure TTarifa.SetNombreTarifa(const Value: String);
begin
  FNombreTarifa := Value;
end;

procedure TTarifa.SetPrecio(const Value: Double);
begin
  FPrecio := Value;
end;

end.
