unit UDatos;

interface

uses
  SysUtils, Classes, DB, DBClient, Variants;

type
   Tdatos = class(TDataModule)
    cdsArticulos: TClientDataSet;
    cdsComposicion: TClientDataSet;
    cdsIncrementaCantidad: TClientDataSet;
    Delta: TClientDataSet;
    cdsComponentes: TClientDataSet;
    cdsArticulosIDArticulo: TIntegerField;
    cdsArticulosArticulo: TStringField;
    cdsArticulosDescripcion: TStringField;
    cdsArticulosqComposicion: TDataSetField;
    cdsComposicionIDComposicion: TIntegerField;
    cdsComposicionIDArticulo: TIntegerField;
    cdsComposicionIDComponente: TIntegerField;
    cdsComposicionCantidad: TFloatField;
    cdsComposicionqComponente: TDataSetField;
    cdsComponentesIDComponente: TIntegerField;
    cdsComponentesComponente: TStringField;
    cdsComponentesDescripcion: TStringField;
    cdsComposicionComponente: TStringField;
    cdsComposicionDescripcion: TStringField;
    cdsIncrementaCantidadIDComposicion: TIntegerField;
    cdsIncrementaCantidadCantidad: TFloatField;
    procedure DataModuleCreate(Sender: TObject);
  private
    { Private declarations }
    Contador: Integer;
  public
    { Public declarations }
    procedure GuardarDatos;
    procedure IncrementaCantidad;
    procedure ObtenerTodosLosRegistros;
    procedure ObtenerUnRegistro(AKeyRecord: Integer);
    procedure Verdelta;
  end;

var
  datos: Tdatos;

implementation

uses USQLDatos, Dialogs, Provider;

{$R *.dfm}

{ Tdatos }


procedure Tdatos.DataModuleCreate(Sender: TObject);
begin
   cdsArticulos.Open;
end;

procedure Tdatos.ObtenerTodosLosRegistros;
var
 vParam : OleVariant;
 vRetorno : OleVariant;
 iRecsOut : Integer;
 sSQL: String;
begin
     sSQL:=  ' SELECT * FROM Articulos ';
     vRetorno:=
        cdsArticulos.AppServer.AS_GetRecords(
                               cdsArticulos.ProviderName,
                                                      -1,
                                                iRecsOut,
                          ord(grMetaData) + ord(grReset),
                                                   sSQL ,
                                                  vParam,
                                              EmptyParam);

  try
    Delta.Data:= vRetorno;
  except
    Delta.Data := Null;
  end;
end;


procedure Tdatos.ObtenerUnRegistro(AKeyRecord: Integer);
var
 fParams: TParams;
 vParam : OleVariant;
 vRetorno : OleVariant;
 iRecsOut : Integer;
 sSQL: String;
begin
   sSQL:=  ' SELECT * FROM   Articulos ' +
           ' WHERE IDArticulo = :IDArticulo ';

   fParams:= TParams.Create;
   try
     fParams.ParseSQL(sSQL, True);
     fParams.ParamByName('IDArticulo').AsInteger:= AKeyRecord;
     vParam:=  PackageParams(fParams);

     vRetorno:=
             cdsArticulos.AppServer.AS_GetRecords(
                               cdsArticulos.ProviderName,
                                                      -1,
                                                iRecsOut,
                          ord(grMetaData) + ord(grReset),
                                                   sSQL ,
                                                  vParam,
                                              EmptyParam);

     try
       Delta.Data:= vRetorno;
     except
       Delta.Data:= Null;
     end;

   finally
      FreeAndNil(fParams);
   end;

end;

procedure Tdatos.GuardarDatos;
begin
   cdsArticulos.ApplyUpdates(0);
end;

//incrementamos 10 unidades la cantidad de todos los componentes
procedure Tdatos.IncrementaCantidad;
begin
   cdsIncrementaCantidad.Execute;
end;

procedure Tdatos.Verdelta;
begin
  try
    Delta.Data := cdsArticulos.Delta;
  except
    Delta.Data := Null;
  end;
end;


end.
