unit URelaciones;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, DB, DBClient, TConnect, Provider, uAtributos;

type
  TRelaciones = class(TForm)
    lbx2: TListBox;
    lbx3: TListBox;
    bnSolucion: TButton;
    lb2: TLabel;
    lb3: TLabel;
    lb1: TLabel;
    cdsTipo: TClientDataSet;
    cdsTipoTipo: TStringField;
    cdsColor: TClientDataSet;
    StringField2: TStringField;
    cdsTipoIDTipo: TIntegerField;
    cdsColorIDColor: TIntegerField;
    lb0: TLabel;
    lb4: TLabel;
    lab0: TLabel;
    lab1: TLabel;
    lab2: TLabel;
    lab3: TLabel;
    lbx0: TListBox;
    lbx1: TListBox;
    sh3: TShape;
    sh2: TShape;
    sh1: TShape;
    sh0: TShape;
    Bevel1: TBevel;
    lbCombinaciones: TLabel;
    Label7: TLabel;
    rgpAtributos: TRadioGroup;
    bnSubir: TButton;
    bnBajar: TButton;
    memCombinaciones: TMemo;
    memDescartes: TMemo;
    labNumCombinaciones: TLabel;
    labNumDescartes: TLabel;
    Label1: TLabel;
    labTotalCombinaciones: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure bnSolucionClick(Sender: TObject);
    procedure bnSubirClick(Sender: TObject);
    procedure bnBajarClick(Sender: TObject);
  private
    { Private declarations }
    FGenerador: TGenerador;
    procedure SimulaDatosEnBBDD;
    procedure ActualizarInterfaz;
    procedure ActualizaControles(ARotulo, ATexto: TLabel; AValores: TListBox; ATestigo: TShape; AIndice: Integer);
  public
    { Public declarations }
  end;

var
  Relaciones: TRelaciones;

implementation



{$R *.dfm}



procedure TRelaciones.ActualizaControles(ARotulo, ATexto: TLabel;
  AValores: TListBox; ATestigo: TShape; AIndice: Integer);
var
  i: Integer;
  FAtrib: TAtributo;
  s: String;
  fCadenaDependencias: String;
  fEstructura: TEstructura;
begin
  FAtrib:= FGenerador.Atributos[AIndice];

  s:= 'Nombre: ' + FAtrib.Caption + #13#10;

  s:= s + 'Multiplicador ' + IntToStr(fAtrib.GetMultiplicador)+ #13#10;

  s:= s + 'N de Valores ' +  IntToStr(fAtrib.ValuesCount)+ #13#10;

  s:= s + 'Posicion ' + IntToStr(fAtrib.Posicion)+ #13#10;

  if FAtrib.Combinable  then begin
     s:= s + 'Tipo: ' + #13#10 + ' - Combinable ' + #13#10;
     s:= s + ' - Valor variable '+ #13#10;
     if Assigned(FAtrib.DependienteDe) then
     begin
         s:= s + ' - Dependiente'+#13#10;
         s:= s + ' - Depende de ' + FAtrib.DependienteDe.Caption;
     end;

     if Assigned(FAtrib.RellenableDe) then
     begin
        s:= s + ' - Rellenable ' + #13#10;
        s:= s + ' - Rellena de ' + FAtrib.RellenableDe.Caption;
     end;
  end
  else begin
      s:= s + 'Tipo: ' + #13#10 + ' - No Combinable ' + #13#10;
      s:= s + ' - Valor fijo'+#13#10;
  end;
  ARotulo.Caption:= s;

  ATexto.Caption:= FAtrib.Caption;

  AValores.Items.Clear;
  if FAtrib.Combinable then begin

  for i := 0 to fGenerador.Atributos[AIndice].ValuesCount - 1 do
     if Assigned(fGenerador.Atributos[AIndice].DependienteDe) then begin
        fCadenaDependencias:= '';
        fEstructura:= fGenerador.Atributos[AIndice].Dependencia[i];

        if fEstructura.Siguiente = Nil then begin
           fCadenaDependencias:= fCadenaDependencias + ' | ' +
                                 fGenerador.Atributos[AIndice].DependienteDe.Values[fEstructura.Indice];
           AValores.Items.Add(fGenerador.Atributos[AIndice].Values[i] + '->' +  fCadenaDependencias);
        end
        else begin
           while fEstructura.Siguiente <> nil do begin
              fCadenaDependencias:= fCadenaDependencias + ' | ' +
                                 fGenerador.Atributos[AIndice].DependienteDe.Values[fEstructura.Indice];
              fEstructura:= TEstructura(fEstructura.Siguiente);
              if fEstructura.Siguiente = Nil then begin
                 fCadenaDependencias:= fCadenaDependencias + ' | ' +
                                 fGenerador.Atributos[AIndice].DependienteDe.Values[fEstructura.Indice];
              end;
           end;
           AValores.Items.Add(fGenerador.Atributos[AIndice].Values[i] + '->' +  fCadenaDependencias);
        end;
     end
     else AValores.Items.Add(fGenerador.Atributos[AIndice].Values[i]);
  end
  else begin
       AValores.Items.Add(FAtrib.Values[0]);
  end;

  ATestigo.Visible:= FAtrib.Combinable;
end;

procedure TRelaciones.ActualizarInterfaz;
var
  i: Integer;
begin
   for i := 0 to FGenerador.Count - 1 do begin
      case i of
         0: ActualizaControles(lab0, lb0, lbx0, sh0, i);
         1: ActualizaControles(lab1, lb1, lbx1, sh1, i);
         2: ActualizaControles(lab2, lb2, lbx2, sh2, i);
         3: ActualizaControles(lab3, lb3, lbx3, sh3, i);
      end;
   end;
end;

procedure TRelaciones.bnBajarClick(Sender: TObject);
var
  fAtributos: TAtributo;
begin
   fAtributos:= fGenerador.Atributos[rgpAtributos.ItemIndex];
   fAtributos.DownPosicion;
   rgpAtributos.ItemIndex:= fAtributos.Posicion;
   ActualizarInterfaz;
end;

procedure TRelaciones.bnSolucionClick(Sender: TObject);
var
  fLineas: TStrings;
  i, j: Integer;
begin
  TGenerador(fGenerador).Combinar;
  memDescartes.Clear;
  memCombinaciones.Clear;
  for i:= 0 to fGenerador.GetTotalCombinaciones-1 do begin
    if fGenerador.Descartado[i] then
      memDescartes.Lines.Add(fGenerador.Combinaciones[i])
    else memCombinaciones.Lines.Add(fGenerador.Combinaciones[i]);
  end;
  labTotalCombinaciones.Caption:= 'Total de combinaciones posibles: ' + IntToStr(fGenerador.GetTotalCombinaciones);

  labNumCombinaciones.Caption:= ' Total: ' + IntToStr(memCombinaciones.Lines.Count);
  labNumDescartes.Caption:= ' Total: ' + IntToStr(memDescartes.Lines.Count);
end;

procedure TRelaciones.bnSubirClick(Sender: TObject);
var
  fAtributos: TAtributo;
begin
   fAtributos:= fGenerador.Atributos[rgpAtributos.ItemIndex];
   fAtributos.UpPosicion;
   rgpAtributos.ItemIndex:= fAtributos.Posicion;
   ActualizarInterfaz;
end;

procedure TRelaciones.FormCreate(Sender: TObject);
var
  FAtrib, FAtribRell,fAtribDep: TAtributo;
begin
  FGenerador:= TGenerador.Create;

  SimulaDatosEnBBDD;

  //Ponemos un ejemplo de atributo no combinable con valor fijo no seleccionable
  FAtrib:= FGenerador.AddAtributo;
  FAtrib.Caption:= 'Atributo 1';
  FAtrib.Combinable:= False;
  FAtrib.AddValue('ZZ');


  FAtrib:= FGenerador.AddAtributo;
  FAtrib.Caption:= 'Atributo 2 (Tipo)';
  FAtrib.Combinable:= True;

  if not cdsTipo.Active then cdsTipo.Open;
  cdsTipo.First;
  while not cdsTipo.Eof do begin
    fAtrib.AddValue(cdsTipo.FieldByName('Tipo').AsString);
    cdsTipo.Next;
  end;


  FAtribDep:= FGenerador.AddAtributo;
  FAtribDep.Caption:= 'Atributo 3 (Color)';
  FAtribDep.Combinable:= True;
  FAtribDep.DependienteDe:= fAtrib;

  //para probar el atributo "dependendiente de"
  //vamos a hacer depender los colores de dos de los atributos tipo
  //de forma que solo consideraremos validas las asignaciones encontradas
  //entre tipo y color
  //en este caso vinculamos todos los colores con AA y AB.
  //Este tipo de atributo nos permite descartar combinaciones.
  if not cdsColor.Active then cdsColor.Open;
  cdsColor.First;
  while not cdsColor.Eof do begin
    fAtribDep.AddValue(cdsColor.FieldByName('Color').AsString, 'AA');
    fAtribDep.AddValue(cdsColor.FieldByName('Color').AsString, 'AB');
    cdsColor.Next;
  end;


  FAtribRell:= FGenerador.AddAtributo;
  FAtribRell.Combinable:= True;
  FAtribRell.Caption:= 'Atributo 4';
  FAtribRell.RellenableDe:= fAtrib;

  ActualizarInterfaz;
end;

procedure TRelaciones.FormDestroy(Sender: TObject);
begin
  //guardamos los datos antes de finalizar
  //SimulaPermanenciaDatos;

  FreeAndNil(FGenerador);
end;

procedure TRelaciones.SimulaDatosEnBBDD;
begin
  //simulamos los datos de la tabla color
  cdsColor.FileName:= 'Color.xml';
  cdsColor.CreateDataSet;
  cdsColor.Active:= True;
  cdsColor.Insert;
  cdsColor.FieldByName('IDColor').AsInteger:= 1;
  cdsColor.FieldByName('Color').AsString:= '10';
  cdsColor.Insert;
  cdsColor.FieldByName('IDColor').AsInteger:= 2;
  cdsColor.FieldByName('Color').AsString:= '12';
  cdsColor.Insert;
  cdsColor.FieldByName('IDColor').AsInteger:= 3;
  cdsColor.FieldByName('Color').AsString:= '15';
  cdsColor.Insert;
  cdsColor.FieldByName('IDColor').AsInteger:= 4;
  cdsColor.FieldByName('Color').AsString:= '18';
  cdsColor.Post;
  //simulamos los datos de la tabla  tipo
  cdsTipo.FileName:= 'Tipo.xml';
  cdsTipo.CreateDataSet;
  cdsTipo.Active:= True;
  cdsTipo.Insert;
  cdsTipo.FieldByName('IDTipo').AsInteger:= 1;
  cdsTipo.FieldByName('Tipo').AsString:= 'AA';
  cdsTipo.Insert;
  cdsTipo.FieldByName('IDTipo').AsInteger:= 2;
  cdsTipo.FieldByName('Tipo').AsString:= 'AB';
  cdsTipo.Insert;
  cdsTipo.FieldByName('IDTipo').AsInteger:= 3;
  cdsTipo.FieldByName('Tipo').AsString:= 'CC';
  cdsTipo.Insert;
  cdsTipo.FieldByName('IDTipo').AsInteger:= 4;
  cdsTipo.FieldByName('Tipo').AsString:= 'CB';
  cdsTipo.Insert;
  cdsTipo.FieldByName('IDTipo').AsInteger:= 5;
  cdsTipo.FieldByName('Tipo').AsString:= 'CD';
  cdsTipo.Insert;
  cdsTipo.FieldByName('IDTipo').AsInteger:= 6;
  cdsTipo.FieldByName('Tipo').AsString:= 'FF';
  cdsTipo.Post;
end;


end.
