unit uAtributos;

interface


uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms, DB,
  Dialogs;

type

  TEstructura = Class(TObject)
    FIndice: Integer;
    FSiguiente: TObject;
  private
    procedure SetIndice(const Value: Integer);
    procedure SetSiguiente(const Value: TObject);
  published
  public
  constructor Create;
  destructor Destroy; override;
  function Situar(AIndice: Integer): TEstructura;
  property Indice: Integer read FIndice write SetIndice;
  property Siguiente: TObject read FSiguiente write SetSiguiente;
  end;

  TAtributo = class;

  TGenerador = Class(TObject)
  private
    FAtributos: TList;
    FCombinaciones: TStringList;
    function GetAtributos(Indice: Integer): TAtributo;
    function GetDescartado(Indice: Integer): Boolean;
    procedure SetDescartado(Indice: Integer; const Value: Boolean);
    function GetCombinaciones(Indice: Integer): String;
   protected
    procedure DoCombinar; virtual;
    procedure DoLimpiarCombinaciones; virtual;
    procedure AssignCombinaciones; virtual;
  public
    constructor Create;
    destructor Destroy; override;
    function Count: Integer;
    procedure SetUpPosition(AAtributo: TAtributo);
    procedure SetDownPosition(AAtributo: TAtributo);
    function GetPosicion(AAtributo: TAtributo): Integer;
    function GetMultiplicador(AAtributo: TAtributo): Integer;
    function GetTotalCombinaciones: Integer;
    function AddAtributo: TAtributo;
    procedure Combinar; virtual;
    procedure VerificarDependencias;
    property Atributos[Indice: Integer]: TAtributo read GetAtributos;
    property Descartado[Indice: Integer]: Boolean read GetDescartado write SetDescartado;
    property Combinaciones[Indice: Integer]: String read GetCombinaciones;
  end;


  TAtributo = class(TObject)
  private
    FGenerador: TGenerador;
    FListaValores: TStrings;
    FCombinaciones: TStrings;
    FCombinable: Boolean;
    FCaption: String;
    FRellenableDe: TAtributo;
    FDependienteDe: TAtributo;
    procedure SetCombinable(const Value: Boolean);
    procedure SetCaption(const Value: String);
    function GetValues(Indice: Integer): String;
    procedure SetValues(Indice: Integer; const Value: String);
    function GetCombinacion(Indice: Integer): String;
    procedure SetRellenableDe(const Value: TAtributo);
    procedure SetDependienteDe(const Value: TAtributo);
    function GetDependencia(Indice: Integer): TEstructura;
    function GetPosicion: Integer;
    { Private declarations }
  protected
    function DoGetMultiplicador: Integer; virtual;
  public
    { Public declarations }
    procedure LimpiarCombinaciones;
    procedure Combinar;
    function GetMultiplicador: Integer;
    function ValuesCount: Integer;
    procedure UpPosicion;
    procedure DownPosicion;
    constructor Create(AGenerador: TGenerador); virtual;
    destructor Destroy; override;
    function AddValue(const AValue: String): Integer; overload;
    function AddValue(const AValue, ADependencia: String): Integer; overload;
    procedure DeleteValue(const AValor: String);
    procedure VerificarDependencias;
    property Combinable: Boolean read FCombinable write SetCombinable;
    property Posicion: Integer read GetPosicion;
    property Caption: String read FCaption write SetCaption;
    property Values[Indice: Integer]: String read GetValues write SetValues;
    property Dependencia[Indice: Integer]: TEstructura read GetDependencia;
    property Combinacion[Indice: Integer]: String read GetCombinacion;
    property RellenableDe: TAtributo read FRellenableDe write SetRellenableDe;
    property DependienteDe: TAtributo read FDependienteDe write SetDependienteDe;
  end;



implementation




{ TAtributo }


function TAtributo.AddValue(const AValue: String): Integer;
begin
  { CONDICIONES PARA AADIR VALOR + DE UN VALOR
     * Que sea combinable el atributo
     * Que no sea rellenable
     * Que no sea dependiente de (es ese caso debe utilizar la otra funcion hermana)
  }
  if Combinable then begin
     if (not Assigned(FRellenableDe)) and (not Assigned(FDependienteDe)) then
       Result:= FListaValores.Add(AValue)
     else Result:= -1
  end
  else begin  //si no es combinable solo podemos aadir un valor a la lista
              //De ya existir lo que queremos es sustituirlo
     if ValuesCount = 0 then Result:= FListaValores.Add(AValue)
     else begin
        Values[0]:= AValue;
        Result:= 0;
     end;
  end;
end;

function TAtributo.AddValue(const AValue, ADependencia: String): Integer;
var
  i, j: Integer;
  fEstructura: TEstructura;
begin
  { CONDICIONES PARA AADIR VALOR + DE UN VALOR
     * Que sea combinable el atributo
     * Que no sea rellenable
     * Que sea dependiente de.
  }
  if Combinable and (not Assigned(FRellenableDe)) and (Assigned(FDependienteDe)) then begin
     for i:=0 to FDependienteDe.ValuesCount - 1 do begin
        //comprobamos que la cadena existe en el anexo al dependiente para saber el indice
        if fDependienteDe.Values[i] = ADependencia then begin
           for j := 0 to FListaValores.Count - 1 do begin
              if FListaValores.Strings[j] = AValue then begin
                 TEstructura(FListaValores.Objects[j]).Situar(i);
                 Exit;
              end;
           end;
           //si se crea es que no existe ese valor en la lista
           fEstructura:= TEstructura.Create;
           fEstructura.Indice:= i;
           fEstructura.Siguiente:= Nil;
           Result:= FListaValores.AddObject(AValue, fEstructura);
        end;
     end;
  end
  else Result:= -1;
end;

procedure TAtributo.Combinar;
var
  i,j: Integer;
  iIndice: Integer;
  iMax: Integer;
  iMultiplicador: Integer;
begin
  i:= 0;
  j:= 0;
  iIndice:= 0;;
  if (FCombinable)then begin
    if (NOT Assigned(FRellenableDe)) then begin
       if FListaValores.Count = 0 then
          Raise Exception.Create('Error: Atributo combinable no tiene valores');
       //tomamos los datos necesario para hacer la combinacion
       iMax:= fGenerador.GetTotalCombinaciones;
       iMultiplicador:= GetMultiplicador;

       FCombinaciones.Clear;
       while i < iMax do begin
         while j < iMultiplicador do begin
            fCombinaciones.Add(FListaValores[iIndice]);
            Inc(j);
            Inc(i);
         end;
         Inc(iIndice);
         if iIndice = FListaValores.Count then iIndice:= 0;
         j:= 0;
       end;
    end;
  end
  else if FListaValores.Count = 0 then
          Raise Exception.Create('Error: Atributo no tcombinable no tiene valores');
end;

constructor TAtributo.Create(AGenerador: TGenerador);
begin
  if not Assigned(AGenerador)  then
     Raise Exception.Create('Error: Generador no valido');

  fListaValores:= TStringList.Create;
  fGenerador:= AGenerador;
  fCombinable:= False;
  fCombinaciones:= TStringList.Create;
  fRellenableDe:= Nil;
end;

procedure TAtributo.DeleteValue(const AValor: String);
var
  i: Integer;
begin
   i:= fListaValores.IndexOf(AValor);
   if i <> -1 then fListaValores.Delete(i);
end;

destructor TAtributo.Destroy;
begin
  //desvinculamos con el generador
  fGenerador:= Nil;
  //vaciamos la lista de valores y eliminamos la lista
  fListaValores.Clear;
  FreeAndNil(fListaValores);
  fCombinaciones.Clear;
  FreeAndNil(fCombinaciones);
  inherited;
end;

function TAtributo.DoGetMultiplicador: Integer;
begin
   Result:= fGenerador.GetMultiplicador(Self);
end;

procedure TAtributo.DownPosicion;
begin
  with FGenerador do begin
     SetDownPosition(Self);
  end;
end;

function TAtributo.GetCombinacion(Indice: Integer): String;
begin
  if (Indice < 0) or (Indice > fCombinaciones.Count-1)then
     Raise Exception.Create('Error indice get fuera de rango');
  Result:= fCombinaciones[Indice];
end;

function TAtributo.GetDependencia(Indice: Integer): TEstructura;
begin
   if Assigned(DependienteDe) then
      Result:= TEstructura(FListaValores.Objects[Indice])
   else Result:= Nil;
end;

function TAtributo.GetMultiplicador: Integer;
begin
   Result:= DoGetMultiplicador;
end;


function TAtributo.GetPosicion: Integer;
begin
  Result:= FGenerador.GetPosicion(Self);
end;

function TAtributo.GetValues(Indice: Integer): String;
begin
  if (Indice < 0) or (Indice > fListaValores.Count-1)then
     Raise Exception.Create('Error indice get fuera de rango');
  Result:= fListaValores[Indice];
end;

procedure TAtributo.LimpiarCombinaciones;
begin
  FCombinaciones.Clear;
end;


procedure TAtributo.SetCaption(const Value: String);
begin
  FCaption := Value;
end;

procedure TAtributo.SetCombinable(const Value: Boolean);
begin
  if Value <> FCombinable then begin
     if not Value then begin
        FListaValores.Clear;
        FCombinaciones.Clear;
     end;
     FCombinable := Value;
  end;
end;

procedure TAtributo.SetDependienteDe(const Value: TAtributo);
begin
  if (not Value.Combinable) or Assigned(Value.RellenableDe) then
     Raise Exception.Create('No puede depender un atributo de otro no combinable o rellenable de');
  FDependienteDe := Value;
end;

procedure TAtributo.SetRellenableDe(const Value: TAtributo);
begin
  if (not Value.Combinable) or Assigned(Value.RellenableDe) then
     Raise Exception.Create('No puede depender un atributo de otro no combinable o rellenable de');

  FRellenableDe := Value;
end;



procedure TAtributo.SetValues(Indice: Integer; const Value: String);
begin
  if (Indice < 0) or (Indice > fListaValores.Count-1)then
     Raise Exception.Create('Error indice set fuera de rango');
  fListaValores[Indice]:= Value;
end;

procedure TAtributo.UpPosicion;
begin
  with FGenerador do begin
     SetUpPosition(Self);
  end;
end;

function TAtributo.ValuesCount: Integer;
begin
  Result:= FListaValores.Count;
end;

procedure TAtributo.VerificarDependencias;
var
  i, j, k: Integer;
  s1, s2: String;
  bEncontrado: Boolean;
  fEstructura: TEstructura;
begin
  i:= 0;
  if Assigned(FDependienteDe) then begin
     if FListaValores.Count = 0 then
        Raise Exception.Create('Error: Atributo combinable no tiene valores');
     //tomamos los datos necesario para hacer la combinacion
     for i := 0 to FCombinaciones.Count - 1 do begin
        s2:= FDependienteDe.FCombinaciones[i];
        //indice del valor en la tabla de valores de la actual combinacion
        j:= FListaValores.IndexOf(FCombinaciones[i]);
        //buscamos el indice de la dependencia
        fEstructura:= Dependencia[j];
        bEncontrado:= False;
        if fEstructura.Siguiente = Nil then begin
            s1:= FDependienteDe.FListaValores[fEstructura.Indice];
            if s1 = s2 then begin
               bEncontrado:= True;
            end;
        end
        else begin
          while fEstructura.Siguiente <> Nil do begin
             s1:= FDependienteDe.FListaValores[fEstructura.Indice];
             if s1 = s2 then begin
                bEncontrado:= True;
                Break;
             end;
             //avanzamos
             fEstructura:= TEstructura(fEstructura.Siguiente);
             if fEstructura.Siguiente = Nil then begin
                s1:= FDependienteDe.FListaValores[fEstructura.Indice];
                if s1 = s2 then begin
                   bEncontrado:= True;
                end;
             end;
          end;
        end;

        if not bEncontrado then   
           FGenerador.Descartado[i]:= True;
     end;
  end;
end;

{ TGenerador }

function TGenerador.AddAtributo: TAtributo;
begin
   Result:= TAtributo.Create(Self);
   FAtributos.Add(Result);
end;


procedure TGenerador.AssignCombinaciones;
var
 i, j: Integer;
 s: String;
begin
    FCombinaciones.Clear;
    for i := 0 to GetTotalCombinaciones - 1 do begin
       s:= '';
       for j := 0 to FAtributos.Count - 1 do
          if (TAtributo(FAtributos[j]).Combinable)  then begin
             if (not Assigned(TAtributo(FAtributos[j]).RellenableDe)) then
                s:= s + ' ' + TAtributo(FAtributos[j]).Combinacion[i]
             else s:= s + ' ' + TAtributo(FAtributos[j]).RellenableDe.Combinacion[i];
          end
          else s:= s + ' ' + TAtributo(FAtributos[j]).Values[0];
       FCombinaciones.Add(s);
    end;
end;

procedure TGenerador.Combinar;
begin
  DoCombinar;
end;

function TGenerador.Count: Integer;
begin
   Result:= FAtributos.Count;
end;

constructor TGenerador.Create;
begin
  inherited;
  FAtributos:= TList.Create;
  FCombinaciones:= TStringList.Create;
end;

destructor TGenerador.Destroy;
var
 i: Integer;
 f: TAtributo;
begin
  for i:= 0 to FAtributos.Count - 1 do begin
    f:= TAtributo(FAtributos[i]);
    FreeAndNil(f);
  end;
  FAtributos.Clear;
  FreeAndNil(FAtributos);
  //limpiamos las combinaciones creadas
  FCombinaciones.Clear;
  FreeAndNil(FCombinaciones);
  inherited;
end;

procedure TGenerador.DoCombinar;
var
  i: Integer;
begin
  try
     //combinamos
     for i := 0 to Count - 1 do Atributos[i].Combinar;
     //marcamos resultados no validos
     AssignCombinaciones;
     for i := 0 to Count - 1 do Atributos[i].VerificarDependencias;
  except
     DoLimpiarCombinaciones;
     Raise;
  end;
end;

procedure TGenerador.DoLimpiarCombinaciones;
var
  i: Integer;
begin
     for i := 0 to Count - 1 do Atributos[i].LimpiarCombinaciones;
end;


function TGenerador.GetAtributos(Indice: Integer): TAtributo;
begin
   if (Indice < 0) or (Indice > fAtributos.Count-1)then
     Raise Exception.Create('Error indice get fuera de rango');
   Result:= FAtributos[Indice];
end;

function TGenerador.GetCombinaciones(Indice: Integer): String;
begin
   if (Indice < 0) or (Indice > FCombinaciones.Count-1)then
     Raise Exception.Create('Error indice get fuera de rango');
   Result:= FCombinaciones.Strings[Indice];
end;

function TGenerador.GetDescartado(Indice: Integer): Boolean;
begin
  Result:= Integer(FCombinaciones.Objects[Indice])= 1;
end;

function TGenerador.GetMultiplicador(AAtributo: TAtributo): Integer;
var
  i,j: Integer;
begin
   if (AAtributo.Combinable) and (not Assigned(AAtributo.RellenableDe)) then
   begin
      Result:= 1;
      i:= FAtributos.IndexOf(AAtributo);
      if  (i < 0) then Result:= -1
      else begin
         for j := i+1 to FAtributos.Count - 1 do
            if (TAtributo(FAtributos[j]).ValuesCount = 0) or
                            (not TAtributo(FAtributos[j]).Combinable)    then
               Result:= Result * 1
            else Result:= Result * TAtributo(FAtributos[j]).ValuesCount;
      end;
   end
   else begin
      Result:= 1;
   end;
end;

function TGenerador.GetPosicion(AAtributo: TAtributo): Integer;
begin
   Result:= FAtributos.IndexOf(AAtributo);
end;

function TGenerador.GetTotalCombinaciones: Integer;
var
  i: Integer;
begin
   Result:= 1;
   for i := 0 to FAtributos.Count - 1 do
      if (TAtributo(FAtributos[i]).Combinable) and (Not Assigned(TAtributo(FAtributos[i]).RellenableDe)) then begin
         if TAtributo(FAtributos[i]).ValuesCount > 0 then
           Result:= Result * TAtributo(FAtributos[i]).ValuesCount
         else Result:= Result * 1;
      end
      else  Result:= Result * 1;
end;


procedure TGenerador.SetDescartado(Indice: Integer; const Value: Boolean);
begin
   if Value then FCombinaciones.Objects[Indice]:= TObject(1)
   else FCombinaciones.Objects[Indice]:= TObject(0);
end;

procedure TGenerador.SetDownPosition(AAtributo: TAtributo);
var
  i: Integer;
begin
   i:= FAtributos.IndexOf(AAtributo);
   if (i < Count -1) then FAtributos.Exchange(i, i+1);
end;


procedure TGenerador.SetUpPosition(AAtributo: TAtributo);
var
  i: Integer;
begin
   i:= FAtributos.IndexOf(AAtributo);
   if (i > 0) then FAtributos.Exchange(i, i-1);
end;

procedure TGenerador.VerificarDependencias;
var
  i: Integer;
begin
   for i := 0 to FAtributos.Count - 1 do
      if Assigned(TAtributo(FAtributos[i]).DependienteDe) then
         TAtributo(FAtributos[i]).VerificarDependencias;
end;



{ TEstructura }

constructor TEstructura.Create;
begin
  inherited;
  Siguiente:= Nil;
end;

destructor TEstructura.Destroy;
begin
  if Assigned(Siguiente) then FreeAndNil(TEstructura(FSiguiente));
  inherited;
end;

procedure TEstructura.SetIndice(const Value: Integer);
begin
  FIndice := Value;
end;

procedure TEstructura.SetSiguiente(const Value: TObject);
begin
  FSiguiente := Value;
end;

function TEstructura.Situar(AIndice: Integer): TEstructura;
var
  fEstructura: TEstructura;
begin
  if Assigned(Siguiente) then begin
     //solo si es distinto tenemos que seguir buscando la primera
     //estructura libre porque si no seria seal de que est repetido
     if (AIndice <> Indice)  then
        TEstructura(Siguiente).Situar(AIndice);
  end
  else begin
     fEstructura:= TEstructura.Create;
     fEstructura.Indice:= AIndice;
     fEstructura.Siguiente:= Nil;
     Siguiente:= fEstructura;
  end;
end;

end.
