unit UBusquedasConExpRegulares;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, CheckLst, ComCtrls, ActnList,PerlRegEx;

CONST
 NO_ENCONTRADO = 'No se ha encontrado coincidencia...';

type
  TBusquedasConExpRegulares = class(TForm)
    edCadenaBusqueda: TEdit;
    bnIniciar: TButton;
    bnContinuar: TButton;
    Label2: TLabel;
    Label1: TLabel;
    chlxOpciones: TCheckListBox;
    lbxResultados: TListBox;
    rchContenedorTexto: TRichEdit;
    Label3: TLabel;
    Label4: TLabel;
    Acciones: TActionList;
    acIniciar: TAction;
    acSeguir: TAction;
    sbBusqueda: TStatusBar;
    pre: TPerlRegEx;
    procedure FormCreate(Sender: TObject);
    procedure acIniciarExecute(Sender: TObject);
    procedure acIniciarUpdate(Sender: TObject);
    procedure acSeguirExecute(Sender: TObject);
    procedure acSeguirUpdate(Sender: TObject);
  private
    { Private declarations }
    procedure TextoBarraEstado(ALength, AOffset: Integer);
  public
    { Public declarations }
  end;

var
  BusquedasConExpRegulares: TBusquedasConExpRegulares;

implementation

{$R *.dfm}


uses WideStrUtils;


{
preCaseLess
preMultiLine
preSingleLine
preExtendex
preAnchored
preUnGreedy
preNoAutoCapture
}

procedure TBusquedasConExpRegulares.acIniciarExecute(Sender: TObject);
var
  i: Integer;
  fOp: TPerlRegExOptions;
  s: UTF8String;
begin
   lbxResultados.Items.Clear;
   pre.RegEx:= edCadenaBusqueda.Text;

   s:= '';
   for i := 0 to rchContenedorTexto.Lines.Count-1 do
     s:= s + rchContenedorTexto.Lines[i];

   pre.Subject:= s;

   pre.Options:= [];
   for i := 0 to chlxOpciones.Count - 1 do
   begin
      if chlxOpciones.Checked[i] then
         case i of
           0: pre.Options:= pre.Options + [preCaseLess];
           1: pre.Options:= pre.Options + [preMultiLine];
           2: pre.Options:= pre.Options + [preSingleLine];
           3: pre.Options:= pre.Options + [preExtended];
           4: pre.Options:= pre.Options + [preAnchored];
           5: pre.Options:= pre.Options + [preUnGreedy];
           6: pre.Options:= pre.Options + [preNoAutoCapture];
         end;
   end;
   if pre.Match then
   begin
      lbxResultados.Items.Add(pre.MatchedExpression);
      rchContenedorTexto.SelStart:= pre.MatchedExpressionOffset-1;
      rchContenedorTexto.SelLength:= pre.MatchedExpressionLength;
      TextoBarraEstado(pre.MatchedExpressionLength, pre.MatchedExpressionOffset);
   end
   else lbxResultados.Items.Add(NO_ENCONTRADO)
end;

procedure TBusquedasConExpRegulares.acIniciarUpdate(Sender: TObject);
begin
 acIniciar.Enabled:= not pre.FoundMatch;
end;

procedure TBusquedasConExpRegulares.acSeguirExecute(Sender: TObject);
begin
  if pre.MatchAgain then
  begin
   lbxResultados.Items.Add(pre.MatchedExpression);
   rchContenedorTexto.SelStart:= pre.MatchedExpressionOffset-1;
   rchContenedorTexto.SelLength:= pre.MatchedExpressionLength;
   TextoBarraEstado(pre.MatchedExpressionLength, pre.MatchedExpressionOffset);
  end
  else begin
    lbxResultados.Items.Add(NO_ENCONTRADO);
  end;
end;

procedure TBusquedasConExpRegulares.acSeguirUpdate(Sender: TObject);
begin
 acSeguir.Enabled:= pre.FoundMatch;
end;

procedure TBusquedasConExpRegulares.FormCreate(Sender: TObject);
begin
  rchContenedorTexto.Lines.LoadFromFile('texto.txt');
end;

procedure TBusquedasConExpRegulares.TextoBarraEstado(ALength, AOffSet: Integer);
begin
 with sbBusqueda do
 begin
   sbBusqueda.Panels[0].Text:= 'Length:'+ IntToStr(ALength);
   sbBusqueda.Panels[1].Text:= 'OffSet:'+ IntToStr(AOffSet);
 end;
end;

end.
