unit UFuncionesAuxiliares;

interface

uses
  Windows, SysUtils, Classes, PsApi;

//ms-help://embarcadero.rs_xe/codesamples/UnicodeConversion_(Delphi).html

function LeeCampo(var ACadena: String): string;
function LoadFile(const FileName: TFileName): string;
function CantidadInstancias: Integer;

implementation

uses ShellApi;

function LeeCampo(var ACadena: String): string;
var
  FPos: Integer;
begin
  Result:= '';
  FPos:= Pos('#', ACadena);
  if FPos > 0 then begin
     Result:= Copy(ACadena, 1, FPos - 1);
     ACadena:= Copy(ACadena, FPos + 1, Length(ACadena) - FPos);
  end;
end;

function LoadFile(const FileName: TFileName): string;
var
 Buffer: TBytes;
 fSize: Integer;
 Encoding: TEncoding;
begin
  Encoding:= nil;
  with TFileStream.Create(FileName, fmOpenRead or fmShareDenyWrite) do begin
    try
      fSize:= Size;
      SetLength(Buffer, fSize);
      ReadBuffer(Pointer(Buffer)^, Length(Buffer));
      fSize := TEncoding.GetBufferEncoding(Buffer, Encoding);
      Result:= Encoding.GetString(Buffer, fSize, Length(Buffer) - fSize);
    except
      Result := '';
      Free;
      raise;
    end;
    Free;
  end;
end;

{
Funcin para Delphi 2007 y anteriores por tema unicode

function LoadFile(const FileName: TFileName): string;
begin
  with TFileStream.Create(FileName,
      fmOpenRead or fmShareDenyWrite) do begin
    try
      SetLength(Result, Size);
      Read(Pointer(Result)^, Size);
    except
      Result := '';  // Deallocates memory
      Free;
      raise;
    end;
    Free;
  end;
end;
}


function CantidadInstancias: Integer;
var
  Procesos: array[1..1024] of DWORD;
  Needed, i: DWORD;
  Process: THandle;
  ModName: array[0..MAX_PATH] of Char;
begin
  Result:= 0;
  if EnumProcesses(@Procesos,SizeOf(Procesos),Needed) then
  begin
    for i:= 1 to (Needed div Sizeof(DWORD)) do
    begin
      Process := OpenProcess(PROCESS_QUERY_INFORMATION or PROCESS_VM_READ,
        FALSE,Procesos[i]);
      if Process <> 0 then
      begin
        if GetModuleFileNameEx(Process,0,ModName,SizeOf(ModName)-1)>0  then
        begin
          if StrIComp(ModName,PChar(ParamStr(0))) = 0 then
            inc(Result);
        end;
        CloseHandle(Process);
      end;
    end;
  end;
end;

end.
