unit UModuloBase;

interface

uses
  SysUtils, Classes, UColaImpresion;

type
  ClaseBase = class of TModuloBase;

  TModuloBase = class(TDataModule)
  private
    { Private declarations }
  protected
    function GetIndexByClass(AModuleClass: ClaseBase): Integer; virtual;
  public
    { Public declarations }
    //se invocan y sobrescriben desde los descendientes
    //en las secciones de inicializacion y finalizacion
    class function RegistrarClase(AModuleClass: ClaseBase; Index: Integer): Integer; virtual;
    class procedure EliminarRegistroClase(AModuleClass: ClaseBase); virtual;
    //es utilzada para obtener la clase efectiva desde un modulo externo
    //a traves del indice registrado
    class function GetModuleClass(AIndex: Integer): ClaseBase;

    procedure Procesar(AFuncion: Integer; ATrabajo: TTrabajo); virtual; abstract;
    function GetIndex: Integer; virtual;
  end;

implementation

{$R *.dfm}

var
 VarRegister: TStrings;

{ TModuloBase }


class function TModuloBase.GetModuleClass(AIndex: Integer): ClaseBase;
var
  i: Integer;
begin
  i:= VarRegister.IndexOf(IntToStr(AIndex));
  if i = -1 then begin
     Result:= Nil;
     raise Exception.CreateFmt('Modulo no definido para indice %s', [IntToStr(AIndex)]);
  end
  else Result:= ClaseBase(VarRegister.Objects[i]);
end;

function TModuloBase.GetIndex: Integer;
begin
  Result:= -1;
end;

function TModuloBase.GetIndexByClass(AModuleClass: ClaseBase): Integer;
var
 i: Integer;
begin
  i:= VarRegister.IndexOfObject(TObject(AModuleClass));
  if i  <> -1 then Result:= StrToInt(VarRegister.Strings[i])
  else Result:= -1;
end;

class function TModuloBase.RegistrarClase(AModuleClass: ClaseBase;
  Index: Integer): Integer;
var
  j: Integer;
begin
  Result:= VarRegister.IndexOf(IntToStr(Index));
  j:= VarRegister.IndexOfObject(TObject(AModuleClass));
  //No existe ni el indice de modulo ni la clase previamente registrada
  if ( Result = -1) and (Result = j) then
  begin
    //prodecemos a registrar el par
    Result:= VarRegister.AddObject(IntToStr(Index), TObject(AModuleClass));
  end
  else begin
     //devolvemos el error solo si el indice existe y fuera distinto en el par
     if not ((Result <> -1) and (Result = j)) then
        raise Exception.CreateFmt('No se puede registrar la clase %s', [AModuleClass.ClassName]);
  end;
end;

class procedure TModuloBase.EliminarRegistroClase(AModuleClass: ClaseBase);
var
  I: Integer;
begin
  I:= VarRegister.IndexOfObject(TObject(AModuleClass));
  if I >= 0 then VarRegister.Delete(I);
end;

initialization

VarRegister:= TStringList.Create;

finalization

VarRegister.Clear;
VarRegister.Free;

end.
