// Modulo UModuloImpresion
{
  Autor:  Salvador Jover - 9 de Mayo de 2011
  Para el blog de Delphi Bsico (http://www.sjover.com/delphi)

  La aplicacion se sirve de una estructura de tipo cola para gestionar
  determinadas tareas, que son aislados de la aplicacion central.

  Modulo que forman parte de la estructura:
  -UModuloPrincipal (formulario principal)
  -UDMConexion (optativo ya que no se usa en los ejemplos pero podria contener
                las conexiones usadas.)
  -UColaImpresion (Es el gestor de los procesos o tareas)
  -UShellNotify (Monitoriza la notificacion ante la creacin de ficheros
                 en el sistema)
  -UFuncionesAuxiliares (Algunas funciones y procedimientos necesarios)
  -UModuloBase (Ascendente para procesar determinadas tareas como la impresion,
                desde el uso del polimorfismo y la herencia)

  Resto de modulos (UVerWeb, UImpresionInforme, MiPaginaWeb) son parte del
  ejemplo y accesorios, ya que solo existen para que se vea el funcionamiento.

  Se ha usado Delphi XE aunque puede ser adaptada facilmente a versiones
  anteriores en el unico punto conflictivo que he encontrado y corregido,
  y que teneis en la funcion LoadFile, que variara segn la version
  del compilador (si ha introducido Unicode, como Delphi 2010 o Xe).
  He dejado la rutina (comentada) que podria ser usada para Delphi 2007 o anteriores
  junto con la que se ha usado para Delphi XE
  Las funcion LoadFile puede ser encontrada en la red de forma sencilla ya que
  existen multiples formas de hacer la lectura del contenido del fichero. Yo me
  decantado por esta versin que usa la clase TFileStream.
}
//
unit UModuloImpresion;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls,  TLHelp32, PsApi, ActnList, Menus, ImgList,
  Buttons, UColaImpresion, UModuloBase;

type
  TMain = class(TForm)
    VisorImpresion: TListBox;
    popMenuSistema: TPopupMenu;
    TrayIcon1: TTrayIcon;
    ImageList: TImageList;
    Mostrarventana1: TMenuItem;
    meCerrar: TMenuItem;
    btOcultar: TBitBtn;
    chbActivo: TCheckBox;
    N1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormHide(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Mostrarventana1Click(Sender: TObject);
    procedure meCerrarClick(Sender: TObject);
    procedure btOcultarClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure chbActivoClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
    ColaDeImpresion: TColaImpresion;
    procedure AddTask(Sender: TObject; ATrabajo: TTrabajo);
    procedure DeleteTask(Sender: TObject; ATrabajo: TTrabajo);
    procedure DoHacerTask(Sender: TObject; ATrabajo: TTrabajo; AModulo, AFuncion: Integer);
    procedure Sincroniza;

  public
    { Public declarations }
  end;

var
  Main: TMain;

implementation

uses UFuncionesAuxiliares,
     UDMConexion,
     ShellApi;



{$R *.dfm}



// Respuesta al Evento de creacion del formulario
//
// Objetivo: Inicializamos las variables y creamos los objetos que
//           van a ser usados por el formulario.
//
    {
      Tras obtener la ruta en la que vamos a monitorizar la creacin de
      ficheros de una determinada extensin, creamos el objeto ColaDeImpresion
      que se responsabiliza del proceso de cada tarea, de forma simlilar
      a cualquier estructura de tipo Cola.

      Los eventos de la instancia ColaDeImpresion permiten conectar el
      interfaz de usuario (representado por el visor de tipo ListBox) a
      la lista de tareas interna. Cada tarea aadida es tambien aadida en
      el visor. De la misma forma, cada tarea borrada, es borrada en el visor.

      El formulario se ocultar, quedando residente en la barra de tareas,
      permitiendo que el usuario puede visionar los procesos pendientes.

      Durante la creacin, se comprueba que no existe ninguna tarea pendiente,
      explorando la ruta en busqueda de ficheros pendientes de leer (UpdateCola)

      Si existen podriamos procesarlos (VaciarCola)

      Finalmente se registra la monitorizacion del sistema para la creacin
      de ficheros en la ruta deseada.
    }
//
procedure TMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action:= caHide;
end;

procedure TMain.FormCreate(Sender: TObject);
var
  SearchRec: TSearchRec;
  Mensaje: String;
  Filename: String;
begin
  //permitimos una nica instacia de la aplicacion
  if CantidadInstancias > 1 then begin
     Application.Terminate;
     Exit;
  end;

  //Obtenemos la ruta
  ColaDeImpresion:= TColaImpresion.Create(self);
  with ColaDeImpresion  do
  begin
    OnAddTaskEvent:= AddTask;
    OnDeleteTaskEvent:= DeleteTask;
    OnDoHacerEvent:= DoHacerTask;
    Path:= ExtractFilePath(Application.ExeName);
    Active:= True;

    chbActivo.Checked:= Active;

     //ocultamos la aplicacion y queda disponible en la barra del sistema
     Application.ShowMainForm := False;
     ShowWindow( Application.Handle, SW_HIDE );
   end;
end;

// Respuesta al Evento de destruccion del formulario
//
// Objetivo: Liberamos la memoria asociada a los objetos creados.
//
procedure TMain.FormDestroy(Sender: TObject);
begin
//
end;

// Respuesta al Evento de ocultacion del formulario
//
// Objetivo: Queremos que la aplicacion se muestre en la barra del sistema
//
procedure TMain.FormHide(Sender: TObject);
begin
  TrayIcon1.Visible:= True;
end;

// Respuesta al Evento de visualizacin del formulario
//
// Objetivo: Queremos que la aplicacion no se muestre en la barra del sistema
//
procedure TMain.FormShow(Sender: TObject);
begin
  TrayIcon1.Visible:= False;
end;

// Respuesta al Evento OnClick de btOcultar
//
// Objetivo: Ocultar el formulario.
//
procedure TMain.btOcultarClick(Sender: TObject);
begin
  Hide;
end;

procedure TMain.chbActivoClick(Sender: TObject);
begin
  ColaDeImpresion.Active:= TCheckBox(Sender).Checked;
end;


// Respuesta al Evento OnAddTaskEvent de TColaImpresion
//
// Objetivo: Actualizamos el interfaz si se aade un proceso a ColaDeImpresion
//
    {
      El parametro de tipo TTrabajo representa a la tarea que ha sido aadida.
      Hemos guardado el objeto para que se pueda eliminar la tarea en el
      interfaz de forma inequivoca, ya que nada garantiza que en la cola de
      procesos exista el mismo fichero. Por esa razn no nos basamos en el indice
      ni en el nombre del fichero o de la tarea.
      La tarea nos permitiria mostrar en el item el nombre del fichero. Podriamos
      haber optado tambien por el nombre de la tarea (o del informe si lo fuera).
      Hacerlo de esta forma nos da una independencia entre el objeto que procesa
      el trabajo y el interfaz que puede visualizarlo.
    }
//
procedure TMain.AddTask(Sender: TObject; ATrabajo: TTrabajo);
begin
  with VisorImpresion do begin
    AddItem(ATrabajo.FileName, ATrabajo);
    Refresh;
  end;
end;

// Respuesta al Evento OnDeleteTaskEvent de TColaImpresion
//
// Objetivo: Actualizamos el interfaz si se borra un proceso a ColaDeImpresion
//
    {
      Buscamos en la lista de objetos la instancia de la tarea que ha sido
      procesada para que el indice nos permita identificar en el visor cual
      item debe ser borrado
    }
//
procedure TMain.DeleteTask(Sender: TObject; ATrabajo: TTrabajo);
var
  i: Integer;
begin
  with VisorImpresion.Items do begin
    i:= IndexOfObject(ATrabajo);
    if i <> -1 then Delete(i);
  end;
end;

procedure TMain.DoHacerTask(Sender: TObject; ATrabajo: TTrabajo; AModulo, AFuncion: Integer);
type
  fModuloBase = Class of TModuloBase;
begin
    case AModulo of
       //reservamos el modulo 0 para mensajes privados que no requieran impresion
       //como por ejemplo si necesitamos que cierre el programa para poder ser
       //actualizado
       0: begin
             case AFuncion of
                1: Application.Terminate; //Cerramos la aplicacion
             end;
             //matenemos la mista estructura logica que el resto de modulos
             //devolviendo el trozo de cadena que no pudo ser descompuesto
             if ATrabajo.Cadena <> '' then Raise Exception.Create('Error parametros');
          end;

       1,2: begin

             with TModuloBase.GetModuleClass(AModulo).Create(nil)  do
             try
               Procesar(AFuncion, ATrabajo);
               if ATrabajo.Cadena <> '' then Raise Exception.Create(ATrabajo.ErrorMessage);
             finally
                Free;
             end;
          end;
          //podemos tambien de forma flexible procesar lo que queramos
       3: begin
            ShellExecute(0, 'open', PChar(ATrabajo.LeeCampo), nil, nil, SW_SHOWNORMAL);
          end;
       else
         Raise Exception.Create('Identificador modulo impresin no definido');
    end;
end;



// Respuesta al Evento OnClick del item de Menu "Cerrar"
//
// Objetivo: Cierra la aplicacin y finaliza la ejecucin
//
procedure TMain.meCerrarClick(Sender: TObject);
begin
  Application.Terminate;
end;

// Respuesta al Evento OnClick del item de Menu "MostrarVentana1"
//
// Objetivo: Muestra el formulario.
//
procedure TMain.Mostrarventana1Click(Sender: TObject);
begin
  Show;
end;


// Procedimiento Sincroniza
//
// Objetivo: Hubieramos podido optar por un procedimiento como este para
//           mantener el interfaz sincronizado con la cola de impresion.
//           Este procedimiento no es usado en el codigo y se deja solo por
//           motivos didacticos si quisieramos aadir al menu contextual de
//           opciones, una nueva opcin que represente "Actualizar" en el visor.
//
procedure TMain.Sincroniza;
var
  i: Integer;
  fTarea: TTrabajo;
begin
  VisorImpresion.Clear;
  for i := 0 to ColaDeImpresion.Count-1 do begin
    fTarea:= TTrabajo(ColaDeImpresion[i]);
    VisorImpresion.AddItem(FTarea.Filename, FTarea);
  end;
end;


end.
