// Modulo UShellNotify
{
  El componente TShellNotification ha sido adaptado sobre el codigo pblico
  expuesto en Internet en:
           http://www.delphi3000.com/articles/article_2424.asp?SK=
  donde se puede encontrar extendido para noficacion de multiples eventos.
  Dado que a nosotros no estabamos interesados mas que en la captura de la
  notificacion de creacin de ficheros, se ha simplificado el cdigo eliminando
  aquellas partes que no parecan necesarias, incluyendo los procesos de
  registro del componente, que solo va a ser utilzado en el ejemplo en tiempo
  de ejecucin.

  Encontramos en la red, ejemplos similares que nos pueden ayudar en las
  tareas de la notificacion del sistema, en Delphi About.com, donde se expone
  el codigo completo de un componente de caracteristicas similares.
  http://delphi.about.com/library/code/ncaa030403b.htm

  Salvador Jover - 9 de Mayo de 2011
  Para el blog de Delphi Bsico (http://www.sjover.com/delphi)
}
//

unit UShellNotify;
interface

uses Windows, Messages, SysUtils, Classes, Controls, Forms, Dialogs,
     ShlObj;

const
  SNM_SHELLNOTIFICATION = WM_USER +1;
  SHCNF_ACCEPT_INTERRUPTS      = $0001;
  SHCNF_ACCEPT_NON_INTERRUPTS  = $0002;

type
  TShNotificationEvent = procedure(Sender: TObject;
    Path: String)of Object;

  TShellNotification = class(TComponent)
  private
    fPath: String;
    fActive: Boolean;

    prevPath1, prevPath2: String;
    PrevEvent: Integer;

    Handle, NotifyHandle: HWND;

    FOnCreate: TShNotificationEvent;
    function  PathFromPidl(Pidl: PItemIDList): String;

    function GetActive: Boolean;
    procedure SetActive(const Value: Boolean);

    procedure SetPath(const Value: String);
  protected
    procedure ShellNotifyRegister;
    procedure ShellNotifyUnregister;
    procedure WndProc(var Message: TMessage);

    procedure DoCreateFile(Path: String); dynamic;
  public
    constructor Create(AOwner: TComponent; const APath: String);
    destructor  Destroy; override;
  published
    property Path: String read fPath write SetPath;
    property Active: Boolean read GetActive write SetActive;

    property OnFileCreate: TShNotificationEvent read FOnCreate write FOnCreate;

  end;



implementation


{ TShellNotification }

constructor TShellNotification.Create(AOwner: TComponent; const APath: String);
begin
  inherited Create( AOwner );
  if not (csDesigning in ComponentState) then Handle := AllocateHWnd(WndProc);
  PrevEvent := 0;
  if (Trim(APath) <> '') then fPath:= APath;
end;

destructor TShellNotification.Destroy;
begin
  if not (csDesigning in ComponentState) then Active := False;
  if Handle <> 0 then DeallocateHWnd( Handle );
  inherited Destroy;
end;

procedure TShellNotification.DoCreateFile(Path: String);
begin
  if Assigned( fOnCreate ) then FOnCreate(Self, Path)
end;


function TShellNotification.GetActive: Boolean;
begin
  Result := (NotifyHandle <> 0) and (fActive);
end;

{  function SHILCreateFromPath(Path: Pointer; PIDL: PItemIDList;
      var Attributes: ULONG):HResult; stdcall;
}

function TShellNotification.PathFromPidl(Pidl: PItemIDList): String;
begin
  SetLength(Result, Max_Path);
  if not SHGetPathFromIDList(Pidl, PChar(Result)) then Result := '';
  if pos(#0, Result) > 0 then
    SetLength(Result, pos(#0, Result));
end;

procedure TShellNotification.SetActive(const Value: Boolean);
begin
  if (Value <> fActive) then
  begin
    fActive := Value;
    if fActive then ShellNotifyRegister else ShellNotifyUnregister;
  end;
end;

procedure TShellNotification.SetPath(const Value: String);
begin
  if fPath <> Value then
  begin
    fPath := Value;
    ShellNotifyRegister;
  end;
end;


{ Modulo: ShlObj
  function SHChangeNotifyRegister(hwnd: HWND;
                                 fSources: Integer;
                                 fEvents: Integer;
                                 wMsg: UINT;
                                 cEntries: Integer;
                                 var pshcne: TSHChangeNotifyEntry
                                 ): ULONG; stdcall;
  function SHILCreateFromPath(pszPath: LPCWSTR; var ppidl: PItemIDList;
  var rgfInOut: DWORD): HResult; stdcall;
}

procedure TShellNotification.ShellNotifyRegister;
var
  NotifyRecord: TSHChangeNotifyEntry;
  Flags: DWORD;
  Pidl: PItemIDList;
  Attributes: ULONG;
begin
  ShellNotifyUnregister;
  if not (csDesigning in ComponentState) and
     not (csLoading in ComponentState) then
  begin
    SHILCreatefromPath( PChar(fPath), Pidl, Attributes);
    NotifyRecord.pidl := Pidl;
    NotifyRecord.fRecursive := False;

    NotifyHandle := SHChangeNotifyRegister(Handle,
                                           SHCNF_ACCEPT_INTERRUPTS or SHCNF_ACCEPT_NON_INTERRUPTS,
                                           SHCNE_CREATE,
                                           SNM_SHELLNOTIFICATION,
                                           1,
                                           NotifyRecord);
  end;
end;

procedure TShellNotification.ShellNotifyUnregister;
begin
  if NotifyHandle <> 0 then SHChangeNotifyDeregister(NotifyHandle);
end;

procedure TShellNotification.WndProc(var Message: TMessage);
type
   TPIDLLIST = record
      pidlist : array[1..2] of PITEMIDLIST;
   end;
   PIDARRAY = ^TPIDLLIST;
var
   Path1    : string;
   Path2    : string;
   ptr      : PIDARRAY;
   repeated : boolean;
   event    : longint;

begin
  case Message.Msg of
    SNM_SHELLNOTIFICATION:
    begin
      event := Message.LParam and ($7FFFFFFF);
      Ptr   := PIDARRAY(Message.WParam);

      Path1 := PathFromPidl( Ptr^.pidlist[1] );
      Path2 := PathFromPidl( Ptr^.pidList[2] );

      repeated := (PrevEvent = event)
        and (uppercase(prevpath1) = uppercase(Path1))
        and (uppercase(prevpath2) = uppercase(Path2));

      if Repeated then exit;

      PrevEvent := Message.Msg;
      prevPath1 := Path1;
      prevPath2 := Path2;

      case event of
        SHCNE_CREATE           : DoCreateFile(Path1);
      end;//Case

    end;//SNM_SHELLNOTIFICATION
  end; //case
end;


end.
