unit UImpresionInforme;
//Modulo con indice 1
interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UModuloBase, UColaImpresion, RpBase, RpSystem, RpDefine, RpRave;

type
  TImpresionInforme = class(TModuloBase)
    Proyecto: TRvProject;
    Sistema: TRvSystem;
  private
    { Private declarations }
  public
    { Public declarations }
    class Function RegistrarClase(AModuleClass: ClaseBase; Index: Integer): Integer; override;
    class procedure EliminarRegistroClase(AModuleClass: ClaseBase); override;
    function GetIndex: Integer; override;
    procedure Procesar(AFuncion: Integer; ATrabajo: TTrabajo); override;
    {1}procedure ImprimirMiInforme(const ATexto: String);
  end;


implementation

{$R *.dfm}

{ TImpresionInforme }
var
  VarClase: ClaseBase = nil;


class procedure TImpresionInforme.EliminarRegistroClase(
  AModuleClass: ClaseBase);
begin
  inherited EliminarRegistroClase(AModuleClass);
  VarClase:= nil;
end;

function TImpresionInforme.GetIndex: Integer;
begin
  Result:= inherited GetIndexByClass(VarClase);
end;

procedure TImpresionInforme.Procesar(AFuncion: Integer; ATrabajo: TTrabajo);
var
 FTexto: String;
begin
  //Para probar que GetIndex funciona bien puedes desmarcar el comentario
  //y ejecutar la linea. Deberia mostrar el indice del modulo registrado.
  //ShowMessage(IntToStr(GetIndex));
  if not Assigned(ATrabajo) or (ATrabajo.Cadena = '') then
  begin
     ATrabajo.ErrorMessage:= Format('Error en el trabajo %s', [ATrabajo.TaskName]);
     Exit;
  end;

  case AFuncion of
       1: begin
            FTexto:= ATrabajo.LeeCampo;
            ImprimirMiInforme(FTexto);
          end;
  end;
end;

procedure TImpresionInforme.ImprimirMiInforme(const ATexto: String);
begin
   Proyecto.ProjectFile:= ExtractFilePath(Application.ExeName) + 'Informe1.rav';
   Proyecto.Open;
   Proyecto.SetParam('Saludo', ATexto);
   Proyecto.Execute;
   Proyecto.Close;
end;

class function TImpresionInforme.RegistrarClase(AModuleClass: ClaseBase;
  Index: Integer): Integer;
begin
   inherited RegistrarClase(AModuleClass, Index);
   VarClase:= AModuleClass;
end;

initialization

  TImpresionInforme.RegistrarClase(TImpresionInforme, 1);

finalization

  TImpresionInforme.EliminarRegistroClase(TImpresionInforme);


end.
