unit UVerWeb;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UModuloBase, UColaImpresion;

type
  TVerWeb = class(TModuloBase)
  private
    { Private declarations }
  public
    { Public declarations }
    class Function RegistrarClase(AModuleClass: ClaseBase; Index: Integer): Integer; override;
    class procedure EliminarRegistroClase(AModuleClass: ClaseBase); override;
    function GetIndex: Integer; override;
    procedure Procesar(AFuncion: Integer; ATrabajo: TTrabajo); override;
    {1}procedure IrAMiPagina(const ATexto: String);
  end;

implementation

{$R *.dfm}

uses MiPaginaWeb;

{ TModuloBase1 }

var
  VarClase: ClaseBase = nil;

class procedure TVerWeb.EliminarRegistroClase(AModuleClass: ClaseBase);
begin
  inherited EliminarRegistroClase(AModuleClass);
  VarClase:= nil;
end;

function TVerWeb.GetIndex: Integer;
begin
  Result:= inherited GetIndexByClass(VarClase);
end;

procedure TVerWeb.Procesar(AFuncion: Integer; ATrabajo: TTrabajo);
var
 FTexto: String;
begin
  if not Assigned(ATrabajo) or (ATrabajo.Cadena = '') then
  begin
     ATrabajo.ErrorMessage:= Format('Error en el trabajo %s', [ATrabajo.TaskName]);
     Exit;
  end;

  case AFuncion of
       1: begin
            FTexto:= ATrabajo.LeeCampo;
            IrAMiPagina(FTexto);
          end;
  end;
end;


procedure TVerWeb.IrAMiPagina(const ATexto: String);
var
  miweb: TfrmPaginaWeb;
begin
 miweb:= TfrmPaginaWeb.Create(NIL);
 try
   with miweb do begin
     WebBrowser1.Navigate(ATexto);
     lbUrl.Caption:= ATexto;
     ShowModal;
   end;
 finally
   FreeAndNil(miWeb);
 end;
end;

class function TVerWeb.RegistrarClase(AModuleClass: ClaseBase;
  Index: Integer): Integer;
begin
   inherited RegistrarClase(AModuleClass, Index);
   VarClase:= AModuleClass;
end;

initialization

  TVerWeb.RegistrarClase(TVerWeb, 2);

finalization

  TVerWeb.EliminarRegistroClase(TVerWeb);


end.
