unit UMain;

interface

{
  Leme:
     Corrige previamente la direccin de la base de datos que apunta a
     C:\Program Files\Common Files\CodeGear Shared\Data\dbdemos.mdb
     Hay que corregirlo en el evento Create del formulario y si lo deseas
     tambin en la propiedad correspondoente del componente de Conexin.

     Vers que al ejecutar la aplicacin  no se corresponden los valores
     de conteo entre el listbox y el dataset. En ese caso, se ha utilizado
     el tiempo de diseo para mostrarlo.
     Luego, pulsa clear para vaciar el listbos y pulsa el botn Fill para
     volver a rellenar el TlistBox pero esta vez ya en ejecucin ya correctamente
     gracias a la asignacin que ha corregido el valor de BufferCount.
     Para mas detalle os ruego consulteis el articulo en el blog de Delphi
     http://www.sjover.com/delphi/2012/01/26/el-misterio-de-los-200/

     26/01/2012 Salvador Jover
}

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Dialogs, Data.DB, Data.Win.ADODB,
  Datasnap.DBClient, FMX.Layouts, FMX.ListBox, FMX.Bind.Editors, Data.Bind.Components,
  Data.Bind.DBScope, Datasnap.Provider, Data.Bind.EngExt, Fmx.Bind.DBEngExt,
  System.Rtti, System.Bindings.Outputs;

type
  TfrmFillListBox = class(TForm)
    lbxData: TListBox;
    bnFill: TButton;
    bnClear: TButton;
    cdsData: TClientDataSet;
    Conexion: TADOConnection;
    qData: TADOTable;
    dsData: TDataSource;
    dspData: TDataSetProvider;
    cdsDataOrderNo: TFloatField;
    cdsDataCustNo: TFloatField;
    BindScopeDB1: TBindScopeDB;
    lbRecordCount: TLabel;
    lbItemsCount: TLabel;
    BindingsList1: TBindingsList;
    BindListlbxData1: TBindList;
    procedure bnClearClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure bnFillClick(Sender: TObject);
  private
    { Private declarations }
    procedure FillLabelRecordCount;
    procedure FillLabelItemsCount;
  public
    { Public declarations }
  end;

var
  frmFillListBox: TfrmFillListBox;

implementation

{$R *.fmx}

//fuente del procedimiento: http://blogs.embarcadero.com/jimtierney
//         http://blogs.embarcadero.com/jimtierney/2011/10/03/31601
//
//  El procedimiento encapsula los pasos para rellenar distintos
//  tipos de controles, siguiendo lo que haria el usuario en tiempo de
//  diseo. Es util para el tiempo de ejecucin
//
procedure FillList(AControl: TComponent; const AControlExpression: string;
  ASource: TBaseBindScopeComponent; const ASourceExpression: string; ARecordCount: Integer; const ASourceMemberName: string = '');
var
  LBindList: TBindList;
begin
  LBindList := TBindList.Create(nil);
  try
    // Turn off auto properties.
    LBindList.AutoFill := False;
    LBindList.AutoActivate := False;
    LBindList.ControlComponent := AControl;
    LBindList.SourceComponent := ASource;
    LBindList.SourceMemberName := ASourceMemberName;
    LBindList.BufferCount:= ARecordCount;
    with LBindList.FormatExpressions.AddExpression do
    begin
      SourceExpression := ASourceExpression;
      ControlExpression := AControlExpression;
    end;
    LBindList.FillList;
  finally
    LBindList.Free;
  end;
end;

procedure TfrmFillListBox.bnClearClick(Sender: TObject);
begin
  lbxData.Clear;
  FillLabelItemsCount;
  FillLabelRecordCount;
end;

procedure TfrmFillListBox.bnFillClick(Sender: TObject);
begin
  FillList(lbxData, 'Text', BindScopeDB1, 'AsString', dsData.DataSet.RecordCount, 'OrderNo', );
  FillLabelItemsCount;
  FillLabelRecordCount;
end;

procedure TfrmFillListBox.FillLabelItemsCount;
begin
  lbItemsCount.Text:=  'Items.Count: '+IntToStr(lbxData.Items.Count);
end;

procedure TfrmFillListBox.FillLabelRecordCount;
begin
  lbRecordCount.Text:=  'RecordCount: '+IntToStr(cdsData.RecordCount);
end;

procedure TfrmFillListBox.FormCreate(Sender: TObject);
var
  i: Integer;
begin
  Conexion.ConnectionString:= 'Provider=Microsoft.Jet.OLEDB.4.0;'+
                              'Data Source=C:\Program Files\Common Files\CodeGear Shared\Data\dbdemos.mdb;'+
                              'Persist Security Info=False';
  cdsData.Open;
  {Puedes marcar y desmarcar la linea siguiente para comprobar que no depende
  su valor correcto de que se asigne el valor una vez abierto el dataset porque
  buffercount ya ha sido asignado y  ya ha tomado -1
  Esto os permite comprobar que sigue existiendo el problema a no ser que se
  reabra posteriormente el dataset. }
  //BindListlbxData1.BufferCount:= cdsData.RecordCount;
  FillLabelItemsCount;
  FillLabelRecordCount;
end;

end.
