unit UMain;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Dialogs, FMX.Layouts, FMX.TreeView,
  UEstructuras, UInterfaces, FMX.Objects, FMX.Effects;

type
  TTipoProducto = (tpComponente, tpMateriaPrima, tpOperacion);

  TContador = record
    Componente: Integer;
    MateriaPrima: Integer;
    Operacion: Integer;
  end;

  TMain = class(TForm)
    Arbol: TTreeView;
    bnEliminarComponente: TButton;
    bnInsertarComponente: TButton;
    imgInsertarComponente: TImage;
    imgEliminarComponente: TImage;
    bnInsertarMateriaPrima: TButton;
    imgInsertarMateriaPrima: TImage;
    bnEliminarMateriaPrima: TButton;
    imgEliminarMateriaPrima: TImage;
    bnInsertarOperacion: TButton;
    imgInsertarOperacion: TImage;
    bnEliminarOperacion: TButton;
    imgEliminarOperacion: TImage;
    ShadowEffect1: TShadowEffect;
    StatusBar1: TStatusBar;
    lbInfo: TLabel;
    ShadowEffect2: TShadowEffect;
    ShadowEffect3: TShadowEffect;
    ShadowEffect4: TShadowEffect;
    ShadowEffect5: TShadowEffect;
    ShadowEffect6: TShadowEffect;
    procedure FormCreate(Sender: TObject);
    procedure imgInsertarComponenteClick(Sender: TObject);
    procedure imgEliminarComponenteClick(Sender: TObject);
    procedure imgInsertarMateriaPrimaClick(Sender: TObject);
    procedure imgEliminarMateriaPrimaClick(Sender: TObject);
    procedure imgInsertarOperacionClick(Sender: TObject);
    procedure imgEliminarOperacionClick(Sender: TObject);
    procedure ArbolChange(Sender: TObject);
    procedure ArbolDragChange(SourceItem, DestItem: TTreeViewItem;
      var Allow: Boolean);
    procedure imgInsertarComponenteMouseMove(Sender: TObject;
      Shift: TShiftState; X, Y: Single);
    procedure imgEliminarComponenteMouseMove(Sender: TObject;
      Shift: TShiftState; X, Y: Single);
    procedure imgInsertarMateriaPrimaMouseMove(Sender: TObject;
      Shift: TShiftState; X, Y: Single);
    procedure imgEliminarMateriaPrimaMouseMove(Sender: TObject;
      Shift: TShiftState; X, Y: Single);
    procedure imgInsertarOperacionMouseMove(Sender: TObject; Shift: TShiftState;
      X, Y: Single);
    procedure imgEliminarOperacionMouseMove(Sender: TObject; Shift: TShiftState;
      X, Y: Single);
    procedure ArbolMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Single);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Single);
  private
    { Private declarations }
    Contadores: TContador;
    procedure EstadoInicial;
    function NuevoNodo: TTreeViewItem;
    function AsignarID(ATipo: TTipoProducto): Integer;
    function AsignarPrecio(ATipo: TTipoProducto): Double;
    procedure EliminarProducto;
    procedure InsertarProducto(ATipo: TTipoProducto);
    procedure ActualizarEstadoBotones(ATipoSel: TTipoProducto);
  public
    { Public declarations }

  end;

var
  Main: TMain;

implementation

{$R *.fmx}

resourcestring
  infoInsComp    = 'Pulsa para insertar un Componente.';
  infoDelComp    = 'Pulsa para eliminar un Componente.';
  infoInsMatPrim = 'Pulsa para insertar una Materia Prima.';
  infoDelMatPrim = 'Pulsa para eliminar una Materia Prima.';
  infoInsOper    = 'Pulsa para insertar una Operacin.';
  infoDelOper    = 'Pulsa para eliminar una Operacin.';
  infoTreeView   = 'Selecciona el nodo activo para acciones. Acple un nodo Componente sobre otro nodo Componente arrastrando.';


procedure TMain.ActualizarEstadoBotones(ATipoSel: TTipoProducto);
begin
     bnInsertarComponente.Enabled:= True;
     bnEliminarComponente.Enabled:= ATipoSel = tpComponente;

     bnInsertarMateriaPrima.Enabled:= ATipoSel = tpComponente;
     bnEliminarMateriaPrima.Enabled:= ATipoSel = tpMateriaPrima;

     bnInsertarOperacion.Enabled:= ATipoSel = tpComponente;
     bnEliminarOperacion.Enabled:= ATipoSel = tpOperacion;
end;

procedure TMain.ArbolChange(Sender: TObject);
var
  FNodo: TTreeViewItem;
  FProd: TProducto;
begin
  FNodo:= Arbol.Selected;
  if FNodo <> Nil then
  begin
    FProd:= FNodo.TagObject as TProducto;
    if FProd <> Nil then
    begin
      if FProd is TMateriaPrima then ActualizarEstadoBotones(tpMateriaPrima)
      else if FProd is TOperacion then ActualizarEstadoBotones(tpOperacion)
           else ActualizarEstadoBotones(tpComponente);
    end;
  end;
end;

procedure TMain.ArbolDragChange(SourceItem, DestItem: TTreeViewItem;
  var Allow: Boolean);
var
  FComp, FNewComp: TComponente;
  FProd: TProducto;
begin
    Allow:= (SourceItem <> Nil) and
            (DestItem <> Nil) and
            (SourceItem.TagObject <> Nil) and
            (DestItem.TagObject <> Nil) and
            (SourceItem.TagObject is TComponente) and
            (DestItem.TagObject is TComponente) and
            (SourceItem <> DestItem);
    if Allow then
    begin
      TComponente(DestItem.TagObject).Source:= TComponente(SourceItem.TagObject);
    end;
end;

procedure TMain.ArbolMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Single);
begin
  lbInfo.Text:= infoTreeView;
end;

function TMain.AsignarID(ATipo: TTipoProducto): Integer;
begin
  case ATipo of
    tpComponente: begin
                    Inc(Contadores.Componente);
                    Result:= Contadores.Componente;
                    Exit;
                  end;
    tpMateriaPrima: begin
                      Inc(Contadores.MateriaPrima);
                      Result:= Contadores.MateriaPrima;
                      Exit;

                    end;
    tpOperacion: begin
                   Inc(Contadores.Operacion);
                   Result:= Contadores.Operacion;
                   Exit;
                 end;
  end;
  Result:= 0;
end;


function TMain.AsignarPrecio(ATipo: TTipoProducto): Double;
var
  fd: Integer;
begin
  Result:= 0;
  case ATipo of
    tpMateriaPrima: begin
                       Result:= Random(100) + (1 / (Random(100)+1));
                    end;
    tpOperacion:    begin
                       Result:=  (1 / (Random(100)+1));
                    end;
  end;
end;

procedure TMain.EliminarProducto;
var
  FNodo: TTreeViewItem;
  FProd: TProducto;
begin
  FNodo:= Arbol.Selected;
  if (FNodo <> Nil) and (FNodo.TagObject <> nil) then
  begin
     FProd:= FNodo.TagObject as TProducto;
     FProd.Delete;
  end;
end;

procedure TMain.EstadoInicial;
begin
  bnInsertarComponente.Enabled:= True;
  bnEliminarComponente.Enabled:= False;

  bnInsertarMateriaPrima.Enabled:= False;
  bnEliminarMateriaPrima.Enabled:= False;

  bnInsertarOperacion.Enabled:= False;;
  bnEliminarOperacion.Enabled:= False;

  lbInfo.Text:= '';
end;

procedure TMain.FormCreate(Sender: TObject);
begin
  Contadores.Componente:= 0;
  Contadores.MateriaPrima:= 100;
  Contadores.Operacion:= 1000;
  Randomize;
  EstadoInicial;
end;

procedure TMain.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Single);
begin
  lbInfo.Text:= '';
end;

procedure TMain.imgEliminarComponenteClick(Sender: TObject);
begin
  EliminarProducto;
  if Arbol.Count = 0 then EstadoInicial;
end;

procedure TMain.imgEliminarComponenteMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Single);
begin
  lbInfo.Text:= infoDelComp;
end;

procedure TMain.imgEliminarMateriaPrimaClick(Sender: TObject);
begin
  EliminarProducto;
end;

procedure TMain.imgEliminarMateriaPrimaMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Single);
begin
  lbInfo.Text:= infoDelMatPrim;
end;

procedure TMain.imgEliminarOperacionClick(Sender: TObject);
begin
  EliminarProducto;
end;

procedure TMain.imgEliminarOperacionMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Single);
begin
  lbInfo.Text:= infoDelOper;
end;

procedure TMain.imgInsertarComponenteClick(Sender: TObject);
begin
  with TComponente.Create(NuevoNodo) do
  begin
    ID:= AsignarID(tpComponente);
    Nombre:= Format('Componente %d', [ID]);
    Cantidad:= 1;
  end;
end;

procedure TMain.imgInsertarComponenteMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Single);
begin
  lbInfo.Text:= infoInsComp;
end;

procedure TMain.imgInsertarMateriaPrimaClick(Sender: TObject);
begin
   InsertarProducto(tpMateriaPrima);
end;

procedure TMain.imgInsertarMateriaPrimaMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Single);
begin
  lbInfo.Text:= infoInsMatPrim;
end;

procedure TMain.imgInsertarOperacionClick(Sender: TObject);
begin
   InsertarProducto(tpOperacion);
end;

procedure TMain.imgInsertarOperacionMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Single);
begin
  lbInfo.Text:= infoInsOper;
end;

procedure TMain.InsertarProducto(ATipo: TTipoProducto);
var
  FNodo: TTreeViewItem;
  FComp, FNewComp: TComponente;
  FProd: TProducto;
begin
  FNodo:= Arbol.Selected;
  if (FNodo <> Nil) and (FNodo.TagObject <> nil) then
  begin
     if FNodo.TagObject is TComponente then
       FComp:= FNodo.TagObject as TComponente
     else raise Exception.Create('Es necesario seleccionar un componente');

     case ATipo of
       tpComponente:    begin
                          FNewComp:= TComponente.Create(FNodo);
                          with FNewComp do
                          begin
                            ID:= AsignarID(ATipo);
                            Nombre:= Format('Componente %d', [ID]);
                            Cantidad:= 1;
                          end;
                          FNewComp.Source:= FComp;
                          Exit;
                        end;
       tpMateriaPrima:  FProd:= FComp.Items[FComp.AddChildren(TMateriaPrima)];
       tpOperacion:     FProd:= FComp.Items[FComp.AddChildren(TOperacion)];
     end;


      with FProd do
      begin
        ID:= AsignarID(ATipo);
        Nombre:= Format('Operacion %d', [ID]);;
        Cantidad:= 1;
        Precio:= AsignarPrecio(ATipo);
      end;

      FNodo.IsExpanded:= True;
  end;
end;

function TMain.NuevoNodo: TTreeViewItem;
begin
  Result:= TTreeViewItem.Create(Arbol);
  Result.Font.Size:= 14;
  Result.Parent:= Arbol;
end;

end.
