unit UTest;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Dialogs, FMX.Layouts, FMX.TreeView,
  USJTreeView, FMX.Objects;

type
  TMateriaPrima = class(TFMXObject)
  end;
  TComponente = class(TFMXObject)
  end;
  TOperacion = class(TFMXObject)
  end;

  TMain = class(TForm)
    Arbol: TSJTreeView;
    bnPulsar: TButton;
    StyleBook1: TStyleBook;
    bnMatPrim: TButton;
    bnOper: TButton;
    bnComp: TButton;
    procedure bnPulsarClick(Sender: TObject);
    procedure ArbolSelectEvent(Sender: TObject; ABase: TClass);
    procedure bnCompClick(Sender: TObject);
    procedure bnMatPrimClick(Sender: TObject);
    procedure bnOperClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Main: TMain;

implementation

{$R *.fmx}

procedure TMain.bnCompClick(Sender: TObject);
var
  nodo: TSJTreeViewItem;
  fComp: TComponente;
begin
  nodo:= TSJTreeViewItem.Create(Arbol);
  nodo.StyleLookup:= 'SJTreeViewItemStyle';
  fComp:= TComponente.Create(nodo);
  nodo.TagObject:= fComp;

  if Arbol.Selected = nil then
  nodo.Parent:= Arbol
  else
  nodo.Parent:= Arbol.Selected;
  nodo.Text:= 'Creado Componente';

  nodo.ApplyStyleLookUp;
end;

procedure TMain.bnMatPrimClick(Sender: TObject);
var
  nodo: TSJTreeViewItem;
  fMatPrim: TMateriaPrima;
begin
  nodo:= TSJTreeViewItem.Create(Arbol);
  nodo.StyleLookup:= 'SJTreeViewItemStyle';
  fMatPrim:= TMateriaPrima.Create(nodo);
  nodo.TagObject:= fMatPrim;


  if Arbol.Selected = nil then
  nodo.Parent:= Arbol
  else
  nodo.Parent:= Arbol.Selected;
  nodo.Text:= 'Creada Materia Prima';
end;

procedure TMain.bnOperClick(Sender: TObject);
var
  nodo: TSJTreeViewItem;
  fOper: TOperacion;
begin
  nodo:= TSJTreeViewItem.Create(Arbol);
  nodo.StyleLookup:= 'SJTreeViewItemStyle';
  fOper:= TOperacion.Create(nodo);
  nodo.TagObject:= fOper;


  if Arbol.Selected = nil then
  nodo.Parent:= Arbol
  else
  nodo.Parent:= Arbol.Selected;
  nodo.Text:= 'Creada Operacion';
end;

procedure TMain.bnPulsarClick(Sender: TObject);
var
  nodo: TSJTreeViewItem;
begin
  nodo:= TSJTreeViewItem.Create(Arbol);
  nodo.StyleLookup:= 'SJTreeViewItemStyle';


  if Arbol.Selected = nil then
  nodo.Parent:= Arbol
  else
  nodo.Parent:= Arbol.Selected;
  nodo.Text:= 'Prueba...';
end;

procedure TMain.ArbolSelectEvent(Sender: TObject; ABase: TClass);
var
  fNodo: TSJTreeViewItem;
  img: TFMXObject;
begin
  fNodo:= TSJTreeViewItem(Arbol.Selected);
  img:= fNodo.FindStyleResource('Image');

  if img <> nil then
  begin
    if (img is TImage) then
    begin
     if (fNodo.TagObject is TComponente) then
       (img as TImage).Bitmap.LoadFromFile('NodoComponente24x24gif.gif')
     else if (fNodo.TagObject is TMateriaPrima) then
            (img as TImage).Bitmap.LoadFromFile('NodoMateriaPrima24x24gif.gif')
          else if (fNodo.TagObject is TOperacion) then
                 (img as TImage).Bitmap.LoadFromFile('NodoOperacion24x24gif.gif');
    end;
  end;
end;

end.
