unit UMainClient;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Rtti, System.Classes,
  System.Variants, FMX.Types, FMX.Controls, FMX.Forms, FMX.Dialogs,
  Data.DBXDataSnap, IPPeerClient, Data.DBXCommon, Data.FMTBcd, Data.DB,
  Data.SqlExpr, FMX.Objects, Data.Bind.EngExt, Fmx.Bind.DBEngExt,
  System.Bindings.Outputs, Fmx.Bind.Editors, Data.Bind.Components,
  Data.Bind.DBScope, Datasnap.DBClient, Datasnap.DSConnect, FMX.Layouts,
  Fmx.Bind.Navigator, UProxy, FMX.ListBox;

type
  TForm1 = class(TForm)
    Image1: TImage;
    DataSnapCONNECTION: TSQLConnection;
    Banners: TClientDataSet;
    DSProviderConnection1: TDSProviderConnection;
    BannersBanner: TBlobField;
    BindSourceDB1: TBindSourceDB;
    BindingsList1: TBindingsList;
    LinkPropertyToField1: TLinkPropertyToField;
    BindNavigator1: TBindNavigator;
    btnDataset: TButton;
    btnMethodJSON: TButton;
    Image2: TImage;
    Label1: TLabel;
    BannersIDBanner: TIntegerField;
    LinkPropertyToField2: TLinkPropertyToField;
    cbxSelector: TComboBox;
    Interbase: TListBoxItem;
    btnMethodStream: TButton;
    Panel1: TPanel;
    labBaseDeDatos: TLabel;
    procedure btnDatasetClick(Sender: TObject);
    procedure btnMethodJSONClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure cbxSelectorChange(Sender: TObject);
    procedure btnMethodStreamClick(Sender: TObject);
  private
    { Private declarations }
    FInstanceOwner : Boolean;
    FServerMethods1Client: TServerMethods1Client;
    function GetServerMethods1Client: TServerMethods1Client;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.fmx}

uses Data.DBXJSONCommon;

procedure TForm1.btnDatasetClick(Sender: TObject);
begin
  Banners.Open;
end;

procedure TForm1.btnMethodJSONClick(Sender: TObject);
var
   fStream: TMemoryStream;
   i: Integer;
begin
  if Banners.IsEmpty then
     raise Exception.Create('Debes abrir primero el dataset');
  try
    i:= BannersIDBanner.AsInteger;
    fStream:= TMemoryStream.Create();
    case cbxSelector.ItemIndex of
      0: begin
           fStream.LoadFromStream(TDBXJSONTools.JSONToStream(GetServerMethods1Client.GetImagenBannerAsJSON(i)));
           //fStream.SaveToFile('..\..\..\test_interbase_jason_fmx.jpg');
         end;
    end;
    Image2.Bitmap.LoadFromStream(fStream);
  finally
    fStream.Free;
  end;
end;

procedure TForm1.btnMethodStreamClick(Sender: TObject);
var
   fStream: TMemoryStream;
   i: Integer;
begin
  if Banners.IsEmpty then
     raise Exception.Create('Debes abrir primero el dataset');
  try
    i:= BannersIDBanner.AsInteger;
    fStream:= TMemoryStream.Create();
    case cbxSelector.ItemIndex of
      0: begin
           fStream.LoadFromStream(GetServerMethods1Client.GetImagenBannerAsStream(i));
           //fStream.SaveToFile('..\..\..\test_interbase_stream_fmx.jpg');
         end;
    end;
    Image2.Bitmap.LoadFromStream(fStream);
  finally
    fStream.Free;
  end;
end;

procedure TForm1.cbxSelectorChange(Sender: TObject);
begin
    Banners.Close;
    case cbxSelector.ItemIndex of
      0: Banners.ProviderName:= 'dspImagenes_Interbase';
    end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  FInstanceOwner := True;
end;
procedure TForm1.FormDestroy(Sender: TObject);
begin
  FServerMethods1Client.Free;
end;

function TForm1.GetServerMethods1Client: TServerMethods1Client;
begin
  if FServerMethods1Client = nil then
    FServerMethods1Client:= TServerMethods1Client.Create(DataSnapCONNECTION.DBXConnection, FInstanceOwner);
  Result := FServerMethods1Client;
end;


end.
