unit UMainServer;

interface

uses Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants,
  System.Classes, Vcl.Graphics, Vcl.Controls, Vcl.Forms, Vcl.Dialogs,
  Vcl.StdCtrls, Vcl.ExtCtrls, Vcl.DBCtrls;

type
  TMainServer = class(TForm)
    OpenDialog1: TOpenDialog;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    fPath: String;
  public
    { Public declarations }
    function GetPath: String;
  end;

var
  MainServer: TMainServer;

implementation

uses IniFiles;

{$R *.dfm}

procedure TMainServer.FormCreate(Sender: TObject);
begin
  with TINIFile.Create(ExtractFilePath(ParamStr(0))+'bbdd.ini') do
  begin
    try
      fPath:= ReadString('Database','PATH_BBDD','');
      if (Trim(fPath) = '') then
      begin
        if OpenDialog1.Execute then
           fPath:= Opendialog1.FileName
        else raise Exception.Create('Es necesario fijar la conexin a bbdd');
        WriteString('Database','PATH_BBDD',fPath);
      end;
    finally
      Free;
    end;
  end;
end;

function TMainServer.GetPath: String;
begin
   Result:= fPath;
end;

end.

