//
// Created by the DataSnap proxy generator.
// 21/03/2013 8:56:30
//

unit UProxy;

interface

uses Data.DBXCommon, Data.DBXClient, Data.DBXDataSnap, Data.DBXJSON, Datasnap.DSProxy, System.Classes, System.SysUtils, Data.DB, Data.SqlExpr, Data.DBXDBReaders, Data.DBXCDSReaders, Data.DBXJSONReflect, Datasnap.DSClientRest;

type
  TServerMethods1Client = class(TDSAdminClient)
  private
    Fdemos_interbaseBeforeConnectCommand: TDBXCommand;
    FEchoStringCommand: TDBXCommand;
    FReverseStringCommand: TDBXCommand;
    FGetImagenBannerAsJSONCommand: TDBXCommand;
    FGetImagenBannerAsStreamCommand: TDBXCommand;
  public
    constructor Create(ADBXConnection: TDBXConnection); overload;
    constructor Create(ADBXConnection: TDBXConnection; AInstanceOwner: Boolean); overload;
    destructor Destroy; override;
    procedure demos_interbaseBeforeConnect(Sender: TObject);
    function EchoString(Value: string): string;
    function ReverseString(Value: string): string;
    function GetImagenBannerAsJSON(AIDBanner: Integer): TJSONArray;
    function GetImagenBannerAsStream(AIDBanner: Integer): TStream;
  end;



implementation

uses FMX.Dialogs;


procedure TServerMethods1Client.demos_interbaseBeforeConnect(Sender: TObject);
begin
  if Fdemos_interbaseBeforeConnectCommand = nil then
  begin
    Fdemos_interbaseBeforeConnectCommand := FDBXConnection.CreateCommand;
    Fdemos_interbaseBeforeConnectCommand.CommandType := TDBXCommandTypes.DSServerMethod;
    Fdemos_interbaseBeforeConnectCommand.Text := 'TServerMethods1.demos_interbaseBeforeConnect';
    Fdemos_interbaseBeforeConnectCommand.Prepare;
  end;
  if not Assigned(Sender) then
    Fdemos_interbaseBeforeConnectCommand.Parameters[0].Value.SetNull
  else
  begin
    FMarshal := TDBXClientCommand(Fdemos_interbaseBeforeConnectCommand.Parameters[0].ConnectionHandler).GetJSONMarshaler;
    try
      Fdemos_interbaseBeforeConnectCommand.Parameters[0].Value.SetJSONValue(FMarshal.Marshal(Sender), True);
      if FInstanceOwner then
        Sender.Free
    finally
      FreeAndNil(FMarshal)
    end
    end;
  Fdemos_interbaseBeforeConnectCommand.ExecuteUpdate;
end;

function TServerMethods1Client.EchoString(Value: string): string;
begin
  if FEchoStringCommand = nil then
  begin
    FEchoStringCommand := FDBXConnection.CreateCommand;
    FEchoStringCommand.CommandType := TDBXCommandTypes.DSServerMethod;
    FEchoStringCommand.Text := 'TServerMethods1.EchoString';
    FEchoStringCommand.Prepare;
  end;
  FEchoStringCommand.Parameters[0].Value.SetWideString(Value);
  FEchoStringCommand.ExecuteUpdate;
  Result := FEchoStringCommand.Parameters[1].Value.GetWideString;
end;

function TServerMethods1Client.ReverseString(Value: string): string;
begin
  if FReverseStringCommand = nil then
  begin
    FReverseStringCommand := FDBXConnection.CreateCommand;
    FReverseStringCommand.CommandType := TDBXCommandTypes.DSServerMethod;
    FReverseStringCommand.Text := 'TServerMethods1.ReverseString';
    FReverseStringCommand.Prepare;
  end;
  FReverseStringCommand.Parameters[0].Value.SetWideString(Value);
  FReverseStringCommand.ExecuteUpdate;
  Result := FReverseStringCommand.Parameters[1].Value.GetWideString;
end;

function TServerMethods1Client.GetImagenBannerAsJSON(AIDBanner: Integer): TJSONArray;
begin
  if FGetImagenBannerAsJSONCommand = nil then
  begin
    FGetImagenBannerAsJSONCommand := FDBXConnection.CreateCommand;
    FGetImagenBannerAsJSONCommand.CommandType := TDBXCommandTypes.DSServerMethod;
    FGetImagenBannerAsJSONCommand.Text := 'TServerMethods1.GetImagenBannerAsJSON';
    FGetImagenBannerAsJSONCommand.Prepare;
  end;
  FGetImagenBannerAsJSONCommand.Parameters[0].Value.SetInt32(AIDBanner);
  FGetImagenBannerAsJSONCommand.ExecuteUpdate;
  Result := TJSONArray(FGetImagenBannerAsJSONCommand.Parameters[1].Value.GetJSONValue(FInstanceOwner));
end;

function TServerMethods1Client.GetImagenBannerAsStream(AIDBanner: Integer): TStream;
begin
  if FGetImagenBannerAsStreamCommand = nil then
  begin
    FGetImagenBannerAsStreamCommand := FDBXConnection.CreateCommand;
    FGetImagenBannerAsStreamCommand.CommandType := TDBXCommandTypes.DSServerMethod;
    FGetImagenBannerAsStreamCommand.Text := 'TServerMethods1.GetImagenBannerAsStream';
    FGetImagenBannerAsStreamCommand.Prepare;
  end;
  FGetImagenBannerAsStreamCommand.Parameters[0].Value.SetInt32(AIDBanner);
  FGetImagenBannerAsStreamCommand.ExecuteUpdate;
  Result := FGetImagenBannerAsStreamCommand.Parameters[1].Value.GetStream(FInstanceOwner);
end;


constructor TServerMethods1Client.Create(ADBXConnection: TDBXConnection);
begin
  inherited Create(ADBXConnection);
end;


constructor TServerMethods1Client.Create(ADBXConnection: TDBXConnection; AInstanceOwner: Boolean);
begin
  inherited Create(ADBXConnection, AInstanceOwner);
end;


destructor TServerMethods1Client.Destroy;
begin
  FreeAndNil(Fdemos_interbaseBeforeConnectCommand);
  FreeAndNil(FEchoStringCommand);
  FreeAndNil(FReverseStringCommand);
  FreeAndNil(FGetImagenBannerAsJSONCommand);
  FreeAndNil(FGetImagenBannerAsStreamCommand);
  inherited;
end;

end.

