unit UMain;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Rtti, System.Classes,
  System.Variants, FMX.Types, FMX.Controls, FMX.Forms, FMX.Dialogs,
  Data.DBXMSSQL, Data.Bind.EngExt, Fmx.Bind.DBEngExt, System.Bindings.Outputs,
  Fmx.Bind.Editors, Data.Bind.Components, Data.Bind.DBScope, Data.DB,
  FMX.Layouts, Fmx.Bind.Navigator, Datasnap.DBClient, SimpleDS, FMX.Objects,
  Data.SqlExpr, System.Actions, FMX.ActnList, Data.FMTBcd, Data.DBXInterBase,
  FMX.ListBox;

type
  TfrmBanners = class(TForm)
    Image1: TImage;
    banners: TSimpleDataSet;
    bannersIDBanner: TIntegerField;
    Label1: TLabel;
    BindSourceDB1: TBindSourceDB;
    BindingsList1: TBindingsList;
    LinkPropertyToField1: TLinkPropertyToField;
    OpenDialog1: TOpenDialog;
    acciones: TActionList;
    Button1: TButton;
    acInsertarImagen: TAction;
    BindNavigator1: TBindNavigator;
    acEliminarImagen: TAction;
    Button2: TButton;
    LinkPropertyToField2: TLinkPropertyToField;
    bannersBanner: TBlobField;
    cbxSelector: TComboBox;
    ListBoxItem1: TListBoxItem;
    ListBoxItem2: TListBoxItem;
    Label2: TLabel;
    demos_Interbase: TSQLConnection;
    spInsertarImagen_Interbase: TSQLStoredProc;
    spEliminarImagen_Interbase: TSQLStoredProc;
    procedure FormCreate(Sender: TObject);
    procedure acInsertarImagenExecute(Sender: TObject);
    procedure acEliminarImagenExecute(Sender: TObject);
    procedure acEliminarImagenUpdate(Sender: TObject);
    procedure cbxSelectorChange(Sender: TObject);
  private
    { Private declarations }
    function InsertarImagen(AImage: TImage): Integer;
    procedure EliminarImagen(AIDBanner: Integer);
  public
    { Public declarations }
  end;

var
  frmBanners: TfrmBanners;

implementation

{$R *.fmx}

uses IniFiles;

procedure TfrmBanners.FormCreate(Sender: TObject);
var
  sPath: String;
begin
  with TINIFile.Create(ExtractFilePath(ParamStr(0))+'bbdd.ini') do
  begin
    try
      sPath:= ReadString('Database','PATH_BBDD','');
      if (Trim(sPath) = '') then
      begin
        if OpenDialog1.Execute then
           sPath:= Opendialog1.FileName
        else raise Exception.Create('Es necesario fijar la conexin a bbdd');
        WriteString('Database','PATH_BBDD', sPath);
      end;
      demos_interbase.Params.Values['Database'] := sPath;
    finally
      Free;
    end;
  end;
  banners.Open;
end;

function TfrmBanners.InsertarImagen(AImage: TImage): Integer;
var
  FStream: TMemoryStream;
begin
  Result:= -1;
  FStream:= TMemoryStream.Create;
  try
     AImage.Bitmap.SaveToStream(FStream);
     case cbxSelector.ItemIndex of
     0: begin
           spInsertarImagen_Interbase.Params.ParamByName('Banner').LoadFromStream(FStream, ftGraphic);
           spInsertarImagen_Interbase.ExecProc;
           Result:= spInsertarImagen_Interbase.Params.ParamByName('IDBanner').AsInteger;
        end;
     1: begin
           //
        end;
     end;
  finally
    FreeAndNil(FStream);
  end;
end;

procedure TfrmBanners.acEliminarImagenExecute(Sender: TObject);
begin
  if Messagedlg('Deseas eliminar la imagen?', System.UITypes.TMsgDlgType.mtWarning ,
                FMX.Dialogs.mbYesNo, 0) = mrYes  then
  begin
    EliminarImagen(banners.FieldByName('IDBanner').AsInteger);
    Banners.Refresh;
  end;
end;

procedure TfrmBanners.acEliminarImagenUpdate(Sender: TObject);
begin
  acEliminarImagen.Enabled:= not banners.IsEmpty;
end;

procedure TfrmBanners.acInsertarImagenExecute(Sender: TObject);
var i: Integer;
begin
  if OpenDialog1.Execute then
  begin
     Image1.Bitmap.LoadFromFile(OpenDialog1.FileName);
     i:= InsertarImagen(Image1);
     Banners.Refresh;
     if i>0 then banners.Locate('IDBanner', i, []);
  end;
end;

procedure TfrmBanners.cbxSelectorChange(Sender: TObject);
begin
  banners.Close;
  demos_interbase.Connected:= False;
  case cbxSelector.ItemIndex of
     0: begin
          banners.Connection:= demos_interbase;
        end;
     1: begin
          raise Exception.Create('Prueba con otras bases de datos aqu.');
        end;
  end;
  banners.Open;
end;

procedure TfrmBanners.EliminarImagen(AIDBanner: Integer);
begin
  case cbxSelector.ItemIndex of
     0: begin
         spEliminarImagen_Interbase.Params.ParamByName('IDBanner').Value:= AIDBanner;
         spEliminarImagen_Interbase.ExecProc;
        end;
     1: begin
         //
        end;
  end;
end;

end.
