program CalculadoraCON;

{$APPTYPE CONSOLE}
{$R *.res}

uses
  System.SysUtils, Windows;

var
  Operando1, Operando2: Double;
  Operador: Char;


function ClearConsoleScreen: boolean;
var
  hStdOut: HWND;
  ScreenBufInfo: TConsoleScreenBufferInfo;
  Coord: TCoord;
  i: Integer;
begin
  hStdOut := GetStdHandle(STD_OUTPUT_HANDLE);
  GetConsoleScreenBufferInfo(hStdOut, ScreenBufInfo);
  for i := 1 to ScreenBufInfo.dwSize.Y do WriteLn('');
  Coord.X := 0;
  Coord.Y := 0;
  SetConsoleCursorPosition(hStdOut, Coord);
end;

function DoCalcularResultado(AOperador: Char; AOperando1, AOperando2: Double): Double;
begin
  case AOperador of
    '+': Result := AOperando1 + AOperando2;
    '-': Result := AOperando1 - AOperando2;
    '*': Result := AOperando1 * AOperando2;
    '/': Result := AOperando1 / AOperando2;
  else
    Result := 0;
  end;
end;

procedure Cabecera;
begin
  WriteLn('MI PRIMERA CALCULADORA:');
  WriteLn('-------------------------');
end;

procedure Menu;
begin
  Cabecera;
  WriteLn('Escoja qu desea hacer?:');
  WriteLn('(+)para sumar');
  WriteLn('(-)para restar:');
  WriteLn('(*)para multiplicar:');
  WriteLn('(/)para dividir:');
  WriteLn('(S)para salir:');
  WriteLn('-------------------------');
  Readln(Operador);
  ClearConsoleScreen;
end;

procedure PrimerOperando;
begin
  Cabecera;
  WriteLn('Escribe el primer operando...');
  WriteLn;
  WriteLn;
  Readln(Operando1);
  ClearConsoleScreen;
end;

procedure SegundoOperando;
begin
  Cabecera;
  WriteLn('Escribe el segundo operando...');
  WriteLn;
  WriteLn;
  Readln(Operando2);
  ClearConsoleScreen;
end;

procedure CalcularResultado;
begin
  Cabecera;
  WriteLn('El resultado es ' + FloatToStr(DoCalcularResultado(Operador, Operando1, Operando2)));
  WriteLn;
  WriteLn;
  WriteLn('Pulsa cualquier tecla para volver...');
  Readln;
  ClearConsoleScreen;
end;

function IntentarSalida(AEntrada: Char): Boolean;
begin
  Result := (Operador = 'S') or ((Operador <> '+') and (Operador <> '-') and
    (Operador <> '*') and (Operador <> '/'));
end;

begin
  try
    { TODO -oUser -cConsole Main : Insert code here }
    repeat

      Menu;
      if IntentarSalida(Operador) then
        Continue;
      PrimerOperando;
      SegundoOperando;
      CalcularResultado;

    until Uppercase(Operador) = 'S';

  except
    on E: Exception do
      WriteLn(E.ClassName, ': ', E.Message);
  end;

end.
