unit UCBClasses;

interface

uses System.SysUtils, System.Variants, System.Classes;


type
  TDigitoOperador = class;
  TDigitoClass = class of TDigitoOperador;

  TEtiqueta = record
    Lexema : String;
    Clase: TDigitoClass;
    Representacion: String;
    EsOperadorInmediato: Boolean;
    function Init: TEtiqueta;
    function Assign(ASource: TEtiqueta): TEtiqueta;
   end;

  TDigitoOperador = class(TInterfacedObject)
  private
    FEtiqueta: TEtiqueta;
    FCalculadora: TComponent;
    function GetClass: TDigitoClass;
    function GetEtiqueta: TEtiqueta;
  protected
  public
    constructor Create(AEtiqueta: TEtiqueta; ACalculadora: TComponent); virtual;
    destructor Destroy; override;
    function DoOperar(AOperador1, AOperador2: Extended): Double; virtual;
    function EsOperadorInmediato: Boolean;
    function ToString: String; override;
    procedure Init;
    function GetRepresentacion: String;
    function ExecuteAction(ACalculadora: TComponent; AOperando1, AOperando2: Double): Double;
    property ClassOfDigito: TDigitoClass read GetClass;
    property Etiqueta: TEtiqueta read GetEtiqueta;
  end;

  TDigitoOperadorSuma = class(TDigitoOperador)
  protected
  public
    function DoOperar(AOperador1, AOperador2: Extended): Double; override;
  end;

  TDigitoOperadorResta = class(TDigitoOperador)
  protected
  public
    function DoOperar(AOperador1, AOperador2: Extended): Double; override;
  end;

  TDigitoOperadorMulti = class(TDigitoOperador)
  protected
  public
    function DoOperar(AOperador1, AOperador2: Extended): Double; override;
  end;

  TDigitoOperadorDivision = class(TDigitoOperador)
  protected
  public
    function DoOperar(AOperador1, AOperador2: Extended): Double; override;
  end;


const
  CatalogoSimbolosBasicos: Array[0..3] of TEtiqueta = (
       (Lexema:'x'   ; Clase: TDigitoOperadorMulti;    Representacion: '*'; EsOperadorInmediato: False),           // digito multiplicacion
       (Lexema:'+'   ; Clase: TDigitoOperadorSuma;     Representacion: '+'; EsOperadorInmediato: False),           // digito suma
       (Lexema:'-'   ; Clase: TDigitoOperadorResta;    Representacion: '-'; EsOperadorInmediato: False ),          // digito resta
       (Lexema:'/'   ; Clase: TDigitoOperadorDivision; Representacion: #$2797; EsOperadorInmediato: False));       // digito divide


implementation

{ TDigitoOperador }

uses UCalculadora;

constructor TDigitoOperador.Create(AEtiqueta: TEtiqueta;
  ACalculadora: TComponent);
begin
  Assert(Assigned(ACalculadora),'Error Instancia Clase TClassCalculadora no definida');

  FCalculadora:= ACalculadora;
  FEtiqueta.Assign(AEtiqueta);
end;

destructor TDigitoOperador.Destroy;
begin
  FCalculadora:= Nil;
  inherited Destroy;
end;

function TDigitoOperador.DoOperar(AOperador1, AOperador2: Extended): Double;
begin
end;

function TDigitoOperador.EsOperadorInmediato: Boolean;
begin
  Result:= FEtiqueta.EsOperadorInmediato;
end;

function TDigitoOperador.ExecuteAction(ACalculadora: TComponent;
  AOperando1, AOperando2: Double): Double;
begin
  Result:= DoOperar(AOperando1, AOperando2);
end;

function TDigitoOperador.GetClass: TDigitoClass;
begin
  Result:= FEtiqueta.Clase;
end;

function TDigitoOperador.GetEtiqueta: TEtiqueta;
begin
  Result:= FEtiqueta;
end;

function TDigitoOperador.GetRepresentacion: String;
begin
  Result:= FEtiqueta.Representacion;
end;

procedure TDigitoOperador.Init;
begin
  FEtiqueta.Init;
end;

function TDigitoOperador.ToString: String;
begin
  Result:= GetRepresentacion;
end;

{ TDigitoOperadorSuma }

function TDigitoOperadorSuma.DoOperar(AOperador1, AOperador2: Extended): Double;
begin
  Result:= AOperador1 + AOperador2;
end;

{ TDigitoOperadorResta }

function TDigitoOperadorResta.DoOperar(AOperador1,
  AOperador2: Extended): Double;
begin
  Result:= AOperador1 - AOperador2;
end;

{ TDigitoOperadorMulti }

function TDigitoOperadorMulti.DoOperar(AOperador1,
  AOperador2: Extended): Double;
begin
  Result:= AOperador1 * AOperador2;
end;

{ TDigitoOperadorDivision }

function TDigitoOperadorDivision.DoOperar(AOperador1,
  AOperador2: Extended): Double;
begin
  Result:= AOperador1 / AOperador2;
end;

{ TEtiqueta }

function TEtiqueta.Assign(ASource: TEtiqueta): TEtiqueta;
begin
  with Self do
  begin
    Lexema             := ASource.Lexema;
    Clase              := ASource.Clase;
    Representacion     := ASource.Representacion;
    EsOperadorInmediato:= ASource.EsOperadorInmediato;
  end;
  Result:= Self;
end;

function TEtiqueta.Init: TEtiqueta;
begin
  with Self do
  begin
    Lexema             := '';
    Clase              := Nil;
    Representacion     := '';
    EsOperadorInmediato:= False;
  end;
  Result:= Self;
end;

end.
