unit UCalculadora;

interface

uses System.SysUtils, System.Variants, System.Classes;

const
  MaxDigitos = 12;
type
  TCalculadoraBasica = class(TComponent)
  private
    FDisplay: String;
    FlagNumero: Boolean;
    Operando: Double;
    Operador: Char;
    procedure DesplazarDigitoALaIzquierda(AOperando: Char);
    procedure IntroduceDigito(AOperando: Char);
  protected
    procedure DoReset; virtual;
    procedure ActualizaDisplay(const AOperando: String); virtual;
  public
    constructor Create(AOwner: TComponent); override;
    function ExisteError: Boolean;
    function LeeDisplay: String;
    function ProcesarDigito(const ALexema: Char): String;
    function ProcesarOperacion(const ALexema: Char): String;
    function Reset: String;
  end;

implementation

{ TCalculadoraBasica }

procedure TCalculadoraBasica.ActualizaDisplay(const AOperando: String);
begin
  FDisplay:= AOperando;
end;

constructor TCalculadoraBasica.Create(AOwner: TComponent);
begin
  inherited;
  Operando:= 0;
  Operador:= ' ';
  FlagNumero:= False;
end;

procedure TCalculadoraBasica.DesplazarDigitoALaIzquierda(AOperando: Char);
begin
  FDisplay:= FDisplay + AOperando;
end;

function TCalculadoraBasica.ExisteError: Boolean;
begin
  Result:= False;
end;

procedure TCalculadoraBasica.IntroduceDigito(AOperando: Char);
begin
  if AOperando = ',' then
    FDisplay:= '0' + AOperando
  else
    FDisplay:= AOperando;

  if FDisplay <> '0' then FlagNumero:= True;
end;

function TCalculadoraBasica.LeeDisplay: String;
begin
  Result:= FDisplay
end;

function TCalculadoraBasica.ProcesarDigito(const ALexema: Char): String;
begin
   if FlagNumero then
    begin
      if Length(FDisplay) < MaxDigitos then
      begin
         if (FDisplay = '0') and (ALexema = '0') then
           Exit(LeeDisplay)
         else
          begin
            //evaluamos si ya exite el punto decimal
            if (ALexema = ',') and (StrScan(Pchar(FDisplay), ',') <> nil) then
              Exit(LeeDisplay);

            DesplazarDigitoALaIzquierda(ALexema);
          end;
      end;
    end
   else
    IntroduceDigito(ALexema);

   Result:= LeeDisplay;
end;

function TCalculadoraBasica.ProcesarOperacion(const ALexema: Char): String;
begin
   case Operador of
     ' ','=' : Operando:= StrToFloat(FDisplay);
     '+' : Operando:= Operando + StrToFloat(FDisplay);
     '-' : Operando:= Operando - StrToFloat(FDisplay);
     'x' : Operando:= Operando * StrToFloat(FDisplay);
     '/' : Operando:= Operando / StrToFloat(FDisplay);
   end;
   ActualizaDisplay(FloatToStr(Operando));
   FlagNumero:= False;
   Operador:= ALexema;

   Result:= LeeDisplay;
end;

function TCalculadoraBasica.Reset: String;
begin
  DoReset;
  Result:= LeeDisplay;
end;

procedure TCalculadoraBasica.DoReset;
begin
   if FDisplay = '0' then
    begin
      Operando:= 0;
      Operador:= ' ';
    end
   else
      FDisplay:= '0';
   FlagNumero:= False;
end;

end.
