unit UMain;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs, FMX.StdCtrls,
  UCalculadora;

type
  TfrmCalculadoraTrad = class(TForm)
    bnSiete: TButton;
    bnOcho: TButton;
    bnNueve: TButton;
    bnCuatro: TButton;
    bnCinco: TButton;
    bnSeis: TButton;
    bnUno: TButton;
    bnDos: TButton;
    bnTres: TButton;
    bnCero: TButton;
    bnDobleCero: TButton;
    bnPuntoDecimal: TButton;
    bnResultado: TButton;
    bnDivision: TButton;
    bnMultiplicacion: TButton;
    bnResta: TButton;
    bnSuma: TButton;
    lbDisplay: TLabel;
    btnAC: TButton;
    procedure bnDobleCeroClick(Sender: TObject);
    procedure btnACClick(Sender: TObject);
    procedure btnClick(Sender: TObject);
    procedure bnOperarClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure bnPuntoDecimalClick(Sender: TObject);
  private
    { Private declarations }
    FCalculadora: TCalculadoraBasica;
  public
    { Public declarations }
  end;

var
  frmCalculadoraTrad: TfrmCalculadoraTrad;

implementation

{$R *.fmx}
{$R *.iPhone4in.fmx IOS}
{$R *.iPhone55in.fmx IOS}
{$R *.iPhone47in.fmx IOS}

procedure TfrmCalculadoraTrad.btnClick(Sender: TObject);
begin
  lbDisplay.Text:= FCalculadora.ProcesarDigito((Sender as TButton).Text.Chars[0]);
end;

procedure TfrmCalculadoraTrad.FormCreate(Sender: TObject);
begin
   FCalculadora:= TCalculadoraBasica.Create(Self);
end;

procedure TfrmCalculadoraTrad.bnOperarClick(Sender: TObject);
begin
  lbDisplay.Text:= FCalculadora.ProcesarOperacion((Sender as TButton).Text.Chars[0]);
end;

procedure TfrmCalculadoraTrad.bnPuntoDecimalClick(Sender: TObject);
begin
  lbDisplay.Text:= FCalculadora.ProcesarDigito(',');
end;

procedure TfrmCalculadoraTrad.bnDobleCeroClick(Sender: TObject);
begin
                   FCalculadora.ProcesarDigito('0');
  lbDisplay.Text:= FCalculadora.ProcesarDigito('0');
end;

procedure TfrmCalculadoraTrad.btnACClick(Sender: TObject);
begin
  FCalculadora.Reset;
  lbDisplay.Text:= '0';
end;





end.
