unit UCalculadora;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls;

type
  TfrmCalculadoraTrad = class(TForm)
    lbDisplay: TLabel;
    btn7: TButton;
    btn8: TButton;
    btn9: TButton;
    btn4: TButton;
    btn5: TButton;
    btn6: TButton;
    btn1: TButton;
    btn2: TButton;
    btn3: TButton;
    btn0: TButton;
    btn00: TButton;
    btnPuntoDecimal: TButton;
    btnIgual: TButton;
    btnDividir: TButton;
    btnMultiplicar: TButton;
    btnRestar: TButton;
    btnSumar: TButton;
    btnAC: TButton;
    procedure btnClick(Sender: TObject);
    procedure btnPuntoDecimalClick(Sender: TObject);
    procedure btnOperarClick(Sender: TObject);
    procedure btnIgualClick(Sender: TObject);
    procedure btnACClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btn00Click(Sender: TObject);
  private
    { Private declarations }
    FlagNumero: Boolean;
    Operando: Double;
    Operador: Char;
    procedure ProcesarOperacion(AOperador: Char);
    procedure ProcesarDigito(AOperando: Char);
    procedure DesplazarDigitoALaIzquierda(AOperando: Char);
    procedure IntroduceDigito(AOperando: Char);
    procedure ActualizaDisplay(const AOperando: String);
  public
    { Public declarations }
  end;

var
  frmCalculadoraTrad: TfrmCalculadoraTrad;

implementation

{$R *.dfm}

procedure TfrmCalculadoraTrad.btn00Click(Sender: TObject);
begin
  ProcesarDigito('0');
  ProcesarDigito('0');
end;

procedure TfrmCalculadoraTrad.btnACClick(Sender: TObject);
begin
   if lbDisplay.Caption = '0' then
    begin
      Operando:= 0;
      Operador:= ' ';
    end
   else
      lbDisplay.Caption:= '0';
   FlagNumero:= False;
end;

procedure TfrmCalculadoraTrad.btnClick(Sender: TObject);
begin
  ProcesarDigito((Sender as TButton).Caption[1]);
end;

procedure TfrmCalculadoraTrad.btnIgualClick(Sender: TObject);
begin
  ProcesarOperacion(Operador);
  Operador:= ' ';
  Operando:= 0;
end;

procedure TfrmCalculadoraTrad.btnOperarClick(Sender: TObject);
begin
  ProcesarOperacion((Sender as TButton).Caption[1]);
end;

procedure TfrmCalculadoraTrad.btnPuntoDecimalClick(Sender: TObject);
begin
   if FlagNumero then
    begin
       if StrScan(Pchar(lbDisplay.Caption), ',') = nil then
         DesplazarDigitoALaIzquierda(',');
    end
   else
    begin
     DesplazarDigitoALaIzquierda('0');
     IntroduceDigito(',');
    end;
end;

procedure TfrmCalculadoraTrad.DesplazarDigitoALaIzquierda(AOperando: Char);
begin
  lbDisplay.Caption:= lbDisplay.Caption + AOperando;
end;

procedure TfrmCalculadoraTrad.FormCreate(Sender: TObject);
begin
   Operando:= 0;
   Operador:= ' ';
   FlagNumero:= False;
end;

procedure TfrmCalculadoraTrad.IntroduceDigito(AOperando: Char);
begin
  lbDisplay.Caption:= AOperando;
  FlagNumero:= True;
end;

procedure TfrmCalculadoraTrad.ActualizaDisplay(const AOperando: String);
begin
  lbDisplay.Caption:= AOperando;
end;

procedure TfrmCalculadoraTrad.ProcesarOperacion(AOperador: Char);
begin
   case Operador of
     ' ' : Operando:= StrToFloat(lbDisplay.Caption);
     '+' : Operando:= Operando + StrToFloat(lbDisplay.Caption);
     '-' : Operando:= Operando - StrToFloat(lbDisplay.Caption);
     'x' : Operando:= Operando * StrToFloat(lbDisplay.Caption);
     '/' : Operando:= Operando / StrToFloat(lbDisplay.Caption);
   end;
   ActualizaDisplay(FloatToStr(Operando));
   FlagNumero:= False;
   Operador:= AOperador;
end;

procedure TfrmCalculadoraTrad.ProcesarDigito(AOperando: Char);
begin
   if FlagNumero then
    begin
      if Length(lbDisplay.Caption) < 12 then
      begin
         if (lbDisplay.Caption = '0') and (AOperando = '0') then
           Exit
         else
           DesplazarDigitoALaIzquierda(AOperando);
      end;
    end
   else
    IntroduceDigito(AOperando);
end;


end.
