unit HeaderFooterTemplate;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Graphics, FMX.Controls, FMX.Forms, FMX.Dialogs, FMX.StdCtrls,
  Data.DB, DBAccess, Uni, UniProvider, SQLServerUniProvider, System.Rtti,
  System.Bindings.Outputs, Fmx.Bind.Editors, Data.Bind.EngExt,
  Fmx.Bind.DBEngExt, Data.Bind.Components, Data.Bind.DBScope, MemDS, FMX.ListBox,
  FMX.TabControl, System.Actions, FMX.ActnList, uReloj, Generics.Collections;

const
  //maximo de digitos que vamos a permitir
  MAX_DIGIT = 4;


type
  THeaderFooterForm = class(TForm)
    Header: TToolBar;
    Footer: TToolBar;
    HeaderLabel: TLabel;
    Label1: TLabel;
    cbtEntrada: TCornerButton;
    cbtSalida: TCornerButton;
    Panel1: TPanel;
    SQLServerUniProvider1: TSQLServerUniProvider;
    Button1: TButton;
    TabControl1: TTabControl;
    TabItem1: TTabItem;
    TabItem2: TTabItem;
    btn7: TButton;
    btn8: TButton;
    btn9: TButton;
    btn6: TButton;
    btn5: TButton;
    btn4: TButton;
    btn1: TButton;
    btn2: TButton;
    btn3: TButton;
    btnOK: TButton;
    btnC: TButton;
    btn0: TButton;
    labDisplay: TLabel;
    AUTENTIFICACION: TLabel;
    ActionList1: TActionList;
    NextTabAction1: TNextTabAction;
    acAnotarMovimiento: TAction;
    labAnotacionEmpleado: TLabel;
    labHora: TLabel;
    tiReloj: TTimer;
    PreviousTabAction1: TPreviousTabAction;
    Button3: TButton;
    labEmpleado: TLabel;
    spRegistrarMovimiento: TUniStoredProc;
    acSendData: TAction;
    Button4: TButton;
    cbtCancelar: TCornerButton;
    acCancelar: TAction;
    acOkEnvio: TAction;
    lbTimeToFinish: TLabel;
    bnSave: TButton;
    Conexion: TUniConnection;
    procedure DigitoClick(Sender: TObject);
    procedure cbtEntradaSalidaClick(Sender: TObject);
    procedure acAnotarMovimientoExecute(Sender: TObject);
    procedure acAnotarMovimientoUpdate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure acSendDataExecute(Sender: TObject);
    procedure acSendDataUpdate(Sender: TObject);
    procedure acCancelarExecute(Sender: TObject);
    procedure acCancelarUpdate(Sender: TObject);
    procedure acOkEnvioExecute(Sender: TObject);
    procedure acOkEnvioUpdate(Sender: TObject);
    procedure FormSaveState(Sender: TObject);
    procedure bnSaveClick(Sender: TObject);
  private
    fEmpleado: TEmpleado;
    FOnFinish: TNotifyEvent;
    FValor: string;
    procedure ActivaInterfaz(const AActivo: Boolean);
    procedure SetOnFinish(const Value: TNotifyEvent);
    procedure DoBeforeAnotacion(Sender: TObject);
    procedure DoRelease(Sender: TObject);
    procedure EventoReloj(Sender: TObject);
    function  InicializaEmpleado(Sender: TObject): TEmpleado;
    procedure InicializaInterfaz;
  protected
    procedure DoFinish; virtual;
  public
    property Valor: string read FValor;
    property OnFinish: TNotifyEvent read FOnFinish write SetOnFinish;
  end;

var
  HeaderFooterForm: THeaderFooterForm;

implementation

{$R *.fmx}
{$R *.iPhone4in.fmx IOS}
{$R *.NmXhdpiPh.fmx ANDROID}
{$R *.Windows.fmx MSWINDOWS}

uses DateUtils;

function THeaderFooterForm.InicializaEmpleado(Sender: TObject): TEmpleado;
begin
  Result:= TEmpleado.Instance;
  //creamos la instancia de TEmpleado
  with Result do
  begin
     if (Sender as TAction).Name='acAnotarMovimiento' then
       OnBeforeAnotacion:= DoBeforeAnotacion
     else OnBeforeAnotacion:= Nil;
     OnRelease:= DoRelease;
     SetIdentidad;
  end;
  labEmpleado.Text:= Result.GetNombreCompleto;
end;


procedure THeaderFooterForm.acAnotarMovimientoExecute(Sender: TObject);
begin
  TabControl1.TabIndex:= 0;
  fEmpleado:= InicializaEmpleado(Sender);
  labAnotacionEmpleado.Text:= 'Pulsa [ENTRADA / SALIDA] para finalizar...';
end;

procedure THeaderFooterForm.acAnotarMovimientoUpdate(Sender: TObject);
begin
  acAnotarMovimiento.Enabled:= (not Assigned(FEmpleado)) or (not FEmpleado.EnProceso);
end;

procedure THeaderFooterForm.acCancelarExecute(Sender: TObject);
begin
  FEmpleado.CancelarMovimiento;
end;

procedure THeaderFooterForm.acCancelarUpdate(Sender: TObject);
begin
  acCancelar.Enabled:= (Assigned(FEmpleado)) and (FEmpleado.EnProceso);
end;

procedure THeaderFooterForm.acOkEnvioExecute(Sender: TObject);
var
  fList: TList<TInfoRegistro>;
  i: Integer;
  iCount: Integer;
begin
  iCount:= 0;
  if Assigned(FEmpleado) then
  begin
      //comprobamos el password del empleado
      if not FEmpleado.AutentificarEmpleado(fValor) then
      begin
        TEmpleado.ReleaseInstance;
        Raise Exception.Create('Error de autentificacion');
      end;

      fList:= TList<TInfoRegistro>.Create;
      try
        fList.AddRange(FEmpleado.GetRegistrosHorarios);
        for i:= 0 to FList.Count-1 do
        begin
          if FEmpleado.Id_Empleado = FList[i].IDEmpleado then
          begin
            spRegistrarMovimiento.Params.ParamByName('IDEmpleado').Value:= FList[i].IDEmpleado;
            spRegistrarMovimiento.Params.ParamByName('HoraRegistro').Value:= FList[i].Hora;
            spRegistrarMovimiento.Params.ParamByName('IDTipo').Value:= FList[i].IDTipo;
            spRegistrarMovimiento.ExecProc;
            if spRegistrarMovimiento.Params.ParamByName('IDMovimiento').AsInteger > 0 then
            begin
              FEmpleado.MarcarEnviado(FList[i].Index);
              Inc(iCount);
            end;
          end;
        end;
      finally
        fList.Free;
      end;
      TEmpleado.DeleteMovimientos;
  end;
  TEmpleado.ReleaseInstance;

  case iCount of
    0:labAnotacionEmpleado.Text:= 'No existen registros que enviar...';
    1:labAnotacionEmpleado.Text:= 'Enviado 1 registro...';
    else
      labAnotacionEmpleado.Text:= 'Enviados ' + iCount.ToString + ' registros...';
  end;
end;

procedure THeaderFooterForm.acOkEnvioUpdate(Sender: TObject);
begin
  acOkEnvio.Enabled:= labDisplay.Text.Length >= MAX_DIGIT;
end;

procedure THeaderFooterForm.acSendDataExecute(Sender: TObject);
begin
  TabControl1.TabIndex:= 1;
  fEmpleado:= InicializaEmpleado(Sender);
end;

procedure THeaderFooterForm.acSendDataUpdate(Sender: TObject);
begin
   acSendData.Enabled:= (not Assigned(FEmpleado)) or (not FEmpleado.EnProceso);
end;

procedure THeaderFooterForm.ActivaInterfaz(const AActivo: Boolean);
begin
  cbtEntrada.Enabled:= AActivo;
  cbtSalida.Enabled:= AActivo;
end;

procedure THeaderFooterForm.bnSaveClick(Sender: TObject);
begin
  TEmpleado.GuardarMovimientos;
  labAnotacionEmpleado.Text:= 'Datos guardados en cach local...';
end;

procedure THeaderFooterForm.cbtEntradaSalidaClick(Sender: TObject);
begin
  labHora.Text:= FormatDateTime('hh:mm:ss', Now);
  FEmpleado.RegistrarMovimiento((Sender as TComponent).Tag);
end;


procedure THeaderFooterForm.DigitoClick(Sender: TObject);
var
  s: string;
  i: Integer;
begin
  s:= fValor;
  case (Sender as TButton).Tag of
     -1: if length(s) > 0 then
            s:= copy(s, 1, length(s)-1);
     0..9: if length(s) < MAX_DIGIT then
              s:= s + (Sender as TButton).Text;
  end;
  fValor:= s;
  for i:= low(s) to length(s) do s[i]:= '*';
  labDisplay.Text:= s;
end;

procedure THeaderFooterForm.DoBeforeAnotacion(Sender: TObject);
begin
  ActivaInterfaz(True);
end;

procedure THeaderFooterForm.DoFinish;
begin
  if Assigned(FOnFinish) then FOnFinish(self);
end;

procedure THeaderFooterForm.DoRelease(Sender: TObject);
begin
  FEmpleado:= nil;
  InicializaInterfaz;
end;

procedure THeaderFooterForm.EventoReloj(Sender: TObject);
begin
  labHora.Text:= FormatDateTime('hh:mm:ss', Now);
  if Assigned(FEmpleado) then
    lbTimeToFinish.Text:= FormatDateTime('h:mm:ss', FEmpleado.TimeToFinish-Now)
  else lbTimeToFinish.Text:= '';
end;

procedure THeaderFooterForm.FormCreate(Sender: TObject);
begin
  //inicializacion del componente TTimer
  with tiReloj do begin
     Enabled:= True;
     OnTimer:= EventoReloj;
     Interval:= 1000;
  end;
  EventoReloj(nil);
  InicializaInterfaz;
end;

procedure THeaderFooterForm.FormSaveState(Sender: TObject);
begin
  TEmpleado.GuardarMovimientos;
end;

procedure THeaderFooterForm.InicializaInterfaz;
begin
  TabControl1.TabIndex:= 0;
  labAnotacionEmpleado.Text:= '';
  fValor:= '';
  labDisplay.Text:= '';
  ActivaInterfaz(False);
end;

procedure THeaderFooterForm.SetOnFinish(const Value: TNotifyEvent);
begin
  FOnFinish := Value;
end;


end.
