unit HeaderFooterFormwithNavigation;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Graphics, FMX.Forms, FMX.Dialogs, FMX.TabControl, System.Actions, FMX.ActnList,
  FMX.Objects, FMX.StdCtrls, FMX.Layouts, FMX.TreeView, System.Rtti,
  System.Bindings.Outputs, Fmx.Bind.Editors, Data.Bind.EngExt,
  Fmx.Bind.DBEngExt, Data.Bind.Components, Data.Bind.DBScope, Data.DB, MemDS,
  DBAccess, Uni, FMX.ListBox, UniProvider, SQLServerUniProvider,
  FMX.Controls.Presentation, FMX.Edit, FMX.DateTimeCtrls, FMX.ListView.Types,
  FMX.ListView, UniDacFmx;

type
  THeaderFooterwithNavigation = class(TForm)
    ActionList1: TActionList;
    PreviousTabAction1: TPreviousTabAction;
    TitleAction: TControlAction;
    NextTabAction1: TNextTabAction;
    TopToolBar: TToolBar;
    ToolBarLabel: TLabel;
    btnNext: TSpeedButton;
    TabControl1: TTabControl;
    TabItem1: TTabItem;
    TabItem2: TTabItem;
    BottomToolBar: TToolBar;
    SQLServerUniProvider1: TSQLServerUniProvider;
    dsEmpleados: TUniDataSource;
    btnBack: TSpeedButton;
    Layout1: TLayout;
    SelectorEmpleados: TUniQuery;
    SelectorEmpleadosIDEmpleado: TIntegerField;
    SelectorEmpleadosNombreEmpleado: TStringField;
    BindSourceDB1: TBindSourceDB;
    BindingsList1: TBindingsList;
    DetalleEmpleado: TUniTable;
    edNombre: TEdit;
    Label2: TLabel;
    BindSourceDB2: TBindSourceDB;
    LinkControlToField1: TLinkControlToField;
    edApellido1: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    edApellido2: TEdit;
    FechaAlta: TLabel;
    Switch1: TSwitch;
    edFechaAlta: TDateEdit;
    LinkControlToField3: TLinkControlToField;
    LinkControlToField4: TLinkControlToField;
    LinkControlToField5: TLinkControlToField;
    edTarjeta: TEdit;
    edPassword: TEdit;
    Label5: TLabel;
    Label6: TLabel;
    lbEstadoConexion: TLabel;
    LinkControlToField2: TLinkControlToField;
    LinkControlToField6: TLinkControlToField;
    Panel1: TPanel;
    lbtxtUltimoRegistro: TLabel;
    lbUltimoRegistro: TLabel;
    LinkPropertyToFieldText: TLinkPropertyToField;
    ListView1: TListView;
    RegistrosHorarios: TUniQuery;
    dsDetalleEmpleado: TUniDataSource;
    Label1: TLabel;
    cbxSelectorEmpleados: TComboBox;
    DetalleEmpleadoIDEmpleado: TIntegerField;
    DetalleEmpleadoNombre: TStringField;
    DetalleEmpleadoApellido1: TStringField;
    DetalleEmpleadoApellido2: TStringField;
    DetalleEmpleadoTarjeta: TStringField;
    DetalleEmpleadoPassword: TStringField;
    DetalleEmpleadoIDEmpresa: TIntegerField;
    DetalleEmpleadoFechaAlta: TDateTimeField;
    DetalleEmpleadoUltimoRegistro: TDateTimeField;
    RegistrosHorariosIDRegistro: TLargeintField;
    RegistrosHorariosIDEmpleado: TIntegerField;
    RegistrosHorariosNombreEmpleado: TStringField;
    RegistrosHorariosIDEmpresa: TIntegerField;
    RegistrosHorariosFechaRegistro: TDateTimeField;
    BindSourceDB3: TBindSourceDB;
    LinkListControlToField2: TLinkListControlToField;
    Label7: TLabel;
    LinkListControlToField1: TLinkListControlToField;
    LinkPropertyToFieldText2: TLinkPropertyToField;
    Label8: TLabel;
    Empresas: TUniTable;
    UniTable1IDEmpresa: TIntegerField;
    UniTable1Nombre: TStringField;
    SelectorEmpleadosIDEmpresa: TIntegerField;
    SelectorEmpleadosEmpresa: TStringField;
    Label9: TLabel;
    LinkPropertyToFieldText3: TLinkPropertyToField;
    UniConnectDialogFmx1: TUniConnectDialogFmx;
    Conexion: TUniConnection;
    procedure FormCreate(Sender: TObject);
    procedure TitleActionUpdate(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word; var KeyChar: Char; Shift: TShiftState);
    procedure Switch1Switch(Sender: TObject);
  private
    { Private declarations }
    procedure AbrirTablas;
  public
    { Public declarations }
  end;

var
  HeaderFooterwithNavigation: THeaderFooterwithNavigation;

implementation

{$R *.fmx}
{$R *.Macintosh.fmx _MACOS}
{$R *.NmXhdpiPh.fmx ANDROID}
{$R *.Windows.fmx MSWINDOWS}

procedure THeaderFooterwithNavigation.TitleActionUpdate(Sender: TObject);
begin
  if Sender is TCustomAction then
  begin
    if TabControl1.ActiveTab <> nil then
      TCustomAction(Sender).Text := TabControl1.ActiveTab.Text
    else
      TCustomAction(Sender).Text := '';
  end;
end;

procedure THeaderFooterwithNavigation.AbrirTablas;
begin
   Empresas.Open;
   SelectorEmpleados.Open;
   DetalleEmpleado.Open;
   RegistrosHorarios.Open;
end;

procedure THeaderFooterwithNavigation.FormCreate(Sender: TObject);
begin
  { This defines the default active tab at runtime }
  TabControl1.First(TTabTransition.None);
end;

procedure THeaderFooterwithNavigation.FormKeyUp(Sender: TObject; var Key: Word; var KeyChar: Char; Shift: TShiftState);
begin
  if (Key = vkHardwareBack) and (TabControl1.TabIndex <> 0) then
  begin
    TabControl1.First;
    Key := 0;
  end;
end;

procedure THeaderFooterwithNavigation.Switch1Switch(Sender: TObject);
begin
  case Switch1.IsChecked of
    True:   begin
               Conexion.Open;
               lbEstadoConexion.Text:= 'Conectado';
               AbrirTablas;
            end;
    False:  begin
               Conexion.Close;
               lbEstadoConexion.Text:= 'Desconectado';
            end;
  end;
end;

end.
